package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamTagFluentImpl<A extends ImageStreamTagFluent<A>> extends BaseFluent<A> implements ImageStreamTagFluent<A>{
  public ImageStreamTagFluentImpl() {
  }
  public ImageStreamTagFluentImpl(ImageStreamTag instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withGeneration(instance.getGeneration()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withLookupPolicy(instance.getLookupPolicy()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTag(instance.getTag()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<TagEventConditionBuilder> conditions = new ArrayList<TagEventConditionBuilder>();
  private Long generation;
  private ImageBuilder image;
  private String kind;
  private ImageLookupPolicyBuilder lookupPolicy;
  private ObjectMetaBuilder metadata;
  private TagReferenceBuilder tag;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToConditions(Integer index,TagEventCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,TagEventCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.TagEventCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<TagEventCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.TagEventCondition... items) {
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<TagEventCondition> items) {
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<TagEventConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<TagEventConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      TagEventConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TagEventCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<TagEventCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public TagEventCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public TagEventCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public TagEventCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public TagEventCondition buildMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    for (TagEventConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    for (TagEventConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<TagEventCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (TagEventCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.TagEventCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (TagEventCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ImageStreamTagFluent.ConditionsNested<A> addNewCondition() {
    return new ImageStreamTagFluentImpl.ConditionsNestedImpl();
  }
  public ImageStreamTagFluent.ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
    return new ImageStreamTagFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ImageStreamTagFluent.ConditionsNested<A> setNewConditionLike(Integer index,TagEventCondition item) {
    return new ImageStreamTagFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ImageStreamTagFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ImageStreamTagFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ImageStreamTagFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ImageStreamTagFluent.ConditionsNested<A> editMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getGeneration() {
    return this.generation;
  }
  public A withGeneration(Long generation) {
    this.generation=generation; return (A) this;
  }
  public Boolean hasGeneration() {
    return this.generation != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public ImageStreamTagFluent.ImageNested<A> withNewImage() {
    return new ImageStreamTagFluentImpl.ImageNestedImpl();
  }
  public ImageStreamTagFluent.ImageNested<A> withNewImageLike(Image item) {
    return new ImageStreamTagFluentImpl.ImageNestedImpl(item);
  }
  public ImageStreamTagFluent.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public ImageStreamTagFluent.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
  }
  public ImageStreamTagFluent.ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLookupPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageLookupPolicy getLookupPolicy() {
    return this.lookupPolicy!=null ?this.lookupPolicy.build():null;
  }
  public ImageLookupPolicy buildLookupPolicy() {
    return this.lookupPolicy!=null ?this.lookupPolicy.build():null;
  }
  public A withLookupPolicy(ImageLookupPolicy lookupPolicy) {
    _visitables.get("lookupPolicy").remove(this.lookupPolicy);
    if (lookupPolicy!=null){ this.lookupPolicy= new ImageLookupPolicyBuilder(lookupPolicy); _visitables.get("lookupPolicy").add(this.lookupPolicy);} else { this.lookupPolicy = null; _visitables.get("lookupPolicy").remove(this.lookupPolicy); } return (A) this;
  }
  public Boolean hasLookupPolicy() {
    return this.lookupPolicy != null;
  }
  public A withNewLookupPolicy(Boolean local) {
    return (A)withLookupPolicy(new ImageLookupPolicy(local));
  }
  public ImageStreamTagFluent.LookupPolicyNested<A> withNewLookupPolicy() {
    return new ImageStreamTagFluentImpl.LookupPolicyNestedImpl();
  }
  public ImageStreamTagFluent.LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item) {
    return new ImageStreamTagFluentImpl.LookupPolicyNestedImpl(item);
  }
  public ImageStreamTagFluent.LookupPolicyNested<A> editLookupPolicy() {
    return withNewLookupPolicyLike(getLookupPolicy());
  }
  public ImageStreamTagFluent.LookupPolicyNested<A> editOrNewLookupPolicy() {
    return withNewLookupPolicyLike(getLookupPolicy() != null ? getLookupPolicy(): new ImageLookupPolicyBuilder().build());
  }
  public ImageStreamTagFluent.LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item) {
    return withNewLookupPolicyLike(getLookupPolicy() != null ? getLookupPolicy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ImageStreamTagFluent.MetadataNested<A> withNewMetadata() {
    return new ImageStreamTagFluentImpl.MetadataNestedImpl();
  }
  public ImageStreamTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ImageStreamTagFluentImpl.MetadataNestedImpl(item);
  }
  public ImageStreamTagFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ImageStreamTagFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ImageStreamTagFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTag instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagReference getTag() {
    return this.tag!=null ?this.tag.build():null;
  }
  public TagReference buildTag() {
    return this.tag!=null ?this.tag.build():null;
  }
  public A withTag(TagReference tag) {
    _visitables.get("tag").remove(this.tag);
    if (tag!=null){ this.tag= new TagReferenceBuilder(tag); _visitables.get("tag").add(this.tag);} else { this.tag = null; _visitables.get("tag").remove(this.tag); } return (A) this;
  }
  public Boolean hasTag() {
    return this.tag != null;
  }
  public ImageStreamTagFluent.TagNested<A> withNewTag() {
    return new ImageStreamTagFluentImpl.TagNestedImpl();
  }
  public ImageStreamTagFluent.TagNested<A> withNewTagLike(TagReference item) {
    return new ImageStreamTagFluentImpl.TagNestedImpl(item);
  }
  public ImageStreamTagFluent.TagNested<A> editTag() {
    return withNewTagLike(getTag());
  }
  public ImageStreamTagFluent.TagNested<A> editOrNewTag() {
    return withNewTagLike(getTag() != null ? getTag(): new TagReferenceBuilder().build());
  }
  public ImageStreamTagFluent.TagNested<A> editOrNewTagLike(TagReference item) {
    return withNewTagLike(getTag() != null ? getTag(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageStreamTagFluentImpl that = (ImageStreamTagFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (lookupPolicy != null ? !lookupPolicy.equals(that.lookupPolicy) :that.lookupPolicy != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  conditions,  generation,  image,  kind,  lookupPolicy,  metadata,  tag,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (generation != null) { sb.append("generation:"); sb.append(generation + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (lookupPolicy != null) { sb.append("lookupPolicy:"); sb.append(lookupPolicy + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends TagEventConditionFluentImpl<ImageStreamTagFluent.ConditionsNested<N>> implements ImageStreamTagFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,TagEventCondition item) {
      this.index = index;
      this.builder = new TagEventConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new TagEventConditionBuilder(this);
    }
    TagEventConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<ImageStreamTagFluent.ImageNested<N>> implements ImageStreamTagFluent.ImageNested<N>,Nested<N>{
    ImageNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class LookupPolicyNestedImpl<N> extends ImageLookupPolicyFluentImpl<ImageStreamTagFluent.LookupPolicyNested<N>> implements ImageStreamTagFluent.LookupPolicyNested<N>,Nested<N>{
    LookupPolicyNestedImpl(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    LookupPolicyNestedImpl() {
      this.builder = new ImageLookupPolicyBuilder(this);
    }
    ImageLookupPolicyBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.withLookupPolicy(builder.build());
    }
    public N endLookupPolicy() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageStreamTagFluent.MetadataNested<N>> implements ImageStreamTagFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class TagNestedImpl<N> extends TagReferenceFluentImpl<ImageStreamTagFluent.TagNested<N>> implements ImageStreamTagFluent.TagNested<N>,Nested<N>{
    TagNestedImpl(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagNestedImpl() {
      this.builder = new TagReferenceBuilder(this);
    }
    TagReferenceBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.withTag(builder.build());
    }
    public N endTag() {
      return and();
    }
    
  }
  
}