package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostSubnetListBuilder extends HostSubnetListFluentImpl<HostSubnetListBuilder> implements VisitableBuilder<HostSubnetList,HostSubnetListBuilder>{
  public HostSubnetListBuilder() {
    this(false);
  }
  public HostSubnetListBuilder(Boolean validationEnabled) {
    this(new HostSubnetList(), validationEnabled);
  }
  public HostSubnetListBuilder(HostSubnetListFluent<?> fluent) {
    this(fluent, false);
  }
  public HostSubnetListBuilder(HostSubnetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HostSubnetList(), validationEnabled);
  }
  public HostSubnetListBuilder(HostSubnetListFluent<?> fluent,HostSubnetList instance) {
    this(fluent, instance, false);
  }
  public HostSubnetListBuilder(HostSubnetListFluent<?> fluent,HostSubnetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HostSubnetListBuilder(HostSubnetList instance) {
    this(instance,false);
  }
  public HostSubnetListBuilder(HostSubnetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HostSubnetListFluent<?> fluent;
  Boolean validationEnabled;
  public HostSubnetList build() {
    HostSubnetList buildable = new HostSubnetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}