package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmChartRepositoryListBuilder extends HelmChartRepositoryListFluentImpl<HelmChartRepositoryListBuilder> implements VisitableBuilder<HelmChartRepositoryList,HelmChartRepositoryListBuilder>{
  public HelmChartRepositoryListBuilder() {
    this(false);
  }
  public HelmChartRepositoryListBuilder(Boolean validationEnabled) {
    this(new HelmChartRepositoryList(), validationEnabled);
  }
  public HelmChartRepositoryListBuilder(HelmChartRepositoryListFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmChartRepositoryListBuilder(HelmChartRepositoryListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmChartRepositoryList(), validationEnabled);
  }
  public HelmChartRepositoryListBuilder(HelmChartRepositoryListFluent<?> fluent,HelmChartRepositoryList instance) {
    this(fluent, instance, false);
  }
  public HelmChartRepositoryListBuilder(HelmChartRepositoryListFluent<?> fluent,HelmChartRepositoryList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HelmChartRepositoryListBuilder(HelmChartRepositoryList instance) {
    this(instance,false);
  }
  public HelmChartRepositoryListBuilder(HelmChartRepositoryList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HelmChartRepositoryListFluent<?> fluent;
  Boolean validationEnabled;
  public HelmChartRepositoryList build() {
    HelmChartRepositoryList buildable = new HelmChartRepositoryList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}