package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface SourceBuildStrategyFluent<A extends SourceBuildStrategyFluent<A>> extends Fluent<A>{
  public A addToEnv(Integer index,EnvVar item);
  public A setToEnv(Integer index,EnvVar item);
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items);
  public A addAllToEnv(Collection<EnvVar> items);
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items);
  public A removeAllFromEnv(Collection<EnvVar> items);
  public List<EnvVar> getEnv();
  public EnvVar getEnv(Integer index);
  public EnvVar getFirstEnv();
  public EnvVar getLastEnv();
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
  public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
  public A withEnv(List<EnvVar> env);
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env);
  public Boolean hasEnv();
  public Boolean getForcePull();
  public A withForcePull(Boolean forcePull);
  public Boolean hasForcePull();
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom();
  public ObjectReference buildFrom();
  public A withFrom(ObjectReference from);
  public Boolean hasFrom();
  public SourceBuildStrategyFluent.FromNested<A> withNewFrom();
  public SourceBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item);
  public SourceBuildStrategyFluent.FromNested<A> editFrom();
  public SourceBuildStrategyFluent.FromNested<A> editOrNewFrom();
  public SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item);
  public Boolean getIncremental();
  public A withIncremental(Boolean incremental);
  public Boolean hasIncremental();
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPullSecret();
  public LocalObjectReference buildPullSecret();
  public A withPullSecret(LocalObjectReference pullSecret);
  public Boolean hasPullSecret();
  public A withNewPullSecret(String name);
  public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
  public SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
  public SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret();
  public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret();
  public SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
  public String getScripts();
  public A withScripts(String scripts);
  public Boolean hasScripts();
  public A addToVolumes(Integer index,BuildVolume item);
  public A setToVolumes(Integer index,BuildVolume item);
  public A addToVolumes(io.fabric8.openshift.api.model.BuildVolume... items);
  public A addAllToVolumes(Collection<BuildVolume> items);
  public A removeFromVolumes(io.fabric8.openshift.api.model.BuildVolume... items);
  public A removeAllFromVolumes(Collection<BuildVolume> items);
  public A removeMatchingFromVolumes(Predicate<BuildVolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildVolume> getVolumes();
  public List<BuildVolume> buildVolumes();
  public BuildVolume buildVolume(Integer index);
  public BuildVolume buildFirstVolume();
  public BuildVolume buildLastVolume();
  public BuildVolume buildMatchingVolume(Predicate<BuildVolumeBuilder> predicate);
  public Boolean hasMatchingVolume(Predicate<BuildVolumeBuilder> predicate);
  public A withVolumes(List<BuildVolume> volumes);
  public A withVolumes(io.fabric8.openshift.api.model.BuildVolume... volumes);
  public Boolean hasVolumes();
  public SourceBuildStrategyFluent.VolumesNested<A> addNewVolume();
  public SourceBuildStrategyFluent.VolumesNested<A> addNewVolumeLike(BuildVolume item);
  public SourceBuildStrategyFluent.VolumesNested<A> setNewVolumeLike(Integer index,BuildVolume item);
  public SourceBuildStrategyFluent.VolumesNested<A> editVolume(Integer index);
  public SourceBuildStrategyFluent.VolumesNested<A> editFirstVolume();
  public SourceBuildStrategyFluent.VolumesNested<A> editLastVolume();
  public SourceBuildStrategyFluent.VolumesNested<A> editMatchingVolume(Predicate<BuildVolumeBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withForcePull();
  public A withIncremental();
  public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<SourceBuildStrategyFluent.FromNested<N>>{
    public N and();
    public N endFrom();
    
  }
  public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<SourceBuildStrategyFluent.PullSecretNested<N>>{
    public N and();
    public N endPullSecret();
    
  }
  public interface VolumesNested<N> extends Nested<N>,BuildVolumeFluent<SourceBuildStrategyFluent.VolumesNested<N>>{
    public N and();
    public N endVolume();
    
  }
  
}