package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IdentityFluent<A extends IdentityFluent<A>> extends BaseFluent<A>{
  public IdentityFluent() {
  }
  
  public IdentityFluent(Identity instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private Map<String,String> extra;
  private String kind;
  private ObjectMetaBuilder metadata;
  private String providerName;
  private String providerUserName;
  private ObjectReferenceBuilder user;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Identity instance) {
    instance = (instance != null ? instance : new Identity());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withExtra(instance.getExtra());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withProviderName(instance.getProviderName());
          this.withProviderUserName(instance.getProviderUserName());
          this.withUser(instance.getUser());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToExtra(String key,String value) {
    if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap(); }
    if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
  }
  
  public A addToExtra(Map<String,String> map) {
    if(this.extra == null && map != null) { this.extra = new LinkedHashMap(); }
    if(map != null) { this.extra.putAll(map);} return (A)this;
  }
  
  public A removeFromExtra(String key) {
    if(this.extra == null) { return (A) this; }
    if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
  }
  
  public A removeFromExtra(Map<String,String> map) {
    if(this.extra == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getExtra() {
    return this.extra;
  }
  
  public <K,V>A withExtra(Map<String,String> extra) {
    if (extra == null) {
      this.extra = null;
    } else {
      this.extra = new LinkedHashMap(extra);
    }
    return (A) this;
  }
  
  public boolean hasExtra() {
    return this.extra != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public String getProviderName() {
    return this.providerName;
  }
  
  public A withProviderName(String providerName) {
    this.providerName = providerName;
    return (A) this;
  }
  
  public boolean hasProviderName() {
    return this.providerName != null;
  }
  
  public String getProviderUserName() {
    return this.providerUserName;
  }
  
  public A withProviderUserName(String providerUserName) {
    this.providerUserName = providerUserName;
    return (A) this;
  }
  
  public boolean hasProviderUserName() {
    return this.providerUserName != null;
  }
  
  public ObjectReference buildUser() {
    return this.user != null ? this.user.build() : null;
  }
  
  public A withUser(ObjectReference user) {
    this._visitables.remove("user");
    if (user != null) {
        this.user = new ObjectReferenceBuilder(user);
        this._visitables.get("user").add(this.user);
    } else {
        this.user = null;
        this._visitables.get("user").remove(this.user);
    }
    return (A) this;
  }
  
  public boolean hasUser() {
    return this.user != null;
  }
  
  public UserNested<A> withNewUser() {
    return new UserNested(null);
  }
  
  public UserNested<A> withNewUserLike(ObjectReference item) {
    return new UserNested(item);
  }
  
  public UserNested<A> editUser() {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(null));
  }
  
  public UserNested<A> editOrNewUser() {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public UserNested<A> editOrNewUserLike(ObjectReference item) {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IdentityFluent that = (IdentityFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(extra, that.extra)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(providerName, that.providerName)) return false;
    if (!java.util.Objects.equals(providerUserName, that.providerUserName)) return false;
    if (!java.util.Objects.equals(user, that.user)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  extra,  kind,  metadata,  providerName,  providerUserName,  user,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (extra != null && !extra.isEmpty()) { sb.append("extra:"); sb.append(extra + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (providerName != null) { sb.append("providerName:"); sb.append(providerName + ","); }
    if (providerUserName != null) { sb.append("providerUserName:"); sb.append(providerUserName + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) IdentityFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class UserNested<N> extends ObjectReferenceFluent<UserNested<N>> implements Nested<N>{
    UserNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) IdentityFluent.this.withUser(builder.build());
    }
    
    public N endUser() {
      return and();
    }
    
  
  }

}