package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.Long;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.util.Map;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SubjectAccessReviewFluent<A extends SubjectAccessReviewFluent<A>> extends BaseFluent<A>{
  public SubjectAccessReviewFluent() {
  }
  
  public SubjectAccessReviewFluent(SubjectAccessReview instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private VisitableBuilder<? extends KubernetesResource,?> content;
  private List<String> groups = new ArrayList<String>();
  private Boolean isNonResourceURL;
  private String kind;
  private String namespace;
  private String path;
  private String resource;
  private String resourceAPIGroup;
  private String resourceAPIVersion;
  private String resourceName;
  private List<String> scopes = new ArrayList<String>();
  private String user;
  private String verb;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SubjectAccessReview instance) {
    instance = (instance != null ? instance : new SubjectAccessReview());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withContent(instance.getContent());
          this.withGroups(instance.getGroups());
          this.withIsNonResourceURL(instance.getIsNonResourceURL());
          this.withKind(instance.getKind());
          this.withNamespace(instance.getNamespace());
          this.withPath(instance.getPath());
          this.withResource(instance.getResource());
          this.withResourceAPIGroup(instance.getResourceAPIGroup());
          this.withResourceAPIVersion(instance.getResourceAPIVersion());
          this.withResourceName(instance.getResourceName());
          this.withScopes(instance.getScopes());
          this.withUser(instance.getUser());
          this.withVerb(instance.getVerb());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public KubernetesResource buildContent() {
    return this.content != null ? this.content.build() : null;
  }
  
  public A withContent(KubernetesResource content) {
    if (content == null) {
        this.content = null;
        this._visitables.remove("content");
        return (A) this;
    } else {
        VisitableBuilder<? extends KubernetesResource,?> builder = builder(content);;
        this._visitables.clear();
        this._visitables.get("content").add(builder);
        this.content = builder;
        return (A) this;
    }
  }
  
  public boolean hasContent() {
    return this.content != null;
  }
  
  public GenericWebHookCauseContentNested<A> withNewGenericWebHookCauseContent() {
    return new GenericWebHookCauseContentNested(null);
  }
  
  public GenericWebHookCauseContentNested<A> withNewGenericWebHookCauseContentLike(GenericWebHookCause item) {
    return new GenericWebHookCauseContentNested(item);
  }
  
  public ServiceAccountRestrictionContentNested<A> withNewServiceAccountRestrictionContent() {
    return new ServiceAccountRestrictionContentNested(null);
  }
  
  public ServiceAccountRestrictionContentNested<A> withNewServiceAccountRestrictionContentLike(ServiceAccountRestriction item) {
    return new ServiceAccountRestrictionContentNested(item);
  }
  
  public ScopeRestrictionContentNested<A> withNewScopeRestrictionContent() {
    return new ScopeRestrictionContentNested(null);
  }
  
  public ScopeRestrictionContentNested<A> withNewScopeRestrictionContentLike(ScopeRestriction item) {
    return new ScopeRestrictionContentNested(item);
  }
  
  public SecretLocalReferenceContentNested<A> withNewSecretLocalReferenceContent() {
    return new SecretLocalReferenceContentNested(null);
  }
  
  public SecretLocalReferenceContentNested<A> withNewSecretLocalReferenceContentLike(SecretLocalReference item) {
    return new SecretLocalReferenceContentNested(item);
  }
  
  public A withNewSecretLocalReferenceContent(String name) {
    return (A)withContent(new SecretLocalReference(name));
  }
  
  public StepInfoContentNested<A> withNewStepInfoContent() {
    return new StepInfoContentNested(null);
  }
  
  public StepInfoContentNested<A> withNewStepInfoContentLike(StepInfo item) {
    return new StepInfoContentNested(item);
  }
  
  public A withNewStepInfoContent(Long durationMilliseconds,String name,String startTime) {
    return (A)withContent(new StepInfo(durationMilliseconds, name, startTime));
  }
  
  public UserRestrictionContentNested<A> withNewUserRestrictionContent() {
    return new UserRestrictionContentNested(null);
  }
  
  public UserRestrictionContentNested<A> withNewUserRestrictionContentLike(UserRestriction item) {
    return new UserRestrictionContentNested(item);
  }
  
  public PodTemplateSpecContentNested<A> withNewPodTemplateSpecContent() {
    return new PodTemplateSpecContentNested(null);
  }
  
  public PodTemplateSpecContentNested<A> withNewPodTemplateSpecContentLike(PodTemplateSpec item) {
    return new PodTemplateSpecContentNested(item);
  }
  
  public ProjectHelmChartRepositoryContentNested<A> withNewProjectHelmChartRepositoryContent() {
    return new ProjectHelmChartRepositoryContentNested(null);
  }
  
  public ProjectHelmChartRepositoryContentNested<A> withNewProjectHelmChartRepositoryContentLike(ProjectHelmChartRepository item) {
    return new ProjectHelmChartRepositoryContentNested(item);
  }
  
  public TemplateInstanceListContentNested<A> withNewTemplateInstanceListContent() {
    return new TemplateInstanceListContentNested(null);
  }
  
  public TemplateInstanceListContentNested<A> withNewTemplateInstanceListContentLike(TemplateInstanceList item) {
    return new TemplateInstanceListContentNested(item);
  }
  
  public ImageStreamImportContentNested<A> withNewImageStreamImportContent() {
    return new ImageStreamImportContentNested(null);
  }
  
  public ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item) {
    return new ImageStreamImportContentNested(item);
  }
  
  public ResourceRequirementsContentNested<A> withNewResourceRequirementsContent() {
    return new ResourceRequirementsContentNested(null);
  }
  
  public ResourceRequirementsContentNested<A> withNewResourceRequirementsContentLike(ResourceRequirements item) {
    return new ResourceRequirementsContentNested(item);
  }
  
  public GitHubWebHookCauseContentNested<A> withNewGitHubWebHookCauseContent() {
    return new GitHubWebHookCauseContentNested(null);
  }
  
  public GitHubWebHookCauseContentNested<A> withNewGitHubWebHookCauseContentLike(GitHubWebHookCause item) {
    return new GitHubWebHookCauseContentNested(item);
  }
  
  public OAuthClientListContentNested<A> withNewOAuthClientListContent() {
    return new OAuthClientListContentNested(null);
  }
  
  public OAuthClientListContentNested<A> withNewOAuthClientListContentLike(OAuthClientList item) {
    return new OAuthClientListContentNested(item);
  }
  
  public PodSecurityPolicyReviewStatusContentNested<A> withNewPodSecurityPolicyReviewStatusContent() {
    return new PodSecurityPolicyReviewStatusContentNested(null);
  }
  
  public PodSecurityPolicyReviewStatusContentNested<A> withNewPodSecurityPolicyReviewStatusContentLike(PodSecurityPolicyReviewStatus item) {
    return new PodSecurityPolicyReviewStatusContentNested(item);
  }
  
  public TemplateInstanceStatusContentNested<A> withNewTemplateInstanceStatusContent() {
    return new TemplateInstanceStatusContentNested(null);
  }
  
  public TemplateInstanceStatusContentNested<A> withNewTemplateInstanceStatusContentLike(TemplateInstanceStatus item) {
    return new TemplateInstanceStatusContentNested(item);
  }
  
  public HelmChartRepositoryListContentNested<A> withNewHelmChartRepositoryListContent() {
    return new HelmChartRepositoryListContentNested(null);
  }
  
  public HelmChartRepositoryListContentNested<A> withNewHelmChartRepositoryListContentLike(HelmChartRepositoryList item) {
    return new HelmChartRepositoryListContentNested(item);
  }
  
  public PolicyRuleContentNested<A> withNewPolicyRuleContent() {
    return new PolicyRuleContentNested(null);
  }
  
  public PolicyRuleContentNested<A> withNewPolicyRuleContentLike(PolicyRule item) {
    return new PolicyRuleContentNested(item);
  }
  
  public DeploymentTriggerPolicyContentNested<A> withNewDeploymentTriggerPolicyContent() {
    return new DeploymentTriggerPolicyContentNested(null);
  }
  
  public DeploymentTriggerPolicyContentNested<A> withNewDeploymentTriggerPolicyContentLike(DeploymentTriggerPolicy item) {
    return new DeploymentTriggerPolicyContentNested(item);
  }
  
  public BuildStrategyContentNested<A> withNewBuildStrategyContent() {
    return new BuildStrategyContentNested(null);
  }
  
  public BuildStrategyContentNested<A> withNewBuildStrategyContentLike(BuildStrategy item) {
    return new BuildStrategyContentNested(item);
  }
  
  public RepositoryImportSpecContentNested<A> withNewRepositoryImportSpecContent() {
    return new RepositoryImportSpecContentNested(null);
  }
  
  public RepositoryImportSpecContentNested<A> withNewRepositoryImportSpecContentLike(RepositoryImportSpec item) {
    return new RepositoryImportSpecContentNested(item);
  }
  
  public BrokerTemplateInstanceListContentNested<A> withNewBrokerTemplateInstanceListContent() {
    return new BrokerTemplateInstanceListContentNested(null);
  }
  
  public BrokerTemplateInstanceListContentNested<A> withNewBrokerTemplateInstanceListContentLike(BrokerTemplateInstanceList item) {
    return new BrokerTemplateInstanceListContentNested(item);
  }
  
  public ImageStreamImportStatusContentNested<A> withNewImageStreamImportStatusContent() {
    return new ImageStreamImportStatusContentNested(null);
  }
  
  public ImageStreamImportStatusContentNested<A> withNewImageStreamImportStatusContentLike(ImageStreamImportStatus item) {
    return new ImageStreamImportStatusContentNested(item);
  }
  
  public CustomBuildStrategyContentNested<A> withNewCustomBuildStrategyContent() {
    return new CustomBuildStrategyContentNested(null);
  }
  
  public CustomBuildStrategyContentNested<A> withNewCustomBuildStrategyContentLike(CustomBuildStrategy item) {
    return new CustomBuildStrategyContentNested(item);
  }
  
  public ClusterResourceQuotaSelectorContentNested<A> withNewClusterResourceQuotaSelectorContent() {
    return new ClusterResourceQuotaSelectorContentNested(null);
  }
  
  public ClusterResourceQuotaSelectorContentNested<A> withNewClusterResourceQuotaSelectorContentLike(ClusterResourceQuotaSelector item) {
    return new ClusterResourceQuotaSelectorContentNested(item);
  }
  
  public SubjectAccessReviewResponseContentNested<A> withNewSubjectAccessReviewResponseContent() {
    return new SubjectAccessReviewResponseContentNested(null);
  }
  
  public SubjectAccessReviewResponseContentNested<A> withNewSubjectAccessReviewResponseContentLike(SubjectAccessReviewResponse item) {
    return new SubjectAccessReviewResponseContentNested(item);
  }
  
  public DeploymentTriggerImageChangeParamsContentNested<A> withNewDeploymentTriggerImageChangeParamsContent() {
    return new DeploymentTriggerImageChangeParamsContentNested(null);
  }
  
  public DeploymentTriggerImageChangeParamsContentNested<A> withNewDeploymentTriggerImageChangeParamsContentLike(DeploymentTriggerImageChangeParams item) {
    return new DeploymentTriggerImageChangeParamsContentNested(item);
  }
  
  public LocalObjectReferenceContentNested<A> withNewLocalObjectReferenceContent() {
    return new LocalObjectReferenceContentNested(null);
  }
  
  public LocalObjectReferenceContentNested<A> withNewLocalObjectReferenceContentLike(LocalObjectReference item) {
    return new LocalObjectReferenceContentNested(item);
  }
  
  public A withNewLocalObjectReferenceContent(String name) {
    return (A)withContent(new LocalObjectReference(name));
  }
  
  public TagImageHookContentNested<A> withNewTagImageHookContent() {
    return new TagImageHookContentNested(null);
  }
  
  public TagImageHookContentNested<A> withNewTagImageHookContentLike(TagImageHook item) {
    return new TagImageHookContentNested(item);
  }
  
  public RouteTargetReferenceContentNested<A> withNewRouteTargetReferenceContent() {
    return new RouteTargetReferenceContentNested(null);
  }
  
  public RouteTargetReferenceContentNested<A> withNewRouteTargetReferenceContentLike(RouteTargetReference item) {
    return new RouteTargetReferenceContentNested(item);
  }
  
  public A withNewRouteTargetReferenceContent(String kind,String name,Integer weight) {
    return (A)withContent(new RouteTargetReference(kind, name, weight));
  }
  
  public SubjectRulesReviewSpecContentNested<A> withNewSubjectRulesReviewSpecContent() {
    return new SubjectRulesReviewSpecContentNested(null);
  }
  
  public SubjectRulesReviewSpecContentNested<A> withNewSubjectRulesReviewSpecContentLike(SubjectRulesReviewSpec item) {
    return new SubjectRulesReviewSpecContentNested(item);
  }
  
  public OpenshiftRawExtensionContentNested<A> withNewOpenshiftRawExtensionContent() {
    return new OpenshiftRawExtensionContentNested(null);
  }
  
  public OpenshiftRawExtensionContentNested<A> withNewRawExtensionContentLike(io.fabric8.openshift.api.model.runtime.RawExtension item) {
    return new OpenshiftRawExtensionContentNested(item);
  }
  
  public A withNewOpenshiftRawExtensionContent(Object value) {
    return (A)withContent(new io.fabric8.openshift.api.model.runtime.RawExtension(value));
  }
  
  public RoleListContentNested<A> withNewRoleListContent() {
    return new RoleListContentNested(null);
  }
  
  public RoleListContentNested<A> withNewRoleListContentLike(RoleList item) {
    return new RoleListContentNested(item);
  }
  
  public TagReferencePolicyContentNested<A> withNewTagReferencePolicyContent() {
    return new TagReferencePolicyContentNested(null);
  }
  
  public TagReferencePolicyContentNested<A> withNewTagReferencePolicyContentLike(TagReferencePolicy item) {
    return new TagReferencePolicyContentNested(item);
  }
  
  public A withNewTagReferencePolicyContent(String type) {
    return (A)withContent(new TagReferencePolicy(type));
  }
  
  public ProjectContentNested<A> withNewProjectContent() {
    return new ProjectContentNested(null);
  }
  
  public ProjectContentNested<A> withNewProjectContentLike(Project item) {
    return new ProjectContentNested(item);
  }
  
  public BuildVolumeSourceContentNested<A> withNewBuildVolumeSourceContent() {
    return new BuildVolumeSourceContentNested(null);
  }
  
  public BuildVolumeSourceContentNested<A> withNewBuildVolumeSourceContentLike(BuildVolumeSource item) {
    return new BuildVolumeSourceContentNested(item);
  }
  
  public AppliedClusterResourceQuotaListContentNested<A> withNewAppliedClusterResourceQuotaListContent() {
    return new AppliedClusterResourceQuotaListContentNested(null);
  }
  
  public AppliedClusterResourceQuotaListContentNested<A> withNewAppliedClusterResourceQuotaListContentLike(AppliedClusterResourceQuotaList item) {
    return new AppliedClusterResourceQuotaListContentNested(item);
  }
  
  public BuildStatusOutputContentNested<A> withNewBuildStatusOutputContent() {
    return new BuildStatusOutputContentNested(null);
  }
  
  public BuildStatusOutputContentNested<A> withNewBuildStatusOutputContentLike(BuildStatusOutput item) {
    return new BuildStatusOutputContentNested(item);
  }
  
  public DeploymentConfigListContentNested<A> withNewDeploymentConfigListContent() {
    return new DeploymentConfigListContentNested(null);
  }
  
  public DeploymentConfigListContentNested<A> withNewDeploymentConfigListContentLike(DeploymentConfigList item) {
    return new DeploymentConfigListContentNested(item);
  }
  
  public BuildConfigContentNested<A> withNewBuildConfigContent() {
    return new BuildConfigContentNested(null);
  }
  
  public BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item) {
    return new BuildConfigContentNested(item);
  }
  
  public ImageImportStatusContentNested<A> withNewImageImportStatusContent() {
    return new ImageImportStatusContentNested(null);
  }
  
  public ImageImportStatusContentNested<A> withNewImageImportStatusContentLike(ImageImportStatus item) {
    return new ImageImportStatusContentNested(item);
  }
  
  public PodSecurityPolicySubjectReviewContentNested<A> withNewPodSecurityPolicySubjectReviewContent() {
    return new PodSecurityPolicySubjectReviewContentNested(null);
  }
  
  public PodSecurityPolicySubjectReviewContentNested<A> withNewPodSecurityPolicySubjectReviewContentLike(PodSecurityPolicySubjectReview item) {
    return new PodSecurityPolicySubjectReviewContentNested(item);
  }
  
  public GitLabWebHookCauseContentNested<A> withNewGitLabWebHookCauseContent() {
    return new GitLabWebHookCauseContentNested(null);
  }
  
  public GitLabWebHookCauseContentNested<A> withNewGitLabWebHookCauseContentLike(GitLabWebHookCause item) {
    return new GitLabWebHookCauseContentNested(item);
  }
  
  public DeploymentConfigStatusContentNested<A> withNewDeploymentConfigStatusContent() {
    return new DeploymentConfigStatusContentNested(null);
  }
  
  public DeploymentConfigStatusContentNested<A> withNewDeploymentConfigStatusContentLike(DeploymentConfigStatus item) {
    return new DeploymentConfigStatusContentNested(item);
  }
  
  public SecretBuildSourceContentNested<A> withNewSecretBuildSourceContent() {
    return new SecretBuildSourceContentNested(null);
  }
  
  public SecretBuildSourceContentNested<A> withNewSecretBuildSourceContentLike(SecretBuildSource item) {
    return new SecretBuildSourceContentNested(item);
  }
  
  public EgressNetworkPolicySpecContentNested<A> withNewEgressNetworkPolicySpecContent() {
    return new EgressNetworkPolicySpecContentNested(null);
  }
  
  public EgressNetworkPolicySpecContentNested<A> withNewEgressNetworkPolicySpecContentLike(EgressNetworkPolicySpec item) {
    return new EgressNetworkPolicySpecContentNested(item);
  }
  
  public HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContent() {
    return new HelmChartRepositoryContentNested(null);
  }
  
  public HelmChartRepositoryContentNested<A> withNewHelmChartRepositoryContentLike(HelmChartRepository item) {
    return new HelmChartRepositoryContentNested(item);
  }
  
  public TagEventContentNested<A> withNewTagEventContent() {
    return new TagEventContentNested(null);
  }
  
  public TagEventContentNested<A> withNewTagEventContentLike(TagEvent item) {
    return new TagEventContentNested(item);
  }
  
  public A withNewTagEventContent(String created,String dockerImageReference,Long generation,String image) {
    return (A)withContent(new TagEvent(created, dockerImageReference, generation, image));
  }
  
  public BitbucketWebHookCauseContentNested<A> withNewBitbucketWebHookCauseContent() {
    return new BitbucketWebHookCauseContentNested(null);
  }
  
  public BitbucketWebHookCauseContentNested<A> withNewBitbucketWebHookCauseContentLike(BitbucketWebHookCause item) {
    return new BitbucketWebHookCauseContentNested(item);
  }
  
  public ImageStreamTagListContentNested<A> withNewImageStreamTagListContent() {
    return new ImageStreamTagListContentNested(null);
  }
  
  public ImageStreamTagListContentNested<A> withNewImageStreamTagListContentLike(ImageStreamTagList item) {
    return new ImageStreamTagListContentNested(item);
  }
  
  public DeploymentConfigRollbackSpecContentNested<A> withNewDeploymentConfigRollbackSpecContent() {
    return new DeploymentConfigRollbackSpecContentNested(null);
  }
  
  public DeploymentConfigRollbackSpecContentNested<A> withNewDeploymentConfigRollbackSpecContentLike(DeploymentConfigRollbackSpec item) {
    return new DeploymentConfigRollbackSpecContentNested(item);
  }
  
  public ProjectListContentNested<A> withNewProjectListContent() {
    return new ProjectListContentNested(null);
  }
  
  public ProjectListContentNested<A> withNewProjectListContentLike(ProjectList item) {
    return new ProjectListContentNested(item);
  }
  
  public ProjectHelmChartRepositorySpecContentNested<A> withNewProjectHelmChartRepositorySpecContent() {
    return new ProjectHelmChartRepositorySpecContentNested(null);
  }
  
  public ProjectHelmChartRepositorySpecContentNested<A> withNewProjectHelmChartRepositorySpecContentLike(ProjectHelmChartRepositorySpec item) {
    return new ProjectHelmChartRepositorySpecContentNested(item);
  }
  
  public ClusterRoleScopeRestrictionContentNested<A> withNewClusterRoleScopeRestrictionContent() {
    return new ClusterRoleScopeRestrictionContentNested(null);
  }
  
  public ClusterRoleScopeRestrictionContentNested<A> withNewClusterRoleScopeRestrictionContentLike(ClusterRoleScopeRestriction item) {
    return new ClusterRoleScopeRestrictionContentNested(item);
  }
  
  public RangeAllocationContentNested<A> withNewRangeAllocationContent() {
    return new RangeAllocationContentNested(null);
  }
  
  public RangeAllocationContentNested<A> withNewRangeAllocationContentLike(RangeAllocation item) {
    return new RangeAllocationContentNested(item);
  }
  
  public RouteContentNested<A> withNewRouteContent() {
    return new RouteContentNested(null);
  }
  
  public RouteContentNested<A> withNewRouteContentLike(Route item) {
    return new RouteContentNested(item);
  }
  
  public SourceStrategyOptionsContentNested<A> withNewSourceStrategyOptionsContent() {
    return new SourceStrategyOptionsContentNested(null);
  }
  
  public SourceStrategyOptionsContentNested<A> withNewSourceStrategyOptionsContentLike(SourceStrategyOptions item) {
    return new SourceStrategyOptionsContentNested(item);
  }
  
  public A withNewSourceStrategyOptionsContent(Boolean incremental) {
    return (A)withContent(new SourceStrategyOptions(incremental));
  }
  
  public ClusterNetworkContentNested<A> withNewClusterNetworkContent() {
    return new ClusterNetworkContentNested(null);
  }
  
  public ClusterNetworkContentNested<A> withNewClusterNetworkContentLike(ClusterNetwork item) {
    return new ClusterNetworkContentNested(item);
  }
  
  public OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent() {
    return new OAuthAuthorizeTokenContentNested(null);
  }
  
  public OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item) {
    return new OAuthAuthorizeTokenContentNested(item);
  }
  
  public DockerBuildStrategyContentNested<A> withNewDockerBuildStrategyContent() {
    return new DockerBuildStrategyContentNested(null);
  }
  
  public DockerBuildStrategyContentNested<A> withNewDockerBuildStrategyContentLike(DockerBuildStrategy item) {
    return new DockerBuildStrategyContentNested(item);
  }
  
  public SignatureConditionContentNested<A> withNewSignatureConditionContent() {
    return new SignatureConditionContentNested(null);
  }
  
  public SignatureConditionContentNested<A> withNewSignatureConditionContentLike(SignatureCondition item) {
    return new SignatureConditionContentNested(item);
  }
  
  public UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContent() {
    return new UserOAuthAccessTokenContentNested(null);
  }
  
  public UserOAuthAccessTokenContentNested<A> withNewUserOAuthAccessTokenContentLike(UserOAuthAccessToken item) {
    return new UserOAuthAccessTokenContentNested(item);
  }
  
  public ConnectionConfigNamespaceScopedContentNested<A> withNewConnectionConfigNamespaceScopedContent() {
    return new ConnectionConfigNamespaceScopedContentNested(null);
  }
  
  public ConnectionConfigNamespaceScopedContentNested<A> withNewConnectionConfigNamespaceScopedContentLike(ConnectionConfigNamespaceScoped item) {
    return new ConnectionConfigNamespaceScopedContentNested(item);
  }
  
  public RoleBindingRestrictionListContentNested<A> withNewRoleBindingRestrictionListContent() {
    return new RoleBindingRestrictionListContentNested(null);
  }
  
  public RoleBindingRestrictionListContentNested<A> withNewRoleBindingRestrictionListContentLike(RoleBindingRestrictionList item) {
    return new RoleBindingRestrictionListContentNested(item);
  }
  
  public RawExtensionContentNested<A> withNewRawExtensionContent() {
    return new RawExtensionContentNested(null);
  }
  
  public RawExtensionContentNested<A> withNewRawExtensionContentLike(RawExtension item) {
    return new RawExtensionContentNested(item);
  }
  
  public A withNewRawExtensionContent(Object value) {
    return (A)withContent(new RawExtension(value));
  }
  
  public ImageManifestContentNested<A> withNewImageManifestContent() {
    return new ImageManifestContentNested(null);
  }
  
  public ImageManifestContentNested<A> withNewImageManifestContentLike(ImageManifest item) {
    return new ImageManifestContentNested(item);
  }
  
  public SecurityContextConstraintsListContentNested<A> withNewSecurityContextConstraintsListContent() {
    return new SecurityContextConstraintsListContentNested(null);
  }
  
  public SecurityContextConstraintsListContentNested<A> withNewSecurityContextConstraintsListContentLike(SecurityContextConstraintsList item) {
    return new SecurityContextConstraintsListContentNested(item);
  }
  
  public BuildConfigListContentNested<A> withNewBuildConfigListContent() {
    return new BuildConfigListContentNested(null);
  }
  
  public BuildConfigListContentNested<A> withNewBuildConfigListContentLike(BuildConfigList item) {
    return new BuildConfigListContentNested(item);
  }
  
  public IdentityListContentNested<A> withNewIdentityListContent() {
    return new IdentityListContentNested(null);
  }
  
  public IdentityListContentNested<A> withNewIdentityListContentLike(IdentityList item) {
    return new IdentityListContentNested(item);
  }
  
  public ClusterNetworkListContentNested<A> withNewClusterNetworkListContent() {
    return new ClusterNetworkListContentNested(null);
  }
  
  public ClusterNetworkListContentNested<A> withNewClusterNetworkListContentLike(ClusterNetworkList item) {
    return new ClusterNetworkListContentNested(item);
  }
  
  public TemplateInstanceConditionContentNested<A> withNewTemplateInstanceConditionContent() {
    return new TemplateInstanceConditionContentNested(null);
  }
  
  public TemplateInstanceConditionContentNested<A> withNewTemplateInstanceConditionContentLike(TemplateInstanceCondition item) {
    return new TemplateInstanceConditionContentNested(item);
  }
  
  public A withNewTemplateInstanceConditionContent(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withContent(new TemplateInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public DeploymentCauseContentNested<A> withNewDeploymentCauseContent() {
    return new DeploymentCauseContentNested(null);
  }
  
  public DeploymentCauseContentNested<A> withNewDeploymentCauseContentLike(DeploymentCause item) {
    return new DeploymentCauseContentNested(item);
  }
  
  public RepositoryImportStatusContentNested<A> withNewRepositoryImportStatusContent() {
    return new RepositoryImportStatusContentNested(null);
  }
  
  public RepositoryImportStatusContentNested<A> withNewRepositoryImportStatusContentLike(RepositoryImportStatus item) {
    return new RepositoryImportStatusContentNested(item);
  }
  
  public GroupListContentNested<A> withNewGroupListContent() {
    return new GroupListContentNested(null);
  }
  
  public GroupListContentNested<A> withNewGroupListContentLike(GroupList item) {
    return new GroupListContentNested(item);
  }
  
  public RunAsUserStrategyOptionsContentNested<A> withNewRunAsUserStrategyOptionsContent() {
    return new RunAsUserStrategyOptionsContentNested(null);
  }
  
  public RunAsUserStrategyOptionsContentNested<A> withNewRunAsUserStrategyOptionsContentLike(RunAsUserStrategyOptions item) {
    return new RunAsUserStrategyOptionsContentNested(item);
  }
  
  public A withNewRunAsUserStrategyOptionsContent(String type,Long uid,Long uidRangeMax,Long uidRangeMin) {
    return (A)withContent(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
  }
  
  public LifecycleHookContentNested<A> withNewLifecycleHookContent() {
    return new LifecycleHookContentNested(null);
  }
  
  public LifecycleHookContentNested<A> withNewLifecycleHookContentLike(LifecycleHook item) {
    return new LifecycleHookContentNested(item);
  }
  
  public ImageStreamTagReferenceContentNested<A> withNewImageStreamTagReferenceContent() {
    return new ImageStreamTagReferenceContentNested(null);
  }
  
  public ImageStreamTagReferenceContentNested<A> withNewImageStreamTagReferenceContentLike(ImageStreamTagReference item) {
    return new ImageStreamTagReferenceContentNested(item);
  }
  
  public A withNewImageStreamTagReferenceContent(String name,String namespace) {
    return (A)withContent(new ImageStreamTagReference(name, namespace));
  }
  
  public SourceControlUserContentNested<A> withNewSourceControlUserContent() {
    return new SourceControlUserContentNested(null);
  }
  
  public SourceControlUserContentNested<A> withNewSourceControlUserContentLike(SourceControlUser item) {
    return new SourceControlUserContentNested(item);
  }
  
  public A withNewSourceControlUserContent(String email,String name) {
    return (A)withContent(new SourceControlUser(email, name));
  }
  
  public ContainerContentNested<A> withNewContainerContent() {
    return new ContainerContentNested(null);
  }
  
  public ContainerContentNested<A> withNewContainerContentLike(Container item) {
    return new ContainerContentNested(item);
  }
  
  public ImageStreamListContentNested<A> withNewImageStreamListContent() {
    return new ImageStreamListContentNested(null);
  }
  
  public ImageStreamListContentNested<A> withNewImageStreamListContentLike(ImageStreamList item) {
    return new ImageStreamListContentNested(item);
  }
  
  public ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent() {
    return new ClusterRoleBindingContentNested(null);
  }
  
  public ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item) {
    return new ClusterRoleBindingContentNested(item);
  }
  
  public ResourceAccessReviewContentNested<A> withNewResourceAccessReviewContent() {
    return new ResourceAccessReviewContentNested(null);
  }
  
  public ResourceAccessReviewContentNested<A> withNewResourceAccessReviewContentLike(ResourceAccessReview item) {
    return new ResourceAccessReviewContentNested(item);
  }
  
  public SelfSubjectRulesReviewContentNested<A> withNewSelfSubjectRulesReviewContent() {
    return new SelfSubjectRulesReviewContentNested(null);
  }
  
  public SelfSubjectRulesReviewContentNested<A> withNewSelfSubjectRulesReviewContentLike(SelfSubjectRulesReview item) {
    return new SelfSubjectRulesReviewContentNested(item);
  }
  
  public UserOAuthAccessTokenListContentNested<A> withNewUserOAuthAccessTokenListContent() {
    return new UserOAuthAccessTokenListContentNested(null);
  }
  
  public UserOAuthAccessTokenListContentNested<A> withNewUserOAuthAccessTokenListContentLike(UserOAuthAccessTokenList item) {
    return new UserOAuthAccessTokenListContentNested(item);
  }
  
  public ImageChangeTriggerStatusContentNested<A> withNewImageChangeTriggerStatusContent() {
    return new ImageChangeTriggerStatusContentNested(null);
  }
  
  public ImageChangeTriggerStatusContentNested<A> withNewImageChangeTriggerStatusContentLike(ImageChangeTriggerStatus item) {
    return new ImageChangeTriggerStatusContentNested(item);
  }
  
  public RouteStatusContentNested<A> withNewRouteStatusContent() {
    return new RouteStatusContentNested(null);
  }
  
  public RouteStatusContentNested<A> withNewRouteStatusContentLike(RouteStatus item) {
    return new RouteStatusContentNested(item);
  }
  
  public DeploymentConfigRollbackContentNested<A> withNewDeploymentConfigRollbackContent() {
    return new DeploymentConfigRollbackContentNested(null);
  }
  
  public DeploymentConfigRollbackContentNested<A> withNewDeploymentConfigRollbackContentLike(DeploymentConfigRollback item) {
    return new DeploymentConfigRollbackContentNested(item);
  }
  
  public ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContent() {
    return new ClusterResourceQuotaContentNested(null);
  }
  
  public ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContentLike(ClusterResourceQuota item) {
    return new ClusterResourceQuotaContentNested(item);
  }
  
  public NamedTagEventListContentNested<A> withNewNamedTagEventListContent() {
    return new NamedTagEventListContentNested(null);
  }
  
  public NamedTagEventListContentNested<A> withNewNamedTagEventListContentLike(NamedTagEventList item) {
    return new NamedTagEventListContentNested(item);
  }
  
  public ClusterResourceQuotaListContentNested<A> withNewClusterResourceQuotaListContent() {
    return new ClusterResourceQuotaListContentNested(null);
  }
  
  public ClusterResourceQuotaListContentNested<A> withNewClusterResourceQuotaListContentLike(ClusterResourceQuotaList item) {
    return new ClusterResourceQuotaListContentNested(item);
  }
  
  public RouteSpecContentNested<A> withNewRouteSpecContent() {
    return new RouteSpecContentNested(null);
  }
  
  public RouteSpecContentNested<A> withNewRouteSpecContentLike(RouteSpec item) {
    return new RouteSpecContentNested(item);
  }
  
  public ProjectRequestContentNested<A> withNewProjectRequestContent() {
    return new ProjectRequestContentNested(null);
  }
  
  public ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item) {
    return new ProjectRequestContentNested(item);
  }
  
  public TemplateContentNested<A> withNewTemplateContent() {
    return new TemplateContentNested(null);
  }
  
  public TemplateContentNested<A> withNewTemplateContentLike(Template item) {
    return new TemplateContentNested(item);
  }
  
  public ImageLookupPolicyContentNested<A> withNewImageLookupPolicyContent() {
    return new ImageLookupPolicyContentNested(null);
  }
  
  public ImageLookupPolicyContentNested<A> withNewImageLookupPolicyContentLike(ImageLookupPolicy item) {
    return new ImageLookupPolicyContentNested(item);
  }
  
  public A withNewImageLookupPolicyContent(Boolean local) {
    return (A)withContent(new ImageLookupPolicy(local));
  }
  
  public OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent() {
    return new OAuthClientAuthorizationContentNested(null);
  }
  
  public OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationContentNested(item);
  }
  
  public ImageChangeCauseContentNested<A> withNewImageChangeCauseContent() {
    return new ImageChangeCauseContentNested(null);
  }
  
  public ImageChangeCauseContentNested<A> withNewImageChangeCauseContentLike(ImageChangeCause item) {
    return new ImageChangeCauseContentNested(item);
  }
  
  public AllowedFlexVolumeContentNested<A> withNewAllowedFlexVolumeContent() {
    return new AllowedFlexVolumeContentNested(null);
  }
  
  public AllowedFlexVolumeContentNested<A> withNewAllowedFlexVolumeContentLike(AllowedFlexVolume item) {
    return new AllowedFlexVolumeContentNested(item);
  }
  
  public A withNewAllowedFlexVolumeContent(String driver) {
    return (A)withContent(new AllowedFlexVolume(driver));
  }
  
  public SubjectAccessReviewContentNested<A> withNewSubjectAccessReviewContent() {
    return new SubjectAccessReviewContentNested(null);
  }
  
  public SubjectAccessReviewContentNested<A> withNewSubjectAccessReviewContentLike(SubjectAccessReview item) {
    return new SubjectAccessReviewContentNested(item);
  }
  
  public LocalResourceAccessReviewContentNested<A> withNewLocalResourceAccessReviewContent() {
    return new LocalResourceAccessReviewContentNested(null);
  }
  
  public LocalResourceAccessReviewContentNested<A> withNewLocalResourceAccessReviewContentLike(LocalResourceAccessReview item) {
    return new LocalResourceAccessReviewContentNested(item);
  }
  
  public ClusterRoleContentNested<A> withNewClusterRoleContent() {
    return new ClusterRoleContentNested(null);
  }
  
  public ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item) {
    return new ClusterRoleContentNested(item);
  }
  
  public ConnectionConfigContentNested<A> withNewConnectionConfigContent() {
    return new ConnectionConfigContentNested(null);
  }
  
  public ConnectionConfigContentNested<A> withNewConnectionConfigContentLike(ConnectionConfig item) {
    return new ConnectionConfigContentNested(item);
  }
  
  public TagEventConditionContentNested<A> withNewTagEventConditionContent() {
    return new TagEventConditionContentNested(null);
  }
  
  public TagEventConditionContentNested<A> withNewTagEventConditionContentLike(TagEventCondition item) {
    return new TagEventConditionContentNested(item);
  }
  
  public LabelSelectorContentNested<A> withNewLabelSelectorContent() {
    return new LabelSelectorContentNested(null);
  }
  
  public LabelSelectorContentNested<A> withNewLabelSelectorContentLike(LabelSelector item) {
    return new LabelSelectorContentNested(item);
  }
  
  public NetNamespaceListContentNested<A> withNewNetNamespaceListContent() {
    return new NetNamespaceListContentNested(null);
  }
  
  public NetNamespaceListContentNested<A> withNewNetNamespaceListContentLike(NetNamespaceList item) {
    return new NetNamespaceListContentNested(item);
  }
  
  public BrokerTemplateInstanceSpecContentNested<A> withNewBrokerTemplateInstanceSpecContent() {
    return new BrokerTemplateInstanceSpecContentNested(null);
  }
  
  public BrokerTemplateInstanceSpecContentNested<A> withNewBrokerTemplateInstanceSpecContentLike(BrokerTemplateInstanceSpec item) {
    return new BrokerTemplateInstanceSpecContentNested(item);
  }
  
  public BinaryBuildSourceContentNested<A> withNewBinaryBuildSourceContent() {
    return new BinaryBuildSourceContentNested(null);
  }
  
  public BinaryBuildSourceContentNested<A> withNewBinaryBuildSourceContentLike(BinaryBuildSource item) {
    return new BinaryBuildSourceContentNested(item);
  }
  
  public A withNewBinaryBuildSourceContent(String asFile) {
    return (A)withContent(new BinaryBuildSource(asFile));
  }
  
  public BuildSpecContentNested<A> withNewBuildSpecContent() {
    return new BuildSpecContentNested(null);
  }
  
  public BuildSpecContentNested<A> withNewBuildSpecContentLike(BuildSpec item) {
    return new BuildSpecContentNested(item);
  }
  
  public OAuthClientAuthorizationListContentNested<A> withNewOAuthClientAuthorizationListContent() {
    return new OAuthClientAuthorizationListContentNested(null);
  }
  
  public OAuthClientAuthorizationListContentNested<A> withNewOAuthClientAuthorizationListContentLike(OAuthClientAuthorizationList item) {
    return new OAuthClientAuthorizationListContentNested(item);
  }
  
  public LocalSubjectAccessReviewContentNested<A> withNewLocalSubjectAccessReviewContent() {
    return new LocalSubjectAccessReviewContentNested(null);
  }
  
  public LocalSubjectAccessReviewContentNested<A> withNewLocalSubjectAccessReviewContentLike(LocalSubjectAccessReview item) {
    return new LocalSubjectAccessReviewContentNested(item);
  }
  
  public ProjectStatusContentNested<A> withNewProjectStatusContent() {
    return new ProjectStatusContentNested(null);
  }
  
  public ProjectStatusContentNested<A> withNewProjectStatusContentLike(ProjectStatus item) {
    return new ProjectStatusContentNested(item);
  }
  
  public RollingDeploymentStrategyParamsContentNested<A> withNewRollingDeploymentStrategyParamsContent() {
    return new RollingDeploymentStrategyParamsContentNested(null);
  }
  
  public RollingDeploymentStrategyParamsContentNested<A> withNewRollingDeploymentStrategyParamsContentLike(RollingDeploymentStrategyParams item) {
    return new RollingDeploymentStrategyParamsContentNested(item);
  }
  
  public GitSourceRevisionContentNested<A> withNewGitSourceRevisionContent() {
    return new GitSourceRevisionContentNested(null);
  }
  
  public GitSourceRevisionContentNested<A> withNewGitSourceRevisionContentLike(GitSourceRevision item) {
    return new GitSourceRevisionContentNested(item);
  }
  
  public ImageLabelContentNested<A> withNewImageLabelContent() {
    return new ImageLabelContentNested(null);
  }
  
  public ImageLabelContentNested<A> withNewImageLabelContentLike(ImageLabel item) {
    return new ImageLabelContentNested(item);
  }
  
  public A withNewImageLabelContent(String name,String value) {
    return (A)withContent(new ImageLabel(name, value));
  }
  
  public ImageChangeTriggerContentNested<A> withNewImageChangeTriggerContent() {
    return new ImageChangeTriggerContentNested(null);
  }
  
  public ImageChangeTriggerContentNested<A> withNewImageChangeTriggerContentLike(ImageChangeTrigger item) {
    return new ImageChangeTriggerContentNested(item);
  }
  
  public PodSecurityPolicyReviewSpecContentNested<A> withNewPodSecurityPolicyReviewSpecContent() {
    return new PodSecurityPolicyReviewSpecContentNested(null);
  }
  
  public PodSecurityPolicyReviewSpecContentNested<A> withNewPodSecurityPolicyReviewSpecContentLike(PodSecurityPolicyReviewSpec item) {
    return new PodSecurityPolicyReviewSpecContentNested(item);
  }
  
  public ImageStreamImportSpecContentNested<A> withNewImageStreamImportSpecContent() {
    return new ImageStreamImportSpecContentNested(null);
  }
  
  public ImageStreamImportSpecContentNested<A> withNewImageStreamImportSpecContentLike(ImageStreamImportSpec item) {
    return new ImageStreamImportSpecContentNested(item);
  }
  
  public ImageTagContentNested<A> withNewImageTagContent() {
    return new ImageTagContentNested(null);
  }
  
  public ImageTagContentNested<A> withNewImageTagContentLike(ImageTag item) {
    return new ImageTagContentNested(item);
  }
  
  public FSGroupStrategyOptionsContentNested<A> withNewFSGroupStrategyOptionsContent() {
    return new FSGroupStrategyOptionsContentNested(null);
  }
  
  public FSGroupStrategyOptionsContentNested<A> withNewFSGroupStrategyOptionsContentLike(FSGroupStrategyOptions item) {
    return new FSGroupStrategyOptionsContentNested(item);
  }
  
  public PodSecurityPolicyReviewContentNested<A> withNewPodSecurityPolicyReviewContent() {
    return new PodSecurityPolicyReviewContentNested(null);
  }
  
  public PodSecurityPolicyReviewContentNested<A> withNewPodSecurityPolicyReviewContentLike(PodSecurityPolicyReview item) {
    return new PodSecurityPolicyReviewContentNested(item);
  }
  
  public RecreateDeploymentStrategyParamsContentNested<A> withNewRecreateDeploymentStrategyParamsContent() {
    return new RecreateDeploymentStrategyParamsContentNested(null);
  }
  
  public RecreateDeploymentStrategyParamsContentNested<A> withNewRecreateDeploymentStrategyParamsContentLike(RecreateDeploymentStrategyParams item) {
    return new RecreateDeploymentStrategyParamsContentNested(item);
  }
  
  public DockerStrategyOptionsContentNested<A> withNewDockerStrategyOptionsContent() {
    return new DockerStrategyOptionsContentNested(null);
  }
  
  public DockerStrategyOptionsContentNested<A> withNewDockerStrategyOptionsContentLike(DockerStrategyOptions item) {
    return new DockerStrategyOptionsContentNested(item);
  }
  
  public ImageListContentNested<A> withNewImageListContent() {
    return new ImageListContentNested(null);
  }
  
  public ImageListContentNested<A> withNewImageListContentLike(ImageList item) {
    return new ImageListContentNested(item);
  }
  
  public ConfigMapBuildSourceContentNested<A> withNewConfigMapBuildSourceContent() {
    return new ConfigMapBuildSourceContentNested(null);
  }
  
  public ConfigMapBuildSourceContentNested<A> withNewConfigMapBuildSourceContentLike(ConfigMapBuildSource item) {
    return new ConfigMapBuildSourceContentNested(item);
  }
  
  public ImageTagListContentNested<A> withNewImageTagListContent() {
    return new ImageTagListContentNested(null);
  }
  
  public ImageTagListContentNested<A> withNewImageTagListContentLike(ImageTagList item) {
    return new ImageTagListContentNested(item);
  }
  
  public DeploymentConfigContentNested<A> withNewDeploymentConfigContent() {
    return new DeploymentConfigContentNested(null);
  }
  
  public DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item) {
    return new DeploymentConfigContentNested(item);
  }
  
  public OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent() {
    return new OAuthAccessTokenContentNested(null);
  }
  
  public OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item) {
    return new OAuthAccessTokenContentNested(item);
  }
  
  public RoleBindingContentNested<A> withNewRoleBindingContent() {
    return new RoleBindingContentNested(null);
  }
  
  public RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item) {
    return new RoleBindingContentNested(item);
  }
  
  public ImageContentNested<A> withNewImageContent() {
    return new ImageContentNested(null);
  }
  
  public ImageContentNested<A> withNewImageContentLike(Image item) {
    return new ImageContentNested(item);
  }
  
  public TLSConfigContentNested<A> withNewTLSConfigContent() {
    return new TLSConfigContentNested(null);
  }
  
  public TLSConfigContentNested<A> withNewTLSConfigContentLike(TLSConfig item) {
    return new TLSConfigContentNested(item);
  }
  
  public BuildVolumeContentNested<A> withNewBuildVolumeContent() {
    return new BuildVolumeContentNested(null);
  }
  
  public BuildVolumeContentNested<A> withNewBuildVolumeContentLike(BuildVolume item) {
    return new BuildVolumeContentNested(item);
  }
  
  public TemplateInstanceSpecContentNested<A> withNewTemplateInstanceSpecContent() {
    return new TemplateInstanceSpecContentNested(null);
  }
  
  public TemplateInstanceSpecContentNested<A> withNewTemplateInstanceSpecContentLike(TemplateInstanceSpec item) {
    return new TemplateInstanceSpecContentNested(item);
  }
  
  public BuildStatusContentNested<A> withNewBuildStatusContent() {
    return new BuildStatusContentNested(null);
  }
  
  public BuildStatusContentNested<A> withNewBuildStatusContentLike(BuildStatus item) {
    return new BuildStatusContentNested(item);
  }
  
  public ImageSourceContentNested<A> withNewImageSourceContent() {
    return new ImageSourceContentNested(null);
  }
  
  public ImageSourceContentNested<A> withNewImageSourceContentLike(ImageSource item) {
    return new ImageSourceContentNested(item);
  }
  
  public ObjectMetaContentNested<A> withNewObjectMetaContent() {
    return new ObjectMetaContentNested(null);
  }
  
  public ObjectMetaContentNested<A> withNewObjectMetaContentLike(ObjectMeta item) {
    return new ObjectMetaContentNested(item);
  }
  
  public PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent() {
    return new PersistentVolumeClaimContentNested(null);
  }
  
  public PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimContentNested(item);
  }
  
  public PodSecurityPolicySelfSubjectReviewContentNested<A> withNewPodSecurityPolicySelfSubjectReviewContent() {
    return new PodSecurityPolicySelfSubjectReviewContentNested(null);
  }
  
  public PodSecurityPolicySelfSubjectReviewContentNested<A> withNewPodSecurityPolicySelfSubjectReviewContentLike(PodSecurityPolicySelfSubjectReview item) {
    return new PodSecurityPolicySelfSubjectReviewContentNested(item);
  }
  
  public TagReferenceContentNested<A> withNewTagReferenceContent() {
    return new TagReferenceContentNested(null);
  }
  
  public TagReferenceContentNested<A> withNewTagReferenceContentLike(TagReference item) {
    return new TagReferenceContentNested(item);
  }
  
  public EgressNetworkPolicyRuleContentNested<A> withNewEgressNetworkPolicyRuleContent() {
    return new EgressNetworkPolicyRuleContentNested(null);
  }
  
  public EgressNetworkPolicyRuleContentNested<A> withNewEgressNetworkPolicyRuleContentLike(EgressNetworkPolicyRule item) {
    return new EgressNetworkPolicyRuleContentNested(item);
  }
  
  public SubjectRulesReviewStatusContentNested<A> withNewSubjectRulesReviewStatusContent() {
    return new SubjectRulesReviewStatusContentNested(null);
  }
  
  public SubjectRulesReviewStatusContentNested<A> withNewSubjectRulesReviewStatusContentLike(SubjectRulesReviewStatus item) {
    return new SubjectRulesReviewStatusContentNested(item);
  }
  
  public BuildVolumeMountContentNested<A> withNewBuildVolumeMountContent() {
    return new BuildVolumeMountContentNested(null);
  }
  
  public BuildVolumeMountContentNested<A> withNewBuildVolumeMountContentLike(BuildVolumeMount item) {
    return new BuildVolumeMountContentNested(item);
  }
  
  public A withNewBuildVolumeMountContent(String destinationPath) {
    return (A)withContent(new BuildVolumeMount(destinationPath));
  }
  
  public ClusterNetworkEntryContentNested<A> withNewClusterNetworkEntryContent() {
    return new ClusterNetworkEntryContentNested(null);
  }
  
  public ClusterNetworkEntryContentNested<A> withNewClusterNetworkEntryContentLike(ClusterNetworkEntry item) {
    return new ClusterNetworkEntryContentNested(item);
  }
  
  public A withNewClusterNetworkEntryContent(String cidr,Integer hostSubnetLength) {
    return (A)withContent(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  
  public GenericKubernetesResourceContentNested<A> withNewGenericKubernetesResourceContent() {
    return new GenericKubernetesResourceContentNested(null);
  }
  
  public GenericKubernetesResourceContentNested<A> withNewGenericKubernetesResourceContentLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceContentNested(item);
  }
  
  public TemplateInstanceObjectContentNested<A> withNewTemplateInstanceObjectContent() {
    return new TemplateInstanceObjectContentNested(null);
  }
  
  public TemplateInstanceObjectContentNested<A> withNewTemplateInstanceObjectContentLike(TemplateInstanceObject item) {
    return new TemplateInstanceObjectContentNested(item);
  }
  
  public BuildSourceContentNested<A> withNewBuildSourceContent() {
    return new BuildSourceContentNested(null);
  }
  
  public BuildSourceContentNested<A> withNewBuildSourceContentLike(BuildSource item) {
    return new BuildSourceContentNested(item);
  }
  
  public ClusterResourceQuotaStatusContentNested<A> withNewClusterResourceQuotaStatusContent() {
    return new ClusterResourceQuotaStatusContentNested(null);
  }
  
  public ClusterResourceQuotaStatusContentNested<A> withNewClusterResourceQuotaStatusContentLike(ClusterResourceQuotaStatus item) {
    return new ClusterResourceQuotaStatusContentNested(item);
  }
  
  public DeploymentConditionContentNested<A> withNewDeploymentConditionContent() {
    return new DeploymentConditionContentNested(null);
  }
  
  public DeploymentConditionContentNested<A> withNewDeploymentConditionContentLike(DeploymentCondition item) {
    return new DeploymentConditionContentNested(item);
  }
  
  public HelmChartRepositorySpecContentNested<A> withNewHelmChartRepositorySpecContent() {
    return new HelmChartRepositorySpecContentNested(null);
  }
  
  public HelmChartRepositorySpecContentNested<A> withNewHelmChartRepositorySpecContentLike(HelmChartRepositorySpec item) {
    return new HelmChartRepositorySpecContentNested(item);
  }
  
  public DeploymentCauseImageTriggerContentNested<A> withNewDeploymentCauseImageTriggerContent() {
    return new DeploymentCauseImageTriggerContentNested(null);
  }
  
  public DeploymentCauseImageTriggerContentNested<A> withNewDeploymentCauseImageTriggerContentLike(DeploymentCauseImageTrigger item) {
    return new DeploymentCauseImageTriggerContentNested(item);
  }
  
  public ImageStreamMappingContentNested<A> withNewImageStreamMappingContent() {
    return new ImageStreamMappingContentNested(null);
  }
  
  public ImageStreamMappingContentNested<A> withNewImageStreamMappingContentLike(ImageStreamMapping item) {
    return new ImageStreamMappingContentNested(item);
  }
  
  public SubjectRulesReviewContentNested<A> withNewSubjectRulesReviewContent() {
    return new SubjectRulesReviewContentNested(null);
  }
  
  public SubjectRulesReviewContentNested<A> withNewSubjectRulesReviewContentLike(SubjectRulesReview item) {
    return new SubjectRulesReviewContentNested(item);
  }
  
  public RoleContentNested<A> withNewRoleContent() {
    return new RoleContentNested(null);
  }
  
  public RoleContentNested<A> withNewRoleContentLike(Role item) {
    return new RoleContentNested(item);
  }
  
  public GitBuildSourceContentNested<A> withNewGitBuildSourceContent() {
    return new GitBuildSourceContentNested(null);
  }
  
  public GitBuildSourceContentNested<A> withNewGitBuildSourceContentLike(GitBuildSource item) {
    return new GitBuildSourceContentNested(item);
  }
  
  public A withNewGitBuildSourceContent(String httpProxy,String httpsProxy,String noProxy,String ref,String uri) {
    return (A)withContent(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
  }
  
  public EgressNetworkPolicyListContentNested<A> withNewEgressNetworkPolicyListContent() {
    return new EgressNetworkPolicyListContentNested(null);
  }
  
  public EgressNetworkPolicyListContentNested<A> withNewEgressNetworkPolicyListContentLike(EgressNetworkPolicyList item) {
    return new EgressNetworkPolicyListContentNested(item);
  }
  
  public SelfSubjectRulesReviewSpecContentNested<A> withNewSelfSubjectRulesReviewSpecContent() {
    return new SelfSubjectRulesReviewSpecContentNested(null);
  }
  
  public SelfSubjectRulesReviewSpecContentNested<A> withNewSelfSubjectRulesReviewSpecContentLike(SelfSubjectRulesReviewSpec item) {
    return new SelfSubjectRulesReviewSpecContentNested(item);
  }
  
  public ImageSourcePathContentNested<A> withNewImageSourcePathContent() {
    return new ImageSourcePathContentNested(null);
  }
  
  public ImageSourcePathContentNested<A> withNewImageSourcePathContentLike(ImageSourcePath item) {
    return new ImageSourcePathContentNested(item);
  }
  
  public A withNewImageSourcePathContent(String destinationDir,String sourcePath) {
    return (A)withContent(new ImageSourcePath(destinationDir, sourcePath));
  }
  
  public BuildConfigStatusContentNested<A> withNewBuildConfigStatusContent() {
    return new BuildConfigStatusContentNested(null);
  }
  
  public BuildConfigStatusContentNested<A> withNewBuildConfigStatusContentLike(BuildConfigStatus item) {
    return new BuildConfigStatusContentNested(item);
  }
  
  public ResourceQuotaStatusByNamespaceContentNested<A> withNewResourceQuotaStatusByNamespaceContent() {
    return new ResourceQuotaStatusByNamespaceContentNested(null);
  }
  
  public ResourceQuotaStatusByNamespaceContentNested<A> withNewResourceQuotaStatusByNamespaceContentLike(ResourceQuotaStatusByNamespace item) {
    return new ResourceQuotaStatusByNamespaceContentNested(item);
  }
  
  public ParameterContentNested<A> withNewParameterContent() {
    return new ParameterContentNested(null);
  }
  
  public ParameterContentNested<A> withNewParameterContentLike(Parameter item) {
    return new ParameterContentNested(item);
  }
  
  public RoleBindingListContentNested<A> withNewRoleBindingListContent() {
    return new RoleBindingListContentNested(null);
  }
  
  public RoleBindingListContentNested<A> withNewRoleBindingListContentLike(RoleBindingList item) {
    return new RoleBindingListContentNested(item);
  }
  
  public SourceBuildStrategyContentNested<A> withNewSourceBuildStrategyContent() {
    return new SourceBuildStrategyContentNested(null);
  }
  
  public SourceBuildStrategyContentNested<A> withNewSourceBuildStrategyContentLike(SourceBuildStrategy item) {
    return new SourceBuildStrategyContentNested(item);
  }
  
  public BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContent() {
    return new BrokerTemplateInstanceContentNested(null);
  }
  
  public BrokerTemplateInstanceContentNested<A> withNewBrokerTemplateInstanceContentLike(BrokerTemplateInstance item) {
    return new BrokerTemplateInstanceContentNested(item);
  }
  
  public PodSecurityPolicySelfSubjectReviewSpecContentNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecContent() {
    return new PodSecurityPolicySelfSubjectReviewSpecContentNested(null);
  }
  
  public PodSecurityPolicySelfSubjectReviewSpecContentNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecContentLike(PodSecurityPolicySelfSubjectReviewSpec item) {
    return new PodSecurityPolicySelfSubjectReviewSpecContentNested(item);
  }
  
  public BuildPostCommitSpecContentNested<A> withNewBuildPostCommitSpecContent() {
    return new BuildPostCommitSpecContentNested(null);
  }
  
  public BuildPostCommitSpecContentNested<A> withNewBuildPostCommitSpecContentLike(BuildPostCommitSpec item) {
    return new BuildPostCommitSpecContentNested(item);
  }
  
  public DeploymentStrategyContentNested<A> withNewDeploymentStrategyContent() {
    return new DeploymentStrategyContentNested(null);
  }
  
  public DeploymentStrategyContentNested<A> withNewDeploymentStrategyContentLike(DeploymentStrategy item) {
    return new DeploymentStrategyContentNested(item);
  }
  
  public OAuthAuthorizeTokenListContentNested<A> withNewOAuthAuthorizeTokenListContent() {
    return new OAuthAuthorizeTokenListContentNested(null);
  }
  
  public OAuthAuthorizeTokenListContentNested<A> withNewOAuthAuthorizeTokenListContentLike(OAuthAuthorizeTokenList item) {
    return new OAuthAuthorizeTokenListContentNested(item);
  }
  
  public SignatureSubjectContentNested<A> withNewSignatureSubjectContent() {
    return new SignatureSubjectContentNested(null);
  }
  
  public SignatureSubjectContentNested<A> withNewSignatureSubjectContentLike(SignatureSubject item) {
    return new SignatureSubjectContentNested(item);
  }
  
  public A withNewSignatureSubjectContent(String commonName,String organization,String publicKeyID) {
    return (A)withContent(new SignatureSubject(commonName, organization, publicKeyID));
  }
  
  public HostSubnetListContentNested<A> withNewHostSubnetListContent() {
    return new HostSubnetListContentNested(null);
  }
  
  public HostSubnetListContentNested<A> withNewHostSubnetListContentLike(HostSubnetList item) {
    return new HostSubnetListContentNested(item);
  }
  
  public RouteIngressConditionContentNested<A> withNewRouteIngressConditionContent() {
    return new RouteIngressConditionContentNested(null);
  }
  
  public RouteIngressConditionContentNested<A> withNewRouteIngressConditionContentLike(RouteIngressCondition item) {
    return new RouteIngressConditionContentNested(item);
  }
  
  public A withNewRouteIngressConditionContent(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withContent(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public CustomDeploymentStrategyParamsContentNested<A> withNewCustomDeploymentStrategyParamsContent() {
    return new CustomDeploymentStrategyParamsContentNested(null);
  }
  
  public CustomDeploymentStrategyParamsContentNested<A> withNewCustomDeploymentStrategyParamsContentLike(CustomDeploymentStrategyParams item) {
    return new CustomDeploymentStrategyParamsContentNested(item);
  }
  
  public ImageImportSpecContentNested<A> withNewImageImportSpecContent() {
    return new ImageImportSpecContentNested(null);
  }
  
  public ImageImportSpecContentNested<A> withNewImageImportSpecContentLike(ImageImportSpec item) {
    return new ImageImportSpecContentNested(item);
  }
  
  public StageInfoContentNested<A> withNewStageInfoContent() {
    return new StageInfoContentNested(null);
  }
  
  public StageInfoContentNested<A> withNewStageInfoContentLike(StageInfo item) {
    return new StageInfoContentNested(item);
  }
  
  public RoleBindingRestrictionSpecContentNested<A> withNewRoleBindingRestrictionSpecContent() {
    return new RoleBindingRestrictionSpecContentNested(null);
  }
  
  public RoleBindingRestrictionSpecContentNested<A> withNewRoleBindingRestrictionSpecContentLike(RoleBindingRestrictionSpec item) {
    return new RoleBindingRestrictionSpecContentNested(item);
  }
  
  public IDRangeContentNested<A> withNewIDRangeContent() {
    return new IDRangeContentNested(null);
  }
  
  public IDRangeContentNested<A> withNewIDRangeContentLike(IDRange item) {
    return new IDRangeContentNested(item);
  }
  
  public A withNewIDRangeContent(Long max,Long min) {
    return (A)withContent(new IDRange(max, min));
  }
  
  public UserListContentNested<A> withNewUserListContent() {
    return new UserListContentNested(null);
  }
  
  public UserListContentNested<A> withNewUserListContentLike(UserList item) {
    return new UserListContentNested(item);
  }
  
  public BuildConfigSpecContentNested<A> withNewBuildConfigSpecContent() {
    return new BuildConfigSpecContentNested(null);
  }
  
  public BuildConfigSpecContentNested<A> withNewBuildConfigSpecContentLike(BuildConfigSpec item) {
    return new BuildConfigSpecContentNested(item);
  }
  
  public UserContentNested<A> withNewUserContent() {
    return new UserContentNested(null);
  }
  
  public UserContentNested<A> withNewUserContentLike(User item) {
    return new UserContentNested(item);
  }
  
  public ImageStreamImageContentNested<A> withNewImageStreamImageContent() {
    return new ImageStreamImageContentNested(null);
  }
  
  public ImageStreamImageContentNested<A> withNewImageStreamImageContentLike(ImageStreamImage item) {
    return new ImageStreamImageContentNested(item);
  }
  
  public BuildConditionContentNested<A> withNewBuildConditionContent() {
    return new BuildConditionContentNested(null);
  }
  
  public BuildConditionContentNested<A> withNewBuildConditionContentLike(BuildCondition item) {
    return new BuildConditionContentNested(item);
  }
  
  public BuildStatusOutputToContentNested<A> withNewBuildStatusOutputToContent() {
    return new BuildStatusOutputToContentNested(null);
  }
  
  public BuildStatusOutputToContentNested<A> withNewBuildStatusOutputToContentLike(BuildStatusOutputTo item) {
    return new BuildStatusOutputToContentNested(item);
  }
  
  public A withNewBuildStatusOutputToContent(String imageDigest) {
    return (A)withContent(new BuildStatusOutputTo(imageDigest));
  }
  
  public ResourceAccessReviewResponseContentNested<A> withNewResourceAccessReviewResponseContent() {
    return new ResourceAccessReviewResponseContentNested(null);
  }
  
  public ResourceAccessReviewResponseContentNested<A> withNewResourceAccessReviewResponseContentLike(ResourceAccessReviewResponse item) {
    return new ResourceAccessReviewResponseContentNested(item);
  }
  
  public ExecNewPodHookContentNested<A> withNewExecNewPodHookContent() {
    return new ExecNewPodHookContentNested(null);
  }
  
  public ExecNewPodHookContentNested<A> withNewExecNewPodHookContentLike(ExecNewPodHook item) {
    return new ExecNewPodHookContentNested(item);
  }
  
  public SecretSpecContentNested<A> withNewSecretSpecContent() {
    return new SecretSpecContentNested(null);
  }
  
  public SecretSpecContentNested<A> withNewSecretSpecContentLike(SecretSpec item) {
    return new SecretSpecContentNested(item);
  }
  
  public ClusterRoleBindingListContentNested<A> withNewClusterRoleBindingListContent() {
    return new ClusterRoleBindingListContentNested(null);
  }
  
  public ClusterRoleBindingListContentNested<A> withNewClusterRoleBindingListContentLike(ClusterRoleBindingList item) {
    return new ClusterRoleBindingListContentNested(item);
  }
  
  public EgressNetworkPolicyPeerContentNested<A> withNewEgressNetworkPolicyPeerContent() {
    return new EgressNetworkPolicyPeerContentNested(null);
  }
  
  public EgressNetworkPolicyPeerContentNested<A> withNewEgressNetworkPolicyPeerContentLike(EgressNetworkPolicyPeer item) {
    return new EgressNetworkPolicyPeerContentNested(item);
  }
  
  public A withNewEgressNetworkPolicyPeerContent(String cidrSelector,String dnsName) {
    return (A)withContent(new EgressNetworkPolicyPeer(cidrSelector, dnsName));
  }
  
  public ProjectHelmChartRepositoryListContentNested<A> withNewProjectHelmChartRepositoryListContent() {
    return new ProjectHelmChartRepositoryListContentNested(null);
  }
  
  public ProjectHelmChartRepositoryListContentNested<A> withNewProjectHelmChartRepositoryListContentLike(ProjectHelmChartRepositoryList item) {
    return new ProjectHelmChartRepositoryListContentNested(item);
  }
  
  public TemplateInstanceContentNested<A> withNewTemplateInstanceContent() {
    return new TemplateInstanceContentNested(null);
  }
  
  public TemplateInstanceContentNested<A> withNewTemplateInstanceContentLike(TemplateInstance item) {
    return new TemplateInstanceContentNested(item);
  }
  
  public WebHookTriggerContentNested<A> withNewWebHookTriggerContent() {
    return new WebHookTriggerContentNested(null);
  }
  
  public WebHookTriggerContentNested<A> withNewWebHookTriggerContentLike(WebHookTrigger item) {
    return new WebHookTriggerContentNested(item);
  }
  
  public BuildContentNested<A> withNewBuildContent() {
    return new BuildContentNested(null);
  }
  
  public BuildContentNested<A> withNewBuildContentLike(Build item) {
    return new BuildContentNested(item);
  }
  
  public ServiceAccountReferenceContentNested<A> withNewServiceAccountReferenceContent() {
    return new ServiceAccountReferenceContentNested(null);
  }
  
  public ServiceAccountReferenceContentNested<A> withNewServiceAccountReferenceContentLike(ServiceAccountReference item) {
    return new ServiceAccountReferenceContentNested(item);
  }
  
  public A withNewServiceAccountReferenceContent(String name,String namespace) {
    return (A)withContent(new ServiceAccountReference(name, namespace));
  }
  
  public RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent() {
    return new RoleBindingRestrictionContentNested(null);
  }
  
  public RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item) {
    return new RoleBindingRestrictionContentNested(item);
  }
  
  public TagImportPolicyContentNested<A> withNewTagImportPolicyContent() {
    return new TagImportPolicyContentNested(null);
  }
  
  public TagImportPolicyContentNested<A> withNewTagImportPolicyContentLike(TagImportPolicy item) {
    return new TagImportPolicyContentNested(item);
  }
  
  public A withNewTagImportPolicyContent(String importMode,Boolean insecure,Boolean scheduled) {
    return (A)withContent(new TagImportPolicy(importMode, insecure, scheduled));
  }
  
  public ImageStreamTagContentNested<A> withNewImageStreamTagContent() {
    return new ImageStreamTagContentNested(null);
  }
  
  public ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item) {
    return new ImageStreamTagContentNested(item);
  }
  
  public BuildTriggerPolicyContentNested<A> withNewBuildTriggerPolicyContent() {
    return new BuildTriggerPolicyContentNested(null);
  }
  
  public BuildTriggerPolicyContentNested<A> withNewBuildTriggerPolicyContentLike(BuildTriggerPolicy item) {
    return new BuildTriggerPolicyContentNested(item);
  }
  
  public RoutePortContentNested<A> withNewRoutePortContent() {
    return new RoutePortContentNested(null);
  }
  
  public RoutePortContentNested<A> withNewRoutePortContentLike(RoutePort item) {
    return new RoutePortContentNested(item);
  }
  
  public TemplateInstanceRequesterContentNested<A> withNewTemplateInstanceRequesterContent() {
    return new TemplateInstanceRequesterContentNested(null);
  }
  
  public TemplateInstanceRequesterContentNested<A> withNewTemplateInstanceRequesterContentLike(TemplateInstanceRequester item) {
    return new TemplateInstanceRequesterContentNested(item);
  }
  
  public GroupContentNested<A> withNewGroupContent() {
    return new GroupContentNested(null);
  }
  
  public GroupContentNested<A> withNewGroupContentLike(Group item) {
    return new GroupContentNested(item);
  }
  
  public BuildTriggerCauseContentNested<A> withNewBuildTriggerCauseContent() {
    return new BuildTriggerCauseContentNested(null);
  }
  
  public BuildTriggerCauseContentNested<A> withNewBuildTriggerCauseContentLike(BuildTriggerCause item) {
    return new BuildTriggerCauseContentNested(item);
  }
  
  public ImageSignatureContentNested<A> withNewImageSignatureContent() {
    return new ImageSignatureContentNested(null);
  }
  
  public ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item) {
    return new ImageSignatureContentNested(item);
  }
  
  public HelmChartRepositoryStatusContentNested<A> withNewHelmChartRepositoryStatusContent() {
    return new HelmChartRepositoryStatusContentNested(null);
  }
  
  public HelmChartRepositoryStatusContentNested<A> withNewHelmChartRepositoryStatusContentLike(HelmChartRepositoryStatus item) {
    return new HelmChartRepositoryStatusContentNested(item);
  }
  
  public DeploymentConfigSpecContentNested<A> withNewDeploymentConfigSpecContent() {
    return new DeploymentConfigSpecContentNested(null);
  }
  
  public DeploymentConfigSpecContentNested<A> withNewDeploymentConfigSpecContentLike(DeploymentConfigSpec item) {
    return new DeploymentConfigSpecContentNested(item);
  }
  
  public HostSubnetContentNested<A> withNewHostSubnetContent() {
    return new HostSubnetContentNested(null);
  }
  
  public HostSubnetContentNested<A> withNewHostSubnetContentLike(HostSubnet item) {
    return new HostSubnetContentNested(item);
  }
  
  public AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContent() {
    return new AppliedClusterResourceQuotaContentNested(null);
  }
  
  public AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContentLike(AppliedClusterResourceQuota item) {
    return new AppliedClusterResourceQuotaContentNested(item);
  }
  
  public GroupRestrictionContentNested<A> withNewGroupRestrictionContent() {
    return new GroupRestrictionContentNested(null);
  }
  
  public GroupRestrictionContentNested<A> withNewGroupRestrictionContentLike(GroupRestriction item) {
    return new GroupRestrictionContentNested(item);
  }
  
  public OAuthAccessTokenListContentNested<A> withNewOAuthAccessTokenListContent() {
    return new OAuthAccessTokenListContentNested(null);
  }
  
  public OAuthAccessTokenListContentNested<A> withNewOAuthAccessTokenListContentLike(OAuthAccessTokenList item) {
    return new OAuthAccessTokenListContentNested(item);
  }
  
  public JenkinsPipelineBuildStrategyContentNested<A> withNewJenkinsPipelineBuildStrategyContent() {
    return new JenkinsPipelineBuildStrategyContentNested(null);
  }
  
  public JenkinsPipelineBuildStrategyContentNested<A> withNewJenkinsPipelineBuildStrategyContentLike(JenkinsPipelineBuildStrategy item) {
    return new JenkinsPipelineBuildStrategyContentNested(item);
  }
  
  public SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent() {
    return new SecurityContextConstraintsContentNested(null);
  }
  
  public SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item) {
    return new SecurityContextConstraintsContentNested(item);
  }
  
  public SupplementalGroupsStrategyOptionsContentNested<A> withNewSupplementalGroupsStrategyOptionsContent() {
    return new SupplementalGroupsStrategyOptionsContentNested(null);
  }
  
  public SupplementalGroupsStrategyOptionsContentNested<A> withNewSupplementalGroupsStrategyOptionsContentLike(SupplementalGroupsStrategyOptions item) {
    return new SupplementalGroupsStrategyOptionsContentNested(item);
  }
  
  public ServiceAccountPodSecurityPolicyReviewStatusContentNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusContent() {
    return new ServiceAccountPodSecurityPolicyReviewStatusContentNested(null);
  }
  
  public ServiceAccountPodSecurityPolicyReviewStatusContentNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusContentLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
    return new ServiceAccountPodSecurityPolicyReviewStatusContentNested(item);
  }
  
  public BuildRequestContentNested<A> withNewBuildRequestContent() {
    return new BuildRequestContentNested(null);
  }
  
  public BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item) {
    return new BuildRequestContentNested(item);
  }
  
  public SELinuxContextStrategyOptionsContentNested<A> withNewSELinuxContextStrategyOptionsContent() {
    return new SELinuxContextStrategyOptionsContentNested(null);
  }
  
  public SELinuxContextStrategyOptionsContentNested<A> withNewSELinuxContextStrategyOptionsContentLike(SELinuxContextStrategyOptions item) {
    return new SELinuxContextStrategyOptionsContentNested(item);
  }
  
  public ClusterRoleListContentNested<A> withNewClusterRoleListContent() {
    return new ClusterRoleListContentNested(null);
  }
  
  public ClusterRoleListContentNested<A> withNewClusterRoleListContentLike(ClusterRoleList item) {
    return new ClusterRoleListContentNested(item);
  }
  
  public RouteListContentNested<A> withNewRouteListContent() {
    return new RouteListContentNested(null);
  }
  
  public RouteListContentNested<A> withNewRouteListContentLike(RouteList item) {
    return new RouteListContentNested(item);
  }
  
  public ImageStreamStatusContentNested<A> withNewImageStreamStatusContent() {
    return new ImageStreamStatusContentNested(null);
  }
  
  public ImageStreamStatusContentNested<A> withNewImageStreamStatusContentLike(ImageStreamStatus item) {
    return new ImageStreamStatusContentNested(item);
  }
  
  public EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContent() {
    return new EgressNetworkPolicyContentNested(null);
  }
  
  public EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContentLike(EgressNetworkPolicy item) {
    return new EgressNetworkPolicyContentNested(item);
  }
  
  public NetNamespaceContentNested<A> withNewNetNamespaceContent() {
    return new NetNamespaceContentNested(null);
  }
  
  public NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item) {
    return new NetNamespaceContentNested(item);
  }
  
  public DeploymentDetailsContentNested<A> withNewDeploymentDetailsContent() {
    return new DeploymentDetailsContentNested(null);
  }
  
  public DeploymentDetailsContentNested<A> withNewDeploymentDetailsContentLike(DeploymentDetails item) {
    return new DeploymentDetailsContentNested(item);
  }
  
  public UserIdentityMappingContentNested<A> withNewUserIdentityMappingContent() {
    return new UserIdentityMappingContentNested(null);
  }
  
  public UserIdentityMappingContentNested<A> withNewUserIdentityMappingContentLike(UserIdentityMapping item) {
    return new UserIdentityMappingContentNested(item);
  }
  
  public PodSecurityPolicySubjectReviewStatusContentNested<A> withNewPodSecurityPolicySubjectReviewStatusContent() {
    return new PodSecurityPolicySubjectReviewStatusContentNested(null);
  }
  
  public PodSecurityPolicySubjectReviewStatusContentNested<A> withNewPodSecurityPolicySubjectReviewStatusContentLike(PodSecurityPolicySubjectReviewStatus item) {
    return new PodSecurityPolicySubjectReviewStatusContentNested(item);
  }
  
  public PodSecurityPolicySubjectReviewSpecContentNested<A> withNewPodSecurityPolicySubjectReviewSpecContent() {
    return new PodSecurityPolicySubjectReviewSpecContentNested(null);
  }
  
  public PodSecurityPolicySubjectReviewSpecContentNested<A> withNewPodSecurityPolicySubjectReviewSpecContentLike(PodSecurityPolicySubjectReviewSpec item) {
    return new PodSecurityPolicySubjectReviewSpecContentNested(item);
  }
  
  public ImageStreamContentNested<A> withNewImageStreamContent() {
    return new ImageStreamContentNested(null);
  }
  
  public ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item) {
    return new ImageStreamContentNested(item);
  }
  
  public BuildListContentNested<A> withNewBuildListContent() {
    return new BuildListContentNested(null);
  }
  
  public BuildListContentNested<A> withNewBuildListContentLike(BuildList item) {
    return new BuildListContentNested(item);
  }
  
  public BuildOutputContentNested<A> withNewBuildOutputContent() {
    return new BuildOutputContentNested(null);
  }
  
  public BuildOutputContentNested<A> withNewBuildOutputContentLike(BuildOutput item) {
    return new BuildOutputContentNested(item);
  }
  
  public TemplateListContentNested<A> withNewTemplateListContent() {
    return new TemplateListContentNested(null);
  }
  
  public TemplateListContentNested<A> withNewTemplateListContentLike(TemplateList item) {
    return new TemplateListContentNested(item);
  }
  
  public ProjectSpecContentNested<A> withNewProjectSpecContent() {
    return new ProjectSpecContentNested(null);
  }
  
  public ProjectSpecContentNested<A> withNewProjectSpecContentLike(ProjectSpec item) {
    return new ProjectSpecContentNested(item);
  }
  
  public SourceRevisionContentNested<A> withNewSourceRevisionContent() {
    return new SourceRevisionContentNested(null);
  }
  
  public SourceRevisionContentNested<A> withNewSourceRevisionContentLike(SourceRevision item) {
    return new SourceRevisionContentNested(item);
  }
  
  public ObjectReferenceContentNested<A> withNewObjectReferenceContent() {
    return new ObjectReferenceContentNested(null);
  }
  
  public ObjectReferenceContentNested<A> withNewObjectReferenceContentLike(ObjectReference item) {
    return new ObjectReferenceContentNested(item);
  }
  
  public SignatureIssuerContentNested<A> withNewSignatureIssuerContent() {
    return new SignatureIssuerContentNested(null);
  }
  
  public SignatureIssuerContentNested<A> withNewSignatureIssuerContentLike(SignatureIssuer item) {
    return new SignatureIssuerContentNested(item);
  }
  
  public A withNewSignatureIssuerContent(String commonName,String organization) {
    return (A)withContent(new SignatureIssuer(commonName, organization));
  }
  
  public ImageLayerContentNested<A> withNewImageLayerContent() {
    return new ImageLayerContentNested(null);
  }
  
  public ImageLayerContentNested<A> withNewImageLayerContentLike(ImageLayer item) {
    return new ImageLayerContentNested(item);
  }
  
  public A withNewImageLayerContent(String mediaType,String name,Long size) {
    return (A)withContent(new ImageLayer(mediaType, name, size));
  }
  
  public ClusterResourceQuotaSpecContentNested<A> withNewClusterResourceQuotaSpecContent() {
    return new ClusterResourceQuotaSpecContentNested(null);
  }
  
  public ClusterResourceQuotaSpecContentNested<A> withNewClusterResourceQuotaSpecContentLike(ClusterResourceQuotaSpec item) {
    return new ClusterResourceQuotaSpecContentNested(item);
  }
  
  public ImageStreamSpecContentNested<A> withNewImageStreamSpecContent() {
    return new ImageStreamSpecContentNested(null);
  }
  
  public ImageStreamSpecContentNested<A> withNewImageStreamSpecContentLike(ImageStreamSpec item) {
    return new ImageStreamSpecContentNested(item);
  }
  
  public RouteIngressContentNested<A> withNewRouteIngressContent() {
    return new RouteIngressContentNested(null);
  }
  
  public RouteIngressContentNested<A> withNewRouteIngressContentLike(RouteIngress item) {
    return new RouteIngressContentNested(item);
  }
  
  public OAuthClientContentNested<A> withNewOAuthClientContent() {
    return new OAuthClientContentNested(null);
  }
  
  public OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item) {
    return new OAuthClientContentNested(item);
  }
  
  public IdentityContentNested<A> withNewIdentityContent() {
    return new IdentityContentNested(null);
  }
  
  public IdentityContentNested<A> withNewIdentityContentLike(Identity item) {
    return new IdentityContentNested(item);
  }
  
  public RangeAllocationListContentNested<A> withNewRangeAllocationListContent() {
    return new RangeAllocationListContentNested(null);
  }
  
  public RangeAllocationListContentNested<A> withNewRangeAllocationListContentLike(RangeAllocationList item) {
    return new RangeAllocationListContentNested(item);
  }
  
  public A addToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  
  public A setToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  
  public A removeFromGroups(java.lang.String... items) {
    if (this.groups == null) return (A)this;
    for (String item : items) { this.groups.remove(item);} return (A)this;
  }
  
  public A removeAllFromGroups(Collection<String> items) {
    if (this.groups == null) return (A)this;
    for (String item : items) { this.groups.remove(item);} return (A)this;
  }
  
  public List<String> getGroups() {
    return this.groups;
  }
  
  public String getGroup(int index) {
    return this.groups.get(index);
  }
  
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  
  public String getMatchingGroup(Predicate<String> predicate) {
      for (String item : groups) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingGroup(Predicate<String> predicate) {
      for (String item : groups) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGroups(List<String> groups) {
    if (groups != null) {
        this.groups = new ArrayList();
        for (String item : groups) {
          this.addToGroups(item);
        }
    } else {
      this.groups = null;
    }
    return (A) this;
  }
  
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {
        this.groups.clear();
        _visitables.remove("groups");
    }
    if (groups != null) {
      for (String item : groups) {
        this.addToGroups(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGroups() {
    return this.groups != null && !this.groups.isEmpty();
  }
  
  public Boolean getIsNonResourceURL() {
    return this.isNonResourceURL;
  }
  
  public A withIsNonResourceURL(Boolean isNonResourceURL) {
    this.isNonResourceURL = isNonResourceURL;
    return (A) this;
  }
  
  public boolean hasIsNonResourceURL() {
    return this.isNonResourceURL != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public String getResource() {
    return this.resource;
  }
  
  public A withResource(String resource) {
    this.resource = resource;
    return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public String getResourceAPIGroup() {
    return this.resourceAPIGroup;
  }
  
  public A withResourceAPIGroup(String resourceAPIGroup) {
    this.resourceAPIGroup = resourceAPIGroup;
    return (A) this;
  }
  
  public boolean hasResourceAPIGroup() {
    return this.resourceAPIGroup != null;
  }
  
  public String getResourceAPIVersion() {
    return this.resourceAPIVersion;
  }
  
  public A withResourceAPIVersion(String resourceAPIVersion) {
    this.resourceAPIVersion = resourceAPIVersion;
    return (A) this;
  }
  
  public boolean hasResourceAPIVersion() {
    return this.resourceAPIVersion != null;
  }
  
  public String getResourceName() {
    return this.resourceName;
  }
  
  public A withResourceName(String resourceName) {
    this.resourceName = resourceName;
    return (A) this;
  }
  
  public boolean hasResourceName() {
    return this.resourceName != null;
  }
  
  public A addToScopes(int index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.add(index, item);
    return (A)this;
  }
  
  public A setToScopes(int index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.set(index, item); return (A)this;
  }
  
  public A addToScopes(java.lang.String... items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  
  public A addAllToScopes(Collection<String> items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  
  public A removeFromScopes(java.lang.String... items) {
    if (this.scopes == null) return (A)this;
    for (String item : items) { this.scopes.remove(item);} return (A)this;
  }
  
  public A removeAllFromScopes(Collection<String> items) {
    if (this.scopes == null) return (A)this;
    for (String item : items) { this.scopes.remove(item);} return (A)this;
  }
  
  public List<String> getScopes() {
    return this.scopes;
  }
  
  public String getScope(int index) {
    return this.scopes.get(index);
  }
  
  public String getFirstScope() {
    return this.scopes.get(0);
  }
  
  public String getLastScope() {
    return this.scopes.get(scopes.size() - 1);
  }
  
  public String getMatchingScope(Predicate<String> predicate) {
      for (String item : scopes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingScope(Predicate<String> predicate) {
      for (String item : scopes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withScopes(List<String> scopes) {
    if (scopes != null) {
        this.scopes = new ArrayList();
        for (String item : scopes) {
          this.addToScopes(item);
        }
    } else {
      this.scopes = null;
    }
    return (A) this;
  }
  
  public A withScopes(java.lang.String... scopes) {
    if (this.scopes != null) {
        this.scopes.clear();
        _visitables.remove("scopes");
    }
    if (scopes != null) {
      for (String item : scopes) {
        this.addToScopes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasScopes() {
    return this.scopes != null && !this.scopes.isEmpty();
  }
  
  public String getUser() {
    return this.user;
  }
  
  public A withUser(String user) {
    this.user = user;
    return (A) this;
  }
  
  public boolean hasUser() {
    return this.user != null;
  }
  
  public String getVerb() {
    return this.verb;
  }
  
  public A withVerb(String verb) {
    this.verb = verb;
    return (A) this;
  }
  
  public boolean hasVerb() {
    return this.verb != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubjectAccessReviewFluent that = (SubjectAccessReviewFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(content, that.content)) return false;
    if (!java.util.Objects.equals(groups, that.groups)) return false;
    if (!java.util.Objects.equals(isNonResourceURL, that.isNonResourceURL)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
    if (!java.util.Objects.equals(resourceAPIGroup, that.resourceAPIGroup)) return false;
    if (!java.util.Objects.equals(resourceAPIVersion, that.resourceAPIVersion)) return false;
    if (!java.util.Objects.equals(resourceName, that.resourceName)) return false;
    if (!java.util.Objects.equals(scopes, that.scopes)) return false;
    if (!java.util.Objects.equals(user, that.user)) return false;
    if (!java.util.Objects.equals(verb, that.verb)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  content,  groups,  isNonResourceURL,  kind,  namespace,  path,  resource,  resourceAPIGroup,  resourceAPIVersion,  resourceName,  scopes,  user,  verb,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (content != null) { sb.append("content:"); sb.append(content + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (isNonResourceURL != null) { sb.append("isNonResourceURL:"); sb.append(isNonResourceURL + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (resourceAPIGroup != null) { sb.append("resourceAPIGroup:"); sb.append(resourceAPIGroup + ","); }
    if (resourceAPIVersion != null) { sb.append("resourceAPIVersion:"); sb.append(resourceAPIVersion + ","); }
    if (resourceName != null) { sb.append("resourceName:"); sb.append(resourceName + ","); }
    if (scopes != null && !scopes.isEmpty()) { sb.append("scopes:"); sb.append(scopes + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (verb != null) { sb.append("verb:"); sb.append(verb + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.openshift.api.model."+"GenericWebHookCause": return (VisitableBuilder<T, ?>)new GenericWebHookCauseBuilder((GenericWebHookCause) item);
    case "io.fabric8.openshift.api.model."+"ServiceAccountRestriction": return (VisitableBuilder<T, ?>)new ServiceAccountRestrictionBuilder((ServiceAccountRestriction) item);
    case "io.fabric8.openshift.api.model."+"ScopeRestriction": return (VisitableBuilder<T, ?>)new ScopeRestrictionBuilder((ScopeRestriction) item);
    case "io.fabric8.openshift.api.model."+"SecretLocalReference": return (VisitableBuilder<T, ?>)new SecretLocalReferenceBuilder((SecretLocalReference) item);
    case "io.fabric8.openshift.api.model."+"StepInfo": return (VisitableBuilder<T, ?>)new StepInfoBuilder((StepInfo) item);
    case "io.fabric8.openshift.api.model."+"UserRestriction": return (VisitableBuilder<T, ?>)new UserRestrictionBuilder((UserRestriction) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateSpec": return (VisitableBuilder<T, ?>)new PodTemplateSpecBuilder((PodTemplateSpec) item);
    case "io.fabric8.openshift.api.model."+"ProjectHelmChartRepository": return (VisitableBuilder<T, ?>)new ProjectHelmChartRepositoryBuilder((ProjectHelmChartRepository) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceList": return (VisitableBuilder<T, ?>)new TemplateInstanceListBuilder((TemplateInstanceList) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImport": return (VisitableBuilder<T, ?>)new ImageStreamImportBuilder((ImageStreamImport) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceRequirements": return (VisitableBuilder<T, ?>)new ResourceRequirementsBuilder((ResourceRequirements) item);
    case "io.fabric8.openshift.api.model."+"GitHubWebHookCause": return (VisitableBuilder<T, ?>)new GitHubWebHookCauseBuilder((GitHubWebHookCause) item);
    case "io.fabric8.openshift.api.model."+"OAuthClientList": return (VisitableBuilder<T, ?>)new OAuthClientListBuilder((OAuthClientList) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicyReviewStatus": return (VisitableBuilder<T, ?>)new PodSecurityPolicyReviewStatusBuilder((PodSecurityPolicyReviewStatus) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceStatus": return (VisitableBuilder<T, ?>)new TemplateInstanceStatusBuilder((TemplateInstanceStatus) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepositoryList": return (VisitableBuilder<T, ?>)new HelmChartRepositoryListBuilder((HelmChartRepositoryList) item);
    case "io.fabric8.openshift.api.model."+"PolicyRule": return (VisitableBuilder<T, ?>)new PolicyRuleBuilder((PolicyRule) item);
    case "io.fabric8.openshift.api.model."+"DeploymentTriggerPolicy": return (VisitableBuilder<T, ?>)new DeploymentTriggerPolicyBuilder((DeploymentTriggerPolicy) item);
    case "io.fabric8.openshift.api.model."+"BuildStrategy": return (VisitableBuilder<T, ?>)new BuildStrategyBuilder((BuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"RepositoryImportSpec": return (VisitableBuilder<T, ?>)new RepositoryImportSpecBuilder((RepositoryImportSpec) item);
    case "io.fabric8.openshift.api.model."+"BrokerTemplateInstanceList": return (VisitableBuilder<T, ?>)new BrokerTemplateInstanceListBuilder((BrokerTemplateInstanceList) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImportStatus": return (VisitableBuilder<T, ?>)new ImageStreamImportStatusBuilder((ImageStreamImportStatus) item);
    case "io.fabric8.openshift.api.model."+"CustomBuildStrategy": return (VisitableBuilder<T, ?>)new CustomBuildStrategyBuilder((CustomBuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuotaSelector": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaSelectorBuilder((ClusterResourceQuotaSelector) item);
    case "io.fabric8.openshift.api.model."+"SubjectAccessReviewResponse": return (VisitableBuilder<T, ?>)new SubjectAccessReviewResponseBuilder((SubjectAccessReviewResponse) item);
    case "io.fabric8.openshift.api.model."+"DeploymentTriggerImageChangeParams": return (VisitableBuilder<T, ?>)new DeploymentTriggerImageChangeParamsBuilder((DeploymentTriggerImageChangeParams) item);
    case "io.fabric8.kubernetes.api.model."+"LocalObjectReference": return (VisitableBuilder<T, ?>)new LocalObjectReferenceBuilder((LocalObjectReference) item);
    case "io.fabric8.openshift.api.model."+"TagImageHook": return (VisitableBuilder<T, ?>)new TagImageHookBuilder((TagImageHook) item);
    case "io.fabric8.openshift.api.model."+"RouteTargetReference": return (VisitableBuilder<T, ?>)new RouteTargetReferenceBuilder((RouteTargetReference) item);
    case "io.fabric8.openshift.api.model."+"SubjectRulesReviewSpec": return (VisitableBuilder<T, ?>)new SubjectRulesReviewSpecBuilder((SubjectRulesReviewSpec) item);
    case "io.fabric8.openshift.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder((io.fabric8.openshift.api.model.runtime.RawExtension) item);
    case "io.fabric8.openshift.api.model."+"RoleList": return (VisitableBuilder<T, ?>)new RoleListBuilder((RoleList) item);
    case "io.fabric8.openshift.api.model."+"TagReferencePolicy": return (VisitableBuilder<T, ?>)new TagReferencePolicyBuilder((TagReferencePolicy) item);
    case "io.fabric8.openshift.api.model."+"Project": return (VisitableBuilder<T, ?>)new ProjectBuilder((Project) item);
    case "io.fabric8.openshift.api.model."+"BuildVolumeSource": return (VisitableBuilder<T, ?>)new BuildVolumeSourceBuilder((BuildVolumeSource) item);
    case "io.fabric8.openshift.api.model."+"AppliedClusterResourceQuotaList": return (VisitableBuilder<T, ?>)new AppliedClusterResourceQuotaListBuilder((AppliedClusterResourceQuotaList) item);
    case "io.fabric8.openshift.api.model."+"BuildStatusOutput": return (VisitableBuilder<T, ?>)new BuildStatusOutputBuilder((BuildStatusOutput) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigList": return (VisitableBuilder<T, ?>)new DeploymentConfigListBuilder((DeploymentConfigList) item);
    case "io.fabric8.openshift.api.model."+"BuildConfig": return (VisitableBuilder<T, ?>)new BuildConfigBuilder((BuildConfig) item);
    case "io.fabric8.openshift.api.model."+"ImageImportStatus": return (VisitableBuilder<T, ?>)new ImageImportStatusBuilder((ImageImportStatus) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySubjectReview": return (VisitableBuilder<T, ?>)new PodSecurityPolicySubjectReviewBuilder((PodSecurityPolicySubjectReview) item);
    case "io.fabric8.openshift.api.model."+"GitLabWebHookCause": return (VisitableBuilder<T, ?>)new GitLabWebHookCauseBuilder((GitLabWebHookCause) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigStatus": return (VisitableBuilder<T, ?>)new DeploymentConfigStatusBuilder((DeploymentConfigStatus) item);
    case "io.fabric8.openshift.api.model."+"SecretBuildSource": return (VisitableBuilder<T, ?>)new SecretBuildSourceBuilder((SecretBuildSource) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicySpec": return (VisitableBuilder<T, ?>)new EgressNetworkPolicySpecBuilder((EgressNetworkPolicySpec) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepository": return (VisitableBuilder<T, ?>)new HelmChartRepositoryBuilder((HelmChartRepository) item);
    case "io.fabric8.openshift.api.model."+"TagEvent": return (VisitableBuilder<T, ?>)new TagEventBuilder((TagEvent) item);
    case "io.fabric8.openshift.api.model."+"BitbucketWebHookCause": return (VisitableBuilder<T, ?>)new BitbucketWebHookCauseBuilder((BitbucketWebHookCause) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamTagList": return (VisitableBuilder<T, ?>)new ImageStreamTagListBuilder((ImageStreamTagList) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigRollbackSpec": return (VisitableBuilder<T, ?>)new DeploymentConfigRollbackSpecBuilder((DeploymentConfigRollbackSpec) item);
    case "io.fabric8.openshift.api.model."+"ProjectList": return (VisitableBuilder<T, ?>)new ProjectListBuilder((ProjectList) item);
    case "io.fabric8.openshift.api.model."+"ProjectHelmChartRepositorySpec": return (VisitableBuilder<T, ?>)new ProjectHelmChartRepositorySpecBuilder((ProjectHelmChartRepositorySpec) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleScopeRestriction": return (VisitableBuilder<T, ?>)new ClusterRoleScopeRestrictionBuilder((ClusterRoleScopeRestriction) item);
    case "io.fabric8.openshift.api.model."+"RangeAllocation": return (VisitableBuilder<T, ?>)new RangeAllocationBuilder((RangeAllocation) item);
    case "io.fabric8.openshift.api.model."+"Route": return (VisitableBuilder<T, ?>)new RouteBuilder((Route) item);
    case "io.fabric8.openshift.api.model."+"SourceStrategyOptions": return (VisitableBuilder<T, ?>)new SourceStrategyOptionsBuilder((SourceStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"ClusterNetwork": return (VisitableBuilder<T, ?>)new ClusterNetworkBuilder((ClusterNetwork) item);
    case "io.fabric8.openshift.api.model."+"OAuthAuthorizeToken": return (VisitableBuilder<T, ?>)new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken) item);
    case "io.fabric8.openshift.api.model."+"DockerBuildStrategy": return (VisitableBuilder<T, ?>)new DockerBuildStrategyBuilder((DockerBuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"SignatureCondition": return (VisitableBuilder<T, ?>)new SignatureConditionBuilder((SignatureCondition) item);
    case "io.fabric8.openshift.api.model."+"UserOAuthAccessToken": return (VisitableBuilder<T, ?>)new UserOAuthAccessTokenBuilder((UserOAuthAccessToken) item);
    case "io.fabric8.openshift.api.model."+"ConnectionConfigNamespaceScoped": return (VisitableBuilder<T, ?>)new ConnectionConfigNamespaceScopedBuilder((ConnectionConfigNamespaceScoped) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingRestrictionList": return (VisitableBuilder<T, ?>)new RoleBindingRestrictionListBuilder((RoleBindingRestrictionList) item);
    case "io.fabric8.kubernetes.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new RawExtensionBuilder((RawExtension) item);
    case "io.fabric8.openshift.api.model."+"ImageManifest": return (VisitableBuilder<T, ?>)new ImageManifestBuilder((ImageManifest) item);
    case "io.fabric8.openshift.api.model."+"SecurityContextConstraintsList": return (VisitableBuilder<T, ?>)new SecurityContextConstraintsListBuilder((SecurityContextConstraintsList) item);
    case "io.fabric8.openshift.api.model."+"BuildConfigList": return (VisitableBuilder<T, ?>)new BuildConfigListBuilder((BuildConfigList) item);
    case "io.fabric8.openshift.api.model."+"IdentityList": return (VisitableBuilder<T, ?>)new IdentityListBuilder((IdentityList) item);
    case "io.fabric8.openshift.api.model."+"ClusterNetworkList": return (VisitableBuilder<T, ?>)new ClusterNetworkListBuilder((ClusterNetworkList) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceCondition": return (VisitableBuilder<T, ?>)new TemplateInstanceConditionBuilder((TemplateInstanceCondition) item);
    case "io.fabric8.openshift.api.model."+"DeploymentCause": return (VisitableBuilder<T, ?>)new DeploymentCauseBuilder((DeploymentCause) item);
    case "io.fabric8.openshift.api.model."+"RepositoryImportStatus": return (VisitableBuilder<T, ?>)new RepositoryImportStatusBuilder((RepositoryImportStatus) item);
    case "io.fabric8.openshift.api.model."+"GroupList": return (VisitableBuilder<T, ?>)new GroupListBuilder((GroupList) item);
    case "io.fabric8.openshift.api.model."+"RunAsUserStrategyOptions": return (VisitableBuilder<T, ?>)new RunAsUserStrategyOptionsBuilder((RunAsUserStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"LifecycleHook": return (VisitableBuilder<T, ?>)new LifecycleHookBuilder((LifecycleHook) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamTagReference": return (VisitableBuilder<T, ?>)new ImageStreamTagReferenceBuilder((ImageStreamTagReference) item);
    case "io.fabric8.openshift.api.model."+"SourceControlUser": return (VisitableBuilder<T, ?>)new SourceControlUserBuilder((SourceControlUser) item);
    case "io.fabric8.kubernetes.api.model."+"Container": return (VisitableBuilder<T, ?>)new ContainerBuilder((Container) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamList": return (VisitableBuilder<T, ?>)new ImageStreamListBuilder((ImageStreamList) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleBinding": return (VisitableBuilder<T, ?>)new ClusterRoleBindingBuilder((ClusterRoleBinding) item);
    case "io.fabric8.openshift.api.model."+"ResourceAccessReview": return (VisitableBuilder<T, ?>)new ResourceAccessReviewBuilder((ResourceAccessReview) item);
    case "io.fabric8.openshift.api.model."+"SelfSubjectRulesReview": return (VisitableBuilder<T, ?>)new SelfSubjectRulesReviewBuilder((SelfSubjectRulesReview) item);
    case "io.fabric8.openshift.api.model."+"UserOAuthAccessTokenList": return (VisitableBuilder<T, ?>)new UserOAuthAccessTokenListBuilder((UserOAuthAccessTokenList) item);
    case "io.fabric8.openshift.api.model."+"ImageChangeTriggerStatus": return (VisitableBuilder<T, ?>)new ImageChangeTriggerStatusBuilder((ImageChangeTriggerStatus) item);
    case "io.fabric8.openshift.api.model."+"RouteStatus": return (VisitableBuilder<T, ?>)new RouteStatusBuilder((RouteStatus) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigRollback": return (VisitableBuilder<T, ?>)new DeploymentConfigRollbackBuilder((DeploymentConfigRollback) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuota": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaBuilder((ClusterResourceQuota) item);
    case "io.fabric8.openshift.api.model."+"NamedTagEventList": return (VisitableBuilder<T, ?>)new NamedTagEventListBuilder((NamedTagEventList) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuotaList": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaListBuilder((ClusterResourceQuotaList) item);
    case "io.fabric8.openshift.api.model."+"RouteSpec": return (VisitableBuilder<T, ?>)new RouteSpecBuilder((RouteSpec) item);
    case "io.fabric8.openshift.api.model."+"ProjectRequest": return (VisitableBuilder<T, ?>)new ProjectRequestBuilder((ProjectRequest) item);
    case "io.fabric8.openshift.api.model."+"Template": return (VisitableBuilder<T, ?>)new TemplateBuilder((Template) item);
    case "io.fabric8.openshift.api.model."+"ImageLookupPolicy": return (VisitableBuilder<T, ?>)new ImageLookupPolicyBuilder((ImageLookupPolicy) item);
    case "io.fabric8.openshift.api.model."+"OAuthClientAuthorization": return (VisitableBuilder<T, ?>)new OAuthClientAuthorizationBuilder((OAuthClientAuthorization) item);
    case "io.fabric8.openshift.api.model."+"ImageChangeCause": return (VisitableBuilder<T, ?>)new ImageChangeCauseBuilder((ImageChangeCause) item);
    case "io.fabric8.openshift.api.model."+"AllowedFlexVolume": return (VisitableBuilder<T, ?>)new AllowedFlexVolumeBuilder((AllowedFlexVolume) item);
    case "io.fabric8.openshift.api.model."+"SubjectAccessReview": return (VisitableBuilder<T, ?>)new SubjectAccessReviewBuilder((SubjectAccessReview) item);
    case "io.fabric8.openshift.api.model."+"LocalResourceAccessReview": return (VisitableBuilder<T, ?>)new LocalResourceAccessReviewBuilder((LocalResourceAccessReview) item);
    case "io.fabric8.openshift.api.model."+"ClusterRole": return (VisitableBuilder<T, ?>)new ClusterRoleBuilder((ClusterRole) item);
    case "io.fabric8.openshift.api.model."+"ConnectionConfig": return (VisitableBuilder<T, ?>)new ConnectionConfigBuilder((ConnectionConfig) item);
    case "io.fabric8.openshift.api.model."+"TagEventCondition": return (VisitableBuilder<T, ?>)new TagEventConditionBuilder((TagEventCondition) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelector": return (VisitableBuilder<T, ?>)new LabelSelectorBuilder((LabelSelector) item);
    case "io.fabric8.openshift.api.model."+"NetNamespaceList": return (VisitableBuilder<T, ?>)new NetNamespaceListBuilder((NetNamespaceList) item);
    case "io.fabric8.openshift.api.model."+"BrokerTemplateInstanceSpec": return (VisitableBuilder<T, ?>)new BrokerTemplateInstanceSpecBuilder((BrokerTemplateInstanceSpec) item);
    case "io.fabric8.openshift.api.model."+"BinaryBuildSource": return (VisitableBuilder<T, ?>)new BinaryBuildSourceBuilder((BinaryBuildSource) item);
    case "io.fabric8.openshift.api.model."+"BuildSpec": return (VisitableBuilder<T, ?>)new BuildSpecBuilder((BuildSpec) item);
    case "io.fabric8.openshift.api.model."+"OAuthClientAuthorizationList": return (VisitableBuilder<T, ?>)new OAuthClientAuthorizationListBuilder((OAuthClientAuthorizationList) item);
    case "io.fabric8.openshift.api.model."+"LocalSubjectAccessReview": return (VisitableBuilder<T, ?>)new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReview) item);
    case "io.fabric8.openshift.api.model."+"ProjectStatus": return (VisitableBuilder<T, ?>)new ProjectStatusBuilder((ProjectStatus) item);
    case "io.fabric8.openshift.api.model."+"RollingDeploymentStrategyParams": return (VisitableBuilder<T, ?>)new RollingDeploymentStrategyParamsBuilder((RollingDeploymentStrategyParams) item);
    case "io.fabric8.openshift.api.model."+"GitSourceRevision": return (VisitableBuilder<T, ?>)new GitSourceRevisionBuilder((GitSourceRevision) item);
    case "io.fabric8.openshift.api.model."+"ImageLabel": return (VisitableBuilder<T, ?>)new ImageLabelBuilder((ImageLabel) item);
    case "io.fabric8.openshift.api.model."+"ImageChangeTrigger": return (VisitableBuilder<T, ?>)new ImageChangeTriggerBuilder((ImageChangeTrigger) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicyReviewSpec": return (VisitableBuilder<T, ?>)new PodSecurityPolicyReviewSpecBuilder((PodSecurityPolicyReviewSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImportSpec": return (VisitableBuilder<T, ?>)new ImageStreamImportSpecBuilder((ImageStreamImportSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageTag": return (VisitableBuilder<T, ?>)new ImageTagBuilder((ImageTag) item);
    case "io.fabric8.openshift.api.model."+"FSGroupStrategyOptions": return (VisitableBuilder<T, ?>)new FSGroupStrategyOptionsBuilder((FSGroupStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicyReview": return (VisitableBuilder<T, ?>)new PodSecurityPolicyReviewBuilder((PodSecurityPolicyReview) item);
    case "io.fabric8.openshift.api.model."+"RecreateDeploymentStrategyParams": return (VisitableBuilder<T, ?>)new RecreateDeploymentStrategyParamsBuilder((RecreateDeploymentStrategyParams) item);
    case "io.fabric8.openshift.api.model."+"DockerStrategyOptions": return (VisitableBuilder<T, ?>)new DockerStrategyOptionsBuilder((DockerStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"ImageList": return (VisitableBuilder<T, ?>)new ImageListBuilder((ImageList) item);
    case "io.fabric8.openshift.api.model."+"ConfigMapBuildSource": return (VisitableBuilder<T, ?>)new ConfigMapBuildSourceBuilder((ConfigMapBuildSource) item);
    case "io.fabric8.openshift.api.model."+"ImageTagList": return (VisitableBuilder<T, ?>)new ImageTagListBuilder((ImageTagList) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfig": return (VisitableBuilder<T, ?>)new DeploymentConfigBuilder((DeploymentConfig) item);
    case "io.fabric8.openshift.api.model."+"OAuthAccessToken": return (VisitableBuilder<T, ?>)new OAuthAccessTokenBuilder((OAuthAccessToken) item);
    case "io.fabric8.openshift.api.model."+"RoleBinding": return (VisitableBuilder<T, ?>)new RoleBindingBuilder((RoleBinding) item);
    case "io.fabric8.openshift.api.model."+"Image": return (VisitableBuilder<T, ?>)new ImageBuilder((Image) item);
    case "io.fabric8.openshift.api.model."+"TLSConfig": return (VisitableBuilder<T, ?>)new TLSConfigBuilder((TLSConfig) item);
    case "io.fabric8.openshift.api.model."+"BuildVolume": return (VisitableBuilder<T, ?>)new BuildVolumeBuilder((BuildVolume) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceSpec": return (VisitableBuilder<T, ?>)new TemplateInstanceSpecBuilder((TemplateInstanceSpec) item);
    case "io.fabric8.openshift.api.model."+"BuildStatus": return (VisitableBuilder<T, ?>)new BuildStatusBuilder((BuildStatus) item);
    case "io.fabric8.openshift.api.model."+"ImageSource": return (VisitableBuilder<T, ?>)new ImageSourceBuilder((ImageSource) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectMeta": return (VisitableBuilder<T, ?>)new ObjectMetaBuilder((ObjectMeta) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySelfSubjectReview": return (VisitableBuilder<T, ?>)new PodSecurityPolicySelfSubjectReviewBuilder((PodSecurityPolicySelfSubjectReview) item);
    case "io.fabric8.openshift.api.model."+"TagReference": return (VisitableBuilder<T, ?>)new TagReferenceBuilder((TagReference) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicyRule": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyRuleBuilder((EgressNetworkPolicyRule) item);
    case "io.fabric8.openshift.api.model."+"SubjectRulesReviewStatus": return (VisitableBuilder<T, ?>)new SubjectRulesReviewStatusBuilder((SubjectRulesReviewStatus) item);
    case "io.fabric8.openshift.api.model."+"BuildVolumeMount": return (VisitableBuilder<T, ?>)new BuildVolumeMountBuilder((BuildVolumeMount) item);
    case "io.fabric8.openshift.api.model."+"ClusterNetworkEntry": return (VisitableBuilder<T, ?>)new ClusterNetworkEntryBuilder((ClusterNetworkEntry) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceObject": return (VisitableBuilder<T, ?>)new TemplateInstanceObjectBuilder((TemplateInstanceObject) item);
    case "io.fabric8.openshift.api.model."+"BuildSource": return (VisitableBuilder<T, ?>)new BuildSourceBuilder((BuildSource) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuotaStatus": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaStatusBuilder((ClusterResourceQuotaStatus) item);
    case "io.fabric8.openshift.api.model."+"DeploymentCondition": return (VisitableBuilder<T, ?>)new DeploymentConditionBuilder((DeploymentCondition) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepositorySpec": return (VisitableBuilder<T, ?>)new HelmChartRepositorySpecBuilder((HelmChartRepositorySpec) item);
    case "io.fabric8.openshift.api.model."+"DeploymentCauseImageTrigger": return (VisitableBuilder<T, ?>)new DeploymentCauseImageTriggerBuilder((DeploymentCauseImageTrigger) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamMapping": return (VisitableBuilder<T, ?>)new ImageStreamMappingBuilder((ImageStreamMapping) item);
    case "io.fabric8.openshift.api.model."+"SubjectRulesReview": return (VisitableBuilder<T, ?>)new SubjectRulesReviewBuilder((SubjectRulesReview) item);
    case "io.fabric8.openshift.api.model."+"Role": return (VisitableBuilder<T, ?>)new RoleBuilder((Role) item);
    case "io.fabric8.openshift.api.model."+"GitBuildSource": return (VisitableBuilder<T, ?>)new GitBuildSourceBuilder((GitBuildSource) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicyList": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyListBuilder((EgressNetworkPolicyList) item);
    case "io.fabric8.openshift.api.model."+"SelfSubjectRulesReviewSpec": return (VisitableBuilder<T, ?>)new SelfSubjectRulesReviewSpecBuilder((SelfSubjectRulesReviewSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageSourcePath": return (VisitableBuilder<T, ?>)new ImageSourcePathBuilder((ImageSourcePath) item);
    case "io.fabric8.openshift.api.model."+"BuildConfigStatus": return (VisitableBuilder<T, ?>)new BuildConfigStatusBuilder((BuildConfigStatus) item);
    case "io.fabric8.openshift.api.model."+"ResourceQuotaStatusByNamespace": return (VisitableBuilder<T, ?>)new ResourceQuotaStatusByNamespaceBuilder((ResourceQuotaStatusByNamespace) item);
    case "io.fabric8.openshift.api.model."+"Parameter": return (VisitableBuilder<T, ?>)new ParameterBuilder((Parameter) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingList": return (VisitableBuilder<T, ?>)new RoleBindingListBuilder((RoleBindingList) item);
    case "io.fabric8.openshift.api.model."+"SourceBuildStrategy": return (VisitableBuilder<T, ?>)new SourceBuildStrategyBuilder((SourceBuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"BrokerTemplateInstance": return (VisitableBuilder<T, ?>)new BrokerTemplateInstanceBuilder((BrokerTemplateInstance) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySelfSubjectReviewSpec": return (VisitableBuilder<T, ?>)new PodSecurityPolicySelfSubjectReviewSpecBuilder((PodSecurityPolicySelfSubjectReviewSpec) item);
    case "io.fabric8.openshift.api.model."+"BuildPostCommitSpec": return (VisitableBuilder<T, ?>)new BuildPostCommitSpecBuilder((BuildPostCommitSpec) item);
    case "io.fabric8.openshift.api.model."+"DeploymentStrategy": return (VisitableBuilder<T, ?>)new DeploymentStrategyBuilder((DeploymentStrategy) item);
    case "io.fabric8.openshift.api.model."+"OAuthAuthorizeTokenList": return (VisitableBuilder<T, ?>)new OAuthAuthorizeTokenListBuilder((OAuthAuthorizeTokenList) item);
    case "io.fabric8.openshift.api.model."+"SignatureSubject": return (VisitableBuilder<T, ?>)new SignatureSubjectBuilder((SignatureSubject) item);
    case "io.fabric8.openshift.api.model."+"HostSubnetList": return (VisitableBuilder<T, ?>)new HostSubnetListBuilder((HostSubnetList) item);
    case "io.fabric8.openshift.api.model."+"RouteIngressCondition": return (VisitableBuilder<T, ?>)new RouteIngressConditionBuilder((RouteIngressCondition) item);
    case "io.fabric8.openshift.api.model."+"CustomDeploymentStrategyParams": return (VisitableBuilder<T, ?>)new CustomDeploymentStrategyParamsBuilder((CustomDeploymentStrategyParams) item);
    case "io.fabric8.openshift.api.model."+"ImageImportSpec": return (VisitableBuilder<T, ?>)new ImageImportSpecBuilder((ImageImportSpec) item);
    case "io.fabric8.openshift.api.model."+"StageInfo": return (VisitableBuilder<T, ?>)new StageInfoBuilder((StageInfo) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingRestrictionSpec": return (VisitableBuilder<T, ?>)new RoleBindingRestrictionSpecBuilder((RoleBindingRestrictionSpec) item);
    case "io.fabric8.openshift.api.model."+"IDRange": return (VisitableBuilder<T, ?>)new IDRangeBuilder((IDRange) item);
    case "io.fabric8.openshift.api.model."+"UserList": return (VisitableBuilder<T, ?>)new UserListBuilder((UserList) item);
    case "io.fabric8.openshift.api.model."+"BuildConfigSpec": return (VisitableBuilder<T, ?>)new BuildConfigSpecBuilder((BuildConfigSpec) item);
    case "io.fabric8.openshift.api.model."+"User": return (VisitableBuilder<T, ?>)new UserBuilder((User) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImage": return (VisitableBuilder<T, ?>)new ImageStreamImageBuilder((ImageStreamImage) item);
    case "io.fabric8.openshift.api.model."+"BuildCondition": return (VisitableBuilder<T, ?>)new BuildConditionBuilder((BuildCondition) item);
    case "io.fabric8.openshift.api.model."+"BuildStatusOutputTo": return (VisitableBuilder<T, ?>)new BuildStatusOutputToBuilder((BuildStatusOutputTo) item);
    case "io.fabric8.openshift.api.model."+"ResourceAccessReviewResponse": return (VisitableBuilder<T, ?>)new ResourceAccessReviewResponseBuilder((ResourceAccessReviewResponse) item);
    case "io.fabric8.openshift.api.model."+"ExecNewPodHook": return (VisitableBuilder<T, ?>)new ExecNewPodHookBuilder((ExecNewPodHook) item);
    case "io.fabric8.openshift.api.model."+"SecretSpec": return (VisitableBuilder<T, ?>)new SecretSpecBuilder((SecretSpec) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleBindingList": return (VisitableBuilder<T, ?>)new ClusterRoleBindingListBuilder((ClusterRoleBindingList) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicyPeer": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyPeerBuilder((EgressNetworkPolicyPeer) item);
    case "io.fabric8.openshift.api.model."+"ProjectHelmChartRepositoryList": return (VisitableBuilder<T, ?>)new ProjectHelmChartRepositoryListBuilder((ProjectHelmChartRepositoryList) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstance": return (VisitableBuilder<T, ?>)new TemplateInstanceBuilder((TemplateInstance) item);
    case "io.fabric8.openshift.api.model."+"WebHookTrigger": return (VisitableBuilder<T, ?>)new WebHookTriggerBuilder((WebHookTrigger) item);
    case "io.fabric8.openshift.api.model."+"Build": return (VisitableBuilder<T, ?>)new BuildBuilder((Build) item);
    case "io.fabric8.openshift.api.model."+"ServiceAccountReference": return (VisitableBuilder<T, ?>)new ServiceAccountReferenceBuilder((ServiceAccountReference) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingRestriction": return (VisitableBuilder<T, ?>)new RoleBindingRestrictionBuilder((RoleBindingRestriction) item);
    case "io.fabric8.openshift.api.model."+"TagImportPolicy": return (VisitableBuilder<T, ?>)new TagImportPolicyBuilder((TagImportPolicy) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamTag": return (VisitableBuilder<T, ?>)new ImageStreamTagBuilder((ImageStreamTag) item);
    case "io.fabric8.openshift.api.model."+"BuildTriggerPolicy": return (VisitableBuilder<T, ?>)new BuildTriggerPolicyBuilder((BuildTriggerPolicy) item);
    case "io.fabric8.openshift.api.model."+"RoutePort": return (VisitableBuilder<T, ?>)new RoutePortBuilder((RoutePort) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceRequester": return (VisitableBuilder<T, ?>)new TemplateInstanceRequesterBuilder((TemplateInstanceRequester) item);
    case "io.fabric8.openshift.api.model."+"Group": return (VisitableBuilder<T, ?>)new GroupBuilder((Group) item);
    case "io.fabric8.openshift.api.model."+"BuildTriggerCause": return (VisitableBuilder<T, ?>)new BuildTriggerCauseBuilder((BuildTriggerCause) item);
    case "io.fabric8.openshift.api.model."+"ImageSignature": return (VisitableBuilder<T, ?>)new ImageSignatureBuilder((ImageSignature) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepositoryStatus": return (VisitableBuilder<T, ?>)new HelmChartRepositoryStatusBuilder((HelmChartRepositoryStatus) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigSpec": return (VisitableBuilder<T, ?>)new DeploymentConfigSpecBuilder((DeploymentConfigSpec) item);
    case "io.fabric8.openshift.api.model."+"HostSubnet": return (VisitableBuilder<T, ?>)new HostSubnetBuilder((HostSubnet) item);
    case "io.fabric8.openshift.api.model."+"AppliedClusterResourceQuota": return (VisitableBuilder<T, ?>)new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota) item);
    case "io.fabric8.openshift.api.model."+"GroupRestriction": return (VisitableBuilder<T, ?>)new GroupRestrictionBuilder((GroupRestriction) item);
    case "io.fabric8.openshift.api.model."+"OAuthAccessTokenList": return (VisitableBuilder<T, ?>)new OAuthAccessTokenListBuilder((OAuthAccessTokenList) item);
    case "io.fabric8.openshift.api.model."+"JenkinsPipelineBuildStrategy": return (VisitableBuilder<T, ?>)new JenkinsPipelineBuildStrategyBuilder((JenkinsPipelineBuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"SecurityContextConstraints": return (VisitableBuilder<T, ?>)new SecurityContextConstraintsBuilder((SecurityContextConstraints) item);
    case "io.fabric8.openshift.api.model."+"SupplementalGroupsStrategyOptions": return (VisitableBuilder<T, ?>)new SupplementalGroupsStrategyOptionsBuilder((SupplementalGroupsStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"ServiceAccountPodSecurityPolicyReviewStatus": return (VisitableBuilder<T, ?>)new ServiceAccountPodSecurityPolicyReviewStatusBuilder((ServiceAccountPodSecurityPolicyReviewStatus) item);
    case "io.fabric8.openshift.api.model."+"BuildRequest": return (VisitableBuilder<T, ?>)new BuildRequestBuilder((BuildRequest) item);
    case "io.fabric8.openshift.api.model."+"SELinuxContextStrategyOptions": return (VisitableBuilder<T, ?>)new SELinuxContextStrategyOptionsBuilder((SELinuxContextStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleList": return (VisitableBuilder<T, ?>)new ClusterRoleListBuilder((ClusterRoleList) item);
    case "io.fabric8.openshift.api.model."+"RouteList": return (VisitableBuilder<T, ?>)new RouteListBuilder((RouteList) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamStatus": return (VisitableBuilder<T, ?>)new ImageStreamStatusBuilder((ImageStreamStatus) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicy": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyBuilder((EgressNetworkPolicy) item);
    case "io.fabric8.openshift.api.model."+"NetNamespace": return (VisitableBuilder<T, ?>)new NetNamespaceBuilder((NetNamespace) item);
    case "io.fabric8.openshift.api.model."+"DeploymentDetails": return (VisitableBuilder<T, ?>)new DeploymentDetailsBuilder((DeploymentDetails) item);
    case "io.fabric8.openshift.api.model."+"UserIdentityMapping": return (VisitableBuilder<T, ?>)new UserIdentityMappingBuilder((UserIdentityMapping) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySubjectReviewStatus": return (VisitableBuilder<T, ?>)new PodSecurityPolicySubjectReviewStatusBuilder((PodSecurityPolicySubjectReviewStatus) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySubjectReviewSpec": return (VisitableBuilder<T, ?>)new PodSecurityPolicySubjectReviewSpecBuilder((PodSecurityPolicySubjectReviewSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageStream": return (VisitableBuilder<T, ?>)new ImageStreamBuilder((ImageStream) item);
    case "io.fabric8.openshift.api.model."+"BuildList": return (VisitableBuilder<T, ?>)new BuildListBuilder((BuildList) item);
    case "io.fabric8.openshift.api.model."+"BuildOutput": return (VisitableBuilder<T, ?>)new BuildOutputBuilder((BuildOutput) item);
    case "io.fabric8.openshift.api.model."+"TemplateList": return (VisitableBuilder<T, ?>)new TemplateListBuilder((TemplateList) item);
    case "io.fabric8.openshift.api.model."+"ProjectSpec": return (VisitableBuilder<T, ?>)new ProjectSpecBuilder((ProjectSpec) item);
    case "io.fabric8.openshift.api.model."+"SourceRevision": return (VisitableBuilder<T, ?>)new SourceRevisionBuilder((SourceRevision) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectReference": return (VisitableBuilder<T, ?>)new ObjectReferenceBuilder((ObjectReference) item);
    case "io.fabric8.openshift.api.model."+"SignatureIssuer": return (VisitableBuilder<T, ?>)new SignatureIssuerBuilder((SignatureIssuer) item);
    case "io.fabric8.openshift.api.model."+"ImageLayer": return (VisitableBuilder<T, ?>)new ImageLayerBuilder((ImageLayer) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuotaSpec": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaSpecBuilder((ClusterResourceQuotaSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamSpec": return (VisitableBuilder<T, ?>)new ImageStreamSpecBuilder((ImageStreamSpec) item);
    case "io.fabric8.openshift.api.model."+"RouteIngress": return (VisitableBuilder<T, ?>)new RouteIngressBuilder((RouteIngress) item);
    case "io.fabric8.openshift.api.model."+"OAuthClient": return (VisitableBuilder<T, ?>)new OAuthClientBuilder((OAuthClient) item);
    case "io.fabric8.openshift.api.model."+"Identity": return (VisitableBuilder<T, ?>)new IdentityBuilder((Identity) item);
    case "io.fabric8.openshift.api.model."+"RangeAllocationList": return (VisitableBuilder<T, ?>)new RangeAllocationListBuilder((RangeAllocationList) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  
  public A withIsNonResourceURL() {
    return withIsNonResourceURL(true);
  }
  public class GenericWebHookCauseContentNested<N> extends GenericWebHookCauseFluent<GenericWebHookCauseContentNested<N>> implements Nested<N>{
    GenericWebHookCauseContentNested(GenericWebHookCause item) {
      this.builder = new GenericWebHookCauseBuilder(this, item);
    }
    GenericWebHookCauseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGenericWebHookCauseContent() {
      return and();
    }
    
  
  }
  public class ServiceAccountRestrictionContentNested<N> extends ServiceAccountRestrictionFluent<ServiceAccountRestrictionContentNested<N>> implements Nested<N>{
    ServiceAccountRestrictionContentNested(ServiceAccountRestriction item) {
      this.builder = new ServiceAccountRestrictionBuilder(this, item);
    }
    ServiceAccountRestrictionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endServiceAccountRestrictionContent() {
      return and();
    }
    
  
  }
  public class ScopeRestrictionContentNested<N> extends ScopeRestrictionFluent<ScopeRestrictionContentNested<N>> implements Nested<N>{
    ScopeRestrictionContentNested(ScopeRestriction item) {
      this.builder = new ScopeRestrictionBuilder(this, item);
    }
    ScopeRestrictionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endScopeRestrictionContent() {
      return and();
    }
    
  
  }
  public class SecretLocalReferenceContentNested<N> extends SecretLocalReferenceFluent<SecretLocalReferenceContentNested<N>> implements Nested<N>{
    SecretLocalReferenceContentNested(SecretLocalReference item) {
      this.builder = new SecretLocalReferenceBuilder(this, item);
    }
    SecretLocalReferenceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSecretLocalReferenceContent() {
      return and();
    }
    
  
  }
  public class StepInfoContentNested<N> extends StepInfoFluent<StepInfoContentNested<N>> implements Nested<N>{
    StepInfoContentNested(StepInfo item) {
      this.builder = new StepInfoBuilder(this, item);
    }
    StepInfoBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endStepInfoContent() {
      return and();
    }
    
  
  }
  public class UserRestrictionContentNested<N> extends UserRestrictionFluent<UserRestrictionContentNested<N>> implements Nested<N>{
    UserRestrictionContentNested(UserRestriction item) {
      this.builder = new UserRestrictionBuilder(this, item);
    }
    UserRestrictionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endUserRestrictionContent() {
      return and();
    }
    
  
  }
  public class PodTemplateSpecContentNested<N> extends PodTemplateSpecFluent<PodTemplateSpecContentNested<N>> implements Nested<N>{
    PodTemplateSpecContentNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodTemplateSpecContent() {
      return and();
    }
    
  
  }
  public class ProjectHelmChartRepositoryContentNested<N> extends ProjectHelmChartRepositoryFluent<ProjectHelmChartRepositoryContentNested<N>> implements Nested<N>{
    ProjectHelmChartRepositoryContentNested(ProjectHelmChartRepository item) {
      this.builder = new ProjectHelmChartRepositoryBuilder(this, item);
    }
    ProjectHelmChartRepositoryBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endProjectHelmChartRepositoryContent() {
      return and();
    }
    
  
  }
  public class TemplateInstanceListContentNested<N> extends TemplateInstanceListFluent<TemplateInstanceListContentNested<N>> implements Nested<N>{
    TemplateInstanceListContentNested(TemplateInstanceList item) {
      this.builder = new TemplateInstanceListBuilder(this, item);
    }
    TemplateInstanceListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateInstanceListContent() {
      return and();
    }
    
  
  }
  public class ImageStreamImportContentNested<N> extends ImageStreamImportFluent<ImageStreamImportContentNested<N>> implements Nested<N>{
    ImageStreamImportContentNested(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamImportContent() {
      return and();
    }
    
  
  }
  public class ResourceRequirementsContentNested<N> extends ResourceRequirementsFluent<ResourceRequirementsContentNested<N>> implements Nested<N>{
    ResourceRequirementsContentNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endResourceRequirementsContent() {
      return and();
    }
    
  
  }
  public class GitHubWebHookCauseContentNested<N> extends GitHubWebHookCauseFluent<GitHubWebHookCauseContentNested<N>> implements Nested<N>{
    GitHubWebHookCauseContentNested(GitHubWebHookCause item) {
      this.builder = new GitHubWebHookCauseBuilder(this, item);
    }
    GitHubWebHookCauseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGitHubWebHookCauseContent() {
      return and();
    }
    
  
  }
  public class OAuthClientListContentNested<N> extends OAuthClientListFluent<OAuthClientListContentNested<N>> implements Nested<N>{
    OAuthClientListContentNested(OAuthClientList item) {
      this.builder = new OAuthClientListBuilder(this, item);
    }
    OAuthClientListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOAuthClientListContent() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicyReviewStatusContentNested<N> extends PodSecurityPolicyReviewStatusFluent<PodSecurityPolicyReviewStatusContentNested<N>> implements Nested<N>{
    PodSecurityPolicyReviewStatusContentNested(PodSecurityPolicyReviewStatus item) {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this, item);
    }
    PodSecurityPolicyReviewStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodSecurityPolicyReviewStatusContent() {
      return and();
    }
    
  
  }
  public class TemplateInstanceStatusContentNested<N> extends TemplateInstanceStatusFluent<TemplateInstanceStatusContentNested<N>> implements Nested<N>{
    TemplateInstanceStatusContentNested(TemplateInstanceStatus item) {
      this.builder = new TemplateInstanceStatusBuilder(this, item);
    }
    TemplateInstanceStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateInstanceStatusContent() {
      return and();
    }
    
  
  }
  public class HelmChartRepositoryListContentNested<N> extends HelmChartRepositoryListFluent<HelmChartRepositoryListContentNested<N>> implements Nested<N>{
    HelmChartRepositoryListContentNested(HelmChartRepositoryList item) {
      this.builder = new HelmChartRepositoryListBuilder(this, item);
    }
    HelmChartRepositoryListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endHelmChartRepositoryListContent() {
      return and();
    }
    
  
  }
  public class PolicyRuleContentNested<N> extends PolicyRuleFluent<PolicyRuleContentNested<N>> implements Nested<N>{
    PolicyRuleContentNested(PolicyRule item) {
      this.builder = new PolicyRuleBuilder(this, item);
    }
    PolicyRuleBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPolicyRuleContent() {
      return and();
    }
    
  
  }
  public class DeploymentTriggerPolicyContentNested<N> extends DeploymentTriggerPolicyFluent<DeploymentTriggerPolicyContentNested<N>> implements Nested<N>{
    DeploymentTriggerPolicyContentNested(DeploymentTriggerPolicy item) {
      this.builder = new DeploymentTriggerPolicyBuilder(this, item);
    }
    DeploymentTriggerPolicyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentTriggerPolicyContent() {
      return and();
    }
    
  
  }
  public class BuildStrategyContentNested<N> extends BuildStrategyFluent<BuildStrategyContentNested<N>> implements Nested<N>{
    BuildStrategyContentNested(BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    BuildStrategyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildStrategyContent() {
      return and();
    }
    
  
  }
  public class RepositoryImportSpecContentNested<N> extends RepositoryImportSpecFluent<RepositoryImportSpecContentNested<N>> implements Nested<N>{
    RepositoryImportSpecContentNested(RepositoryImportSpec item) {
      this.builder = new RepositoryImportSpecBuilder(this, item);
    }
    RepositoryImportSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRepositoryImportSpecContent() {
      return and();
    }
    
  
  }
  public class BrokerTemplateInstanceListContentNested<N> extends BrokerTemplateInstanceListFluent<BrokerTemplateInstanceListContentNested<N>> implements Nested<N>{
    BrokerTemplateInstanceListContentNested(BrokerTemplateInstanceList item) {
      this.builder = new BrokerTemplateInstanceListBuilder(this, item);
    }
    BrokerTemplateInstanceListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBrokerTemplateInstanceListContent() {
      return and();
    }
    
  
  }
  public class ImageStreamImportStatusContentNested<N> extends ImageStreamImportStatusFluent<ImageStreamImportStatusContentNested<N>> implements Nested<N>{
    ImageStreamImportStatusContentNested(ImageStreamImportStatus item) {
      this.builder = new ImageStreamImportStatusBuilder(this, item);
    }
    ImageStreamImportStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamImportStatusContent() {
      return and();
    }
    
  
  }
  public class CustomBuildStrategyContentNested<N> extends CustomBuildStrategyFluent<CustomBuildStrategyContentNested<N>> implements Nested<N>{
    CustomBuildStrategyContentNested(CustomBuildStrategy item) {
      this.builder = new CustomBuildStrategyBuilder(this, item);
    }
    CustomBuildStrategyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endCustomBuildStrategyContent() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaSelectorContentNested<N> extends ClusterResourceQuotaSelectorFluent<ClusterResourceQuotaSelectorContentNested<N>> implements Nested<N>{
    ClusterResourceQuotaSelectorContentNested(ClusterResourceQuotaSelector item) {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this, item);
    }
    ClusterResourceQuotaSelectorBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterResourceQuotaSelectorContent() {
      return and();
    }
    
  
  }
  public class SubjectAccessReviewResponseContentNested<N> extends SubjectAccessReviewResponseFluent<SubjectAccessReviewResponseContentNested<N>> implements Nested<N>{
    SubjectAccessReviewResponseContentNested(SubjectAccessReviewResponse item) {
      this.builder = new SubjectAccessReviewResponseBuilder(this, item);
    }
    SubjectAccessReviewResponseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSubjectAccessReviewResponseContent() {
      return and();
    }
    
  
  }
  public class DeploymentTriggerImageChangeParamsContentNested<N> extends DeploymentTriggerImageChangeParamsFluent<DeploymentTriggerImageChangeParamsContentNested<N>> implements Nested<N>{
    DeploymentTriggerImageChangeParamsContentNested(DeploymentTriggerImageChangeParams item) {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
    }
    DeploymentTriggerImageChangeParamsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentTriggerImageChangeParamsContent() {
      return and();
    }
    
  
  }
  public class LocalObjectReferenceContentNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceContentNested<N>> implements Nested<N>{
    LocalObjectReferenceContentNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endLocalObjectReferenceContent() {
      return and();
    }
    
  
  }
  public class TagImageHookContentNested<N> extends TagImageHookFluent<TagImageHookContentNested<N>> implements Nested<N>{
    TagImageHookContentNested(TagImageHook item) {
      this.builder = new TagImageHookBuilder(this, item);
    }
    TagImageHookBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTagImageHookContent() {
      return and();
    }
    
  
  }
  public class RouteTargetReferenceContentNested<N> extends RouteTargetReferenceFluent<RouteTargetReferenceContentNested<N>> implements Nested<N>{
    RouteTargetReferenceContentNested(RouteTargetReference item) {
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    RouteTargetReferenceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRouteTargetReferenceContent() {
      return and();
    }
    
  
  }
  public class SubjectRulesReviewSpecContentNested<N> extends SubjectRulesReviewSpecFluent<SubjectRulesReviewSpecContentNested<N>> implements Nested<N>{
    SubjectRulesReviewSpecContentNested(SubjectRulesReviewSpec item) {
      this.builder = new SubjectRulesReviewSpecBuilder(this, item);
    }
    SubjectRulesReviewSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSubjectRulesReviewSpecContent() {
      return and();
    }
    
  
  }
  public class OpenshiftRawExtensionContentNested<N> extends io.fabric8.openshift.api.model.runtime.RawExtensionFluent<OpenshiftRawExtensionContentNested<N>> implements Nested<N>{
    OpenshiftRawExtensionContentNested(io.fabric8.openshift.api.model.runtime.RawExtension item) {
      this.builder = new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(this, item);
    }
    io.fabric8.openshift.api.model.runtime.RawExtensionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOpenshiftRawExtensionContent() {
      return and();
    }
    
  
  }
  public class RoleListContentNested<N> extends RoleListFluent<RoleListContentNested<N>> implements Nested<N>{
    RoleListContentNested(RoleList item) {
      this.builder = new RoleListBuilder(this, item);
    }
    RoleListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRoleListContent() {
      return and();
    }
    
  
  }
  public class TagReferencePolicyContentNested<N> extends TagReferencePolicyFluent<TagReferencePolicyContentNested<N>> implements Nested<N>{
    TagReferencePolicyContentNested(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    TagReferencePolicyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTagReferencePolicyContent() {
      return and();
    }
    
  
  }
  public class ProjectContentNested<N> extends ProjectFluent<ProjectContentNested<N>> implements Nested<N>{
    ProjectContentNested(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endProjectContent() {
      return and();
    }
    
  
  }
  public class BuildVolumeSourceContentNested<N> extends BuildVolumeSourceFluent<BuildVolumeSourceContentNested<N>> implements Nested<N>{
    BuildVolumeSourceContentNested(BuildVolumeSource item) {
      this.builder = new BuildVolumeSourceBuilder(this, item);
    }
    BuildVolumeSourceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildVolumeSourceContent() {
      return and();
    }
    
  
  }
  public class AppliedClusterResourceQuotaListContentNested<N> extends AppliedClusterResourceQuotaListFluent<AppliedClusterResourceQuotaListContentNested<N>> implements Nested<N>{
    AppliedClusterResourceQuotaListContentNested(AppliedClusterResourceQuotaList item) {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this, item);
    }
    AppliedClusterResourceQuotaListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endAppliedClusterResourceQuotaListContent() {
      return and();
    }
    
  
  }
  public class BuildStatusOutputContentNested<N> extends BuildStatusOutputFluent<BuildStatusOutputContentNested<N>> implements Nested<N>{
    BuildStatusOutputContentNested(BuildStatusOutput item) {
      this.builder = new BuildStatusOutputBuilder(this, item);
    }
    BuildStatusOutputBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildStatusOutputContent() {
      return and();
    }
    
  
  }
  public class DeploymentConfigListContentNested<N> extends DeploymentConfigListFluent<DeploymentConfigListContentNested<N>> implements Nested<N>{
    DeploymentConfigListContentNested(DeploymentConfigList item) {
      this.builder = new DeploymentConfigListBuilder(this, item);
    }
    DeploymentConfigListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentConfigListContent() {
      return and();
    }
    
  
  }
  public class BuildConfigContentNested<N> extends BuildConfigFluent<BuildConfigContentNested<N>> implements Nested<N>{
    BuildConfigContentNested(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildConfigContent() {
      return and();
    }
    
  
  }
  public class ImageImportStatusContentNested<N> extends ImageImportStatusFluent<ImageImportStatusContentNested<N>> implements Nested<N>{
    ImageImportStatusContentNested(ImageImportStatus item) {
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImageImportStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageImportStatusContent() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySubjectReviewContentNested<N> extends PodSecurityPolicySubjectReviewFluent<PodSecurityPolicySubjectReviewContentNested<N>> implements Nested<N>{
    PodSecurityPolicySubjectReviewContentNested(PodSecurityPolicySubjectReview item) {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodSecurityPolicySubjectReviewContent() {
      return and();
    }
    
  
  }
  public class GitLabWebHookCauseContentNested<N> extends GitLabWebHookCauseFluent<GitLabWebHookCauseContentNested<N>> implements Nested<N>{
    GitLabWebHookCauseContentNested(GitLabWebHookCause item) {
      this.builder = new GitLabWebHookCauseBuilder(this, item);
    }
    GitLabWebHookCauseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGitLabWebHookCauseContent() {
      return and();
    }
    
  
  }
  public class DeploymentConfigStatusContentNested<N> extends DeploymentConfigStatusFluent<DeploymentConfigStatusContentNested<N>> implements Nested<N>{
    DeploymentConfigStatusContentNested(DeploymentConfigStatus item) {
      this.builder = new DeploymentConfigStatusBuilder(this, item);
    }
    DeploymentConfigStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentConfigStatusContent() {
      return and();
    }
    
  
  }
  public class SecretBuildSourceContentNested<N> extends SecretBuildSourceFluent<SecretBuildSourceContentNested<N>> implements Nested<N>{
    SecretBuildSourceContentNested(SecretBuildSource item) {
      this.builder = new SecretBuildSourceBuilder(this, item);
    }
    SecretBuildSourceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSecretBuildSourceContent() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicySpecContentNested<N> extends EgressNetworkPolicySpecFluent<EgressNetworkPolicySpecContentNested<N>> implements Nested<N>{
    EgressNetworkPolicySpecContentNested(EgressNetworkPolicySpec item) {
      this.builder = new EgressNetworkPolicySpecBuilder(this, item);
    }
    EgressNetworkPolicySpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endEgressNetworkPolicySpecContent() {
      return and();
    }
    
  
  }
  public class HelmChartRepositoryContentNested<N> extends HelmChartRepositoryFluent<HelmChartRepositoryContentNested<N>> implements Nested<N>{
    HelmChartRepositoryContentNested(HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endHelmChartRepositoryContent() {
      return and();
    }
    
  
  }
  public class TagEventContentNested<N> extends TagEventFluent<TagEventContentNested<N>> implements Nested<N>{
    TagEventContentNested(TagEvent item) {
      this.builder = new TagEventBuilder(this, item);
    }
    TagEventBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTagEventContent() {
      return and();
    }
    
  
  }
  public class BitbucketWebHookCauseContentNested<N> extends BitbucketWebHookCauseFluent<BitbucketWebHookCauseContentNested<N>> implements Nested<N>{
    BitbucketWebHookCauseContentNested(BitbucketWebHookCause item) {
      this.builder = new BitbucketWebHookCauseBuilder(this, item);
    }
    BitbucketWebHookCauseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBitbucketWebHookCauseContent() {
      return and();
    }
    
  
  }
  public class ImageStreamTagListContentNested<N> extends ImageStreamTagListFluent<ImageStreamTagListContentNested<N>> implements Nested<N>{
    ImageStreamTagListContentNested(ImageStreamTagList item) {
      this.builder = new ImageStreamTagListBuilder(this, item);
    }
    ImageStreamTagListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamTagListContent() {
      return and();
    }
    
  
  }
  public class DeploymentConfigRollbackSpecContentNested<N> extends DeploymentConfigRollbackSpecFluent<DeploymentConfigRollbackSpecContentNested<N>> implements Nested<N>{
    DeploymentConfigRollbackSpecContentNested(DeploymentConfigRollbackSpec item) {
      this.builder = new DeploymentConfigRollbackSpecBuilder(this, item);
    }
    DeploymentConfigRollbackSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentConfigRollbackSpecContent() {
      return and();
    }
    
  
  }
  public class ProjectListContentNested<N> extends ProjectListFluent<ProjectListContentNested<N>> implements Nested<N>{
    ProjectListContentNested(ProjectList item) {
      this.builder = new ProjectListBuilder(this, item);
    }
    ProjectListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endProjectListContent() {
      return and();
    }
    
  
  }
  public class ProjectHelmChartRepositorySpecContentNested<N> extends ProjectHelmChartRepositorySpecFluent<ProjectHelmChartRepositorySpecContentNested<N>> implements Nested<N>{
    ProjectHelmChartRepositorySpecContentNested(ProjectHelmChartRepositorySpec item) {
      this.builder = new ProjectHelmChartRepositorySpecBuilder(this, item);
    }
    ProjectHelmChartRepositorySpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endProjectHelmChartRepositorySpecContent() {
      return and();
    }
    
  
  }
  public class ClusterRoleScopeRestrictionContentNested<N> extends ClusterRoleScopeRestrictionFluent<ClusterRoleScopeRestrictionContentNested<N>> implements Nested<N>{
    ClusterRoleScopeRestrictionContentNested(ClusterRoleScopeRestriction item) {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
    }
    ClusterRoleScopeRestrictionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterRoleScopeRestrictionContent() {
      return and();
    }
    
  
  }
  public class RangeAllocationContentNested<N> extends RangeAllocationFluent<RangeAllocationContentNested<N>> implements Nested<N>{
    RangeAllocationContentNested(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRangeAllocationContent() {
      return and();
    }
    
  
  }
  public class RouteContentNested<N> extends RouteFluent<RouteContentNested<N>> implements Nested<N>{
    RouteContentNested(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRouteContent() {
      return and();
    }
    
  
  }
  public class SourceStrategyOptionsContentNested<N> extends SourceStrategyOptionsFluent<SourceStrategyOptionsContentNested<N>> implements Nested<N>{
    SourceStrategyOptionsContentNested(SourceStrategyOptions item) {
      this.builder = new SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSourceStrategyOptionsContent() {
      return and();
    }
    
  
  }
  public class ClusterNetworkContentNested<N> extends ClusterNetworkFluent<ClusterNetworkContentNested<N>> implements Nested<N>{
    ClusterNetworkContentNested(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterNetworkContent() {
      return and();
    }
    
  
  }
  public class OAuthAuthorizeTokenContentNested<N> extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenContentNested<N>> implements Nested<N>{
    OAuthAuthorizeTokenContentNested(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOAuthAuthorizeTokenContent() {
      return and();
    }
    
  
  }
  public class DockerBuildStrategyContentNested<N> extends DockerBuildStrategyFluent<DockerBuildStrategyContentNested<N>> implements Nested<N>{
    DockerBuildStrategyContentNested(DockerBuildStrategy item) {
      this.builder = new DockerBuildStrategyBuilder(this, item);
    }
    DockerBuildStrategyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDockerBuildStrategyContent() {
      return and();
    }
    
  
  }
  public class SignatureConditionContentNested<N> extends SignatureConditionFluent<SignatureConditionContentNested<N>> implements Nested<N>{
    SignatureConditionContentNested(SignatureCondition item) {
      this.builder = new SignatureConditionBuilder(this, item);
    }
    SignatureConditionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSignatureConditionContent() {
      return and();
    }
    
  
  }
  public class UserOAuthAccessTokenContentNested<N> extends UserOAuthAccessTokenFluent<UserOAuthAccessTokenContentNested<N>> implements Nested<N>{
    UserOAuthAccessTokenContentNested(UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endUserOAuthAccessTokenContent() {
      return and();
    }
    
  
  }
  public class ConnectionConfigNamespaceScopedContentNested<N> extends ConnectionConfigNamespaceScopedFluent<ConnectionConfigNamespaceScopedContentNested<N>> implements Nested<N>{
    ConnectionConfigNamespaceScopedContentNested(ConnectionConfigNamespaceScoped item) {
      this.builder = new ConnectionConfigNamespaceScopedBuilder(this, item);
    }
    ConnectionConfigNamespaceScopedBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endConnectionConfigNamespaceScopedContent() {
      return and();
    }
    
  
  }
  public class RoleBindingRestrictionListContentNested<N> extends RoleBindingRestrictionListFluent<RoleBindingRestrictionListContentNested<N>> implements Nested<N>{
    RoleBindingRestrictionListContentNested(RoleBindingRestrictionList item) {
      this.builder = new RoleBindingRestrictionListBuilder(this, item);
    }
    RoleBindingRestrictionListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRoleBindingRestrictionListContent() {
      return and();
    }
    
  
  }
  public class RawExtensionContentNested<N> extends RawExtensionFluent<RawExtensionContentNested<N>> implements Nested<N>{
    RawExtensionContentNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRawExtensionContent() {
      return and();
    }
    
  
  }
  public class ImageManifestContentNested<N> extends ImageManifestFluent<ImageManifestContentNested<N>> implements Nested<N>{
    ImageManifestContentNested(ImageManifest item) {
      this.builder = new ImageManifestBuilder(this, item);
    }
    ImageManifestBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageManifestContent() {
      return and();
    }
    
  
  }
  public class SecurityContextConstraintsListContentNested<N> extends SecurityContextConstraintsListFluent<SecurityContextConstraintsListContentNested<N>> implements Nested<N>{
    SecurityContextConstraintsListContentNested(SecurityContextConstraintsList item) {
      this.builder = new SecurityContextConstraintsListBuilder(this, item);
    }
    SecurityContextConstraintsListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSecurityContextConstraintsListContent() {
      return and();
    }
    
  
  }
  public class BuildConfigListContentNested<N> extends BuildConfigListFluent<BuildConfigListContentNested<N>> implements Nested<N>{
    BuildConfigListContentNested(BuildConfigList item) {
      this.builder = new BuildConfigListBuilder(this, item);
    }
    BuildConfigListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildConfigListContent() {
      return and();
    }
    
  
  }
  public class IdentityListContentNested<N> extends IdentityListFluent<IdentityListContentNested<N>> implements Nested<N>{
    IdentityListContentNested(IdentityList item) {
      this.builder = new IdentityListBuilder(this, item);
    }
    IdentityListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endIdentityListContent() {
      return and();
    }
    
  
  }
  public class ClusterNetworkListContentNested<N> extends ClusterNetworkListFluent<ClusterNetworkListContentNested<N>> implements Nested<N>{
    ClusterNetworkListContentNested(ClusterNetworkList item) {
      this.builder = new ClusterNetworkListBuilder(this, item);
    }
    ClusterNetworkListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterNetworkListContent() {
      return and();
    }
    
  
  }
  public class TemplateInstanceConditionContentNested<N> extends TemplateInstanceConditionFluent<TemplateInstanceConditionContentNested<N>> implements Nested<N>{
    TemplateInstanceConditionContentNested(TemplateInstanceCondition item) {
      this.builder = new TemplateInstanceConditionBuilder(this, item);
    }
    TemplateInstanceConditionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateInstanceConditionContent() {
      return and();
    }
    
  
  }
  public class DeploymentCauseContentNested<N> extends DeploymentCauseFluent<DeploymentCauseContentNested<N>> implements Nested<N>{
    DeploymentCauseContentNested(DeploymentCause item) {
      this.builder = new DeploymentCauseBuilder(this, item);
    }
    DeploymentCauseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentCauseContent() {
      return and();
    }
    
  
  }
  public class RepositoryImportStatusContentNested<N> extends RepositoryImportStatusFluent<RepositoryImportStatusContentNested<N>> implements Nested<N>{
    RepositoryImportStatusContentNested(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryImportStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRepositoryImportStatusContent() {
      return and();
    }
    
  
  }
  public class GroupListContentNested<N> extends GroupListFluent<GroupListContentNested<N>> implements Nested<N>{
    GroupListContentNested(GroupList item) {
      this.builder = new GroupListBuilder(this, item);
    }
    GroupListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGroupListContent() {
      return and();
    }
    
  
  }
  public class RunAsUserStrategyOptionsContentNested<N> extends RunAsUserStrategyOptionsFluent<RunAsUserStrategyOptionsContentNested<N>> implements Nested<N>{
    RunAsUserStrategyOptionsContentNested(RunAsUserStrategyOptions item) {
      this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRunAsUserStrategyOptionsContent() {
      return and();
    }
    
  
  }
  public class LifecycleHookContentNested<N> extends LifecycleHookFluent<LifecycleHookContentNested<N>> implements Nested<N>{
    LifecycleHookContentNested(LifecycleHook item) {
      this.builder = new LifecycleHookBuilder(this, item);
    }
    LifecycleHookBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endLifecycleHookContent() {
      return and();
    }
    
  
  }
  public class ImageStreamTagReferenceContentNested<N> extends ImageStreamTagReferenceFluent<ImageStreamTagReferenceContentNested<N>> implements Nested<N>{
    ImageStreamTagReferenceContentNested(ImageStreamTagReference item) {
      this.builder = new ImageStreamTagReferenceBuilder(this, item);
    }
    ImageStreamTagReferenceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamTagReferenceContent() {
      return and();
    }
    
  
  }
  public class SourceControlUserContentNested<N> extends SourceControlUserFluent<SourceControlUserContentNested<N>> implements Nested<N>{
    SourceControlUserContentNested(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    SourceControlUserBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSourceControlUserContent() {
      return and();
    }
    
  
  }
  public class ContainerContentNested<N> extends ContainerFluent<ContainerContentNested<N>> implements Nested<N>{
    ContainerContentNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endContainerContent() {
      return and();
    }
    
  
  }
  public class ImageStreamListContentNested<N> extends ImageStreamListFluent<ImageStreamListContentNested<N>> implements Nested<N>{
    ImageStreamListContentNested(ImageStreamList item) {
      this.builder = new ImageStreamListBuilder(this, item);
    }
    ImageStreamListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamListContent() {
      return and();
    }
    
  
  }
  public class ClusterRoleBindingContentNested<N> extends ClusterRoleBindingFluent<ClusterRoleBindingContentNested<N>> implements Nested<N>{
    ClusterRoleBindingContentNested(ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterRoleBindingContent() {
      return and();
    }
    
  
  }
  public class ResourceAccessReviewContentNested<N> extends ResourceAccessReviewFluent<ResourceAccessReviewContentNested<N>> implements Nested<N>{
    ResourceAccessReviewContentNested(ResourceAccessReview item) {
      this.builder = new ResourceAccessReviewBuilder(this, item);
    }
    ResourceAccessReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endResourceAccessReviewContent() {
      return and();
    }
    
  
  }
  public class SelfSubjectRulesReviewContentNested<N> extends SelfSubjectRulesReviewFluent<SelfSubjectRulesReviewContentNested<N>> implements Nested<N>{
    SelfSubjectRulesReviewContentNested(SelfSubjectRulesReview item) {
      this.builder = new SelfSubjectRulesReviewBuilder(this, item);
    }
    SelfSubjectRulesReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSelfSubjectRulesReviewContent() {
      return and();
    }
    
  
  }
  public class UserOAuthAccessTokenListContentNested<N> extends UserOAuthAccessTokenListFluent<UserOAuthAccessTokenListContentNested<N>> implements Nested<N>{
    UserOAuthAccessTokenListContentNested(UserOAuthAccessTokenList item) {
      this.builder = new UserOAuthAccessTokenListBuilder(this, item);
    }
    UserOAuthAccessTokenListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endUserOAuthAccessTokenListContent() {
      return and();
    }
    
  
  }
  public class ImageChangeTriggerStatusContentNested<N> extends ImageChangeTriggerStatusFluent<ImageChangeTriggerStatusContentNested<N>> implements Nested<N>{
    ImageChangeTriggerStatusContentNested(ImageChangeTriggerStatus item) {
      this.builder = new ImageChangeTriggerStatusBuilder(this, item);
    }
    ImageChangeTriggerStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageChangeTriggerStatusContent() {
      return and();
    }
    
  
  }
  public class RouteStatusContentNested<N> extends RouteStatusFluent<RouteStatusContentNested<N>> implements Nested<N>{
    RouteStatusContentNested(RouteStatus item) {
      this.builder = new RouteStatusBuilder(this, item);
    }
    RouteStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRouteStatusContent() {
      return and();
    }
    
  
  }
  public class DeploymentConfigRollbackContentNested<N> extends DeploymentConfigRollbackFluent<DeploymentConfigRollbackContentNested<N>> implements Nested<N>{
    DeploymentConfigRollbackContentNested(DeploymentConfigRollback item) {
      this.builder = new DeploymentConfigRollbackBuilder(this, item);
    }
    DeploymentConfigRollbackBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentConfigRollbackContent() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaContentNested<N> extends ClusterResourceQuotaFluent<ClusterResourceQuotaContentNested<N>> implements Nested<N>{
    ClusterResourceQuotaContentNested(ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterResourceQuotaContent() {
      return and();
    }
    
  
  }
  public class NamedTagEventListContentNested<N> extends NamedTagEventListFluent<NamedTagEventListContentNested<N>> implements Nested<N>{
    NamedTagEventListContentNested(NamedTagEventList item) {
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    NamedTagEventListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endNamedTagEventListContent() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaListContentNested<N> extends ClusterResourceQuotaListFluent<ClusterResourceQuotaListContentNested<N>> implements Nested<N>{
    ClusterResourceQuotaListContentNested(ClusterResourceQuotaList item) {
      this.builder = new ClusterResourceQuotaListBuilder(this, item);
    }
    ClusterResourceQuotaListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterResourceQuotaListContent() {
      return and();
    }
    
  
  }
  public class RouteSpecContentNested<N> extends RouteSpecFluent<RouteSpecContentNested<N>> implements Nested<N>{
    RouteSpecContentNested(RouteSpec item) {
      this.builder = new RouteSpecBuilder(this, item);
    }
    RouteSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRouteSpecContent() {
      return and();
    }
    
  
  }
  public class ProjectRequestContentNested<N> extends ProjectRequestFluent<ProjectRequestContentNested<N>> implements Nested<N>{
    ProjectRequestContentNested(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endProjectRequestContent() {
      return and();
    }
    
  
  }
  public class TemplateContentNested<N> extends TemplateFluent<TemplateContentNested<N>> implements Nested<N>{
    TemplateContentNested(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateContent() {
      return and();
    }
    
  
  }
  public class ImageLookupPolicyContentNested<N> extends ImageLookupPolicyFluent<ImageLookupPolicyContentNested<N>> implements Nested<N>{
    ImageLookupPolicyContentNested(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    ImageLookupPolicyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageLookupPolicyContent() {
      return and();
    }
    
  
  }
  public class OAuthClientAuthorizationContentNested<N> extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationContentNested<N>> implements Nested<N>{
    OAuthClientAuthorizationContentNested(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOAuthClientAuthorizationContent() {
      return and();
    }
    
  
  }
  public class ImageChangeCauseContentNested<N> extends ImageChangeCauseFluent<ImageChangeCauseContentNested<N>> implements Nested<N>{
    ImageChangeCauseContentNested(ImageChangeCause item) {
      this.builder = new ImageChangeCauseBuilder(this, item);
    }
    ImageChangeCauseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageChangeCauseContent() {
      return and();
    }
    
  
  }
  public class AllowedFlexVolumeContentNested<N> extends AllowedFlexVolumeFluent<AllowedFlexVolumeContentNested<N>> implements Nested<N>{
    AllowedFlexVolumeContentNested(AllowedFlexVolume item) {
      this.builder = new AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumeBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endAllowedFlexVolumeContent() {
      return and();
    }
    
  
  }
  public class SubjectAccessReviewContentNested<N> extends SubjectAccessReviewFluent<SubjectAccessReviewContentNested<N>> implements Nested<N>{
    SubjectAccessReviewContentNested(SubjectAccessReview item) {
      this.builder = new SubjectAccessReviewBuilder(this, item);
    }
    SubjectAccessReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSubjectAccessReviewContent() {
      return and();
    }
    
  
  }
  public class LocalResourceAccessReviewContentNested<N> extends LocalResourceAccessReviewFluent<LocalResourceAccessReviewContentNested<N>> implements Nested<N>{
    LocalResourceAccessReviewContentNested(LocalResourceAccessReview item) {
      this.builder = new LocalResourceAccessReviewBuilder(this, item);
    }
    LocalResourceAccessReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endLocalResourceAccessReviewContent() {
      return and();
    }
    
  
  }
  public class ClusterRoleContentNested<N> extends ClusterRoleFluent<ClusterRoleContentNested<N>> implements Nested<N>{
    ClusterRoleContentNested(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterRoleContent() {
      return and();
    }
    
  
  }
  public class ConnectionConfigContentNested<N> extends ConnectionConfigFluent<ConnectionConfigContentNested<N>> implements Nested<N>{
    ConnectionConfigContentNested(ConnectionConfig item) {
      this.builder = new ConnectionConfigBuilder(this, item);
    }
    ConnectionConfigBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endConnectionConfigContent() {
      return and();
    }
    
  
  }
  public class TagEventConditionContentNested<N> extends TagEventConditionFluent<TagEventConditionContentNested<N>> implements Nested<N>{
    TagEventConditionContentNested(TagEventCondition item) {
      this.builder = new TagEventConditionBuilder(this, item);
    }
    TagEventConditionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTagEventConditionContent() {
      return and();
    }
    
  
  }
  public class LabelSelectorContentNested<N> extends LabelSelectorFluent<LabelSelectorContentNested<N>> implements Nested<N>{
    LabelSelectorContentNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endLabelSelectorContent() {
      return and();
    }
    
  
  }
  public class NetNamespaceListContentNested<N> extends NetNamespaceListFluent<NetNamespaceListContentNested<N>> implements Nested<N>{
    NetNamespaceListContentNested(NetNamespaceList item) {
      this.builder = new NetNamespaceListBuilder(this, item);
    }
    NetNamespaceListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endNetNamespaceListContent() {
      return and();
    }
    
  
  }
  public class BrokerTemplateInstanceSpecContentNested<N> extends BrokerTemplateInstanceSpecFluent<BrokerTemplateInstanceSpecContentNested<N>> implements Nested<N>{
    BrokerTemplateInstanceSpecContentNested(BrokerTemplateInstanceSpec item) {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this, item);
    }
    BrokerTemplateInstanceSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBrokerTemplateInstanceSpecContent() {
      return and();
    }
    
  
  }
  public class BinaryBuildSourceContentNested<N> extends BinaryBuildSourceFluent<BinaryBuildSourceContentNested<N>> implements Nested<N>{
    BinaryBuildSourceContentNested(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryBuildSourceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBinaryBuildSourceContent() {
      return and();
    }
    
  
  }
  public class BuildSpecContentNested<N> extends BuildSpecFluent<BuildSpecContentNested<N>> implements Nested<N>{
    BuildSpecContentNested(BuildSpec item) {
      this.builder = new BuildSpecBuilder(this, item);
    }
    BuildSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildSpecContent() {
      return and();
    }
    
  
  }
  public class OAuthClientAuthorizationListContentNested<N> extends OAuthClientAuthorizationListFluent<OAuthClientAuthorizationListContentNested<N>> implements Nested<N>{
    OAuthClientAuthorizationListContentNested(OAuthClientAuthorizationList item) {
      this.builder = new OAuthClientAuthorizationListBuilder(this, item);
    }
    OAuthClientAuthorizationListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOAuthClientAuthorizationListContent() {
      return and();
    }
    
  
  }
  public class LocalSubjectAccessReviewContentNested<N> extends LocalSubjectAccessReviewFluent<LocalSubjectAccessReviewContentNested<N>> implements Nested<N>{
    LocalSubjectAccessReviewContentNested(LocalSubjectAccessReview item) {
      this.builder = new LocalSubjectAccessReviewBuilder(this, item);
    }
    LocalSubjectAccessReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endLocalSubjectAccessReviewContent() {
      return and();
    }
    
  
  }
  public class ProjectStatusContentNested<N> extends ProjectStatusFluent<ProjectStatusContentNested<N>> implements Nested<N>{
    ProjectStatusContentNested(ProjectStatus item) {
      this.builder = new ProjectStatusBuilder(this, item);
    }
    ProjectStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endProjectStatusContent() {
      return and();
    }
    
  
  }
  public class RollingDeploymentStrategyParamsContentNested<N> extends RollingDeploymentStrategyParamsFluent<RollingDeploymentStrategyParamsContentNested<N>> implements Nested<N>{
    RollingDeploymentStrategyParamsContentNested(RollingDeploymentStrategyParams item) {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
    }
    RollingDeploymentStrategyParamsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRollingDeploymentStrategyParamsContent() {
      return and();
    }
    
  
  }
  public class GitSourceRevisionContentNested<N> extends GitSourceRevisionFluent<GitSourceRevisionContentNested<N>> implements Nested<N>{
    GitSourceRevisionContentNested(GitSourceRevision item) {
      this.builder = new GitSourceRevisionBuilder(this, item);
    }
    GitSourceRevisionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGitSourceRevisionContent() {
      return and();
    }
    
  
  }
  public class ImageLabelContentNested<N> extends ImageLabelFluent<ImageLabelContentNested<N>> implements Nested<N>{
    ImageLabelContentNested(ImageLabel item) {
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageLabelContent() {
      return and();
    }
    
  
  }
  public class ImageChangeTriggerContentNested<N> extends ImageChangeTriggerFluent<ImageChangeTriggerContentNested<N>> implements Nested<N>{
    ImageChangeTriggerContentNested(ImageChangeTrigger item) {
      this.builder = new ImageChangeTriggerBuilder(this, item);
    }
    ImageChangeTriggerBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageChangeTriggerContent() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicyReviewSpecContentNested<N> extends PodSecurityPolicyReviewSpecFluent<PodSecurityPolicyReviewSpecContentNested<N>> implements Nested<N>{
    PodSecurityPolicyReviewSpecContentNested(PodSecurityPolicyReviewSpec item) {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this, item);
    }
    PodSecurityPolicyReviewSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodSecurityPolicyReviewSpecContent() {
      return and();
    }
    
  
  }
  public class ImageStreamImportSpecContentNested<N> extends ImageStreamImportSpecFluent<ImageStreamImportSpecContentNested<N>> implements Nested<N>{
    ImageStreamImportSpecContentNested(ImageStreamImportSpec item) {
      this.builder = new ImageStreamImportSpecBuilder(this, item);
    }
    ImageStreamImportSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamImportSpecContent() {
      return and();
    }
    
  
  }
  public class ImageTagContentNested<N> extends ImageTagFluent<ImageTagContentNested<N>> implements Nested<N>{
    ImageTagContentNested(ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageTagContent() {
      return and();
    }
    
  
  }
  public class FSGroupStrategyOptionsContentNested<N> extends FSGroupStrategyOptionsFluent<FSGroupStrategyOptionsContentNested<N>> implements Nested<N>{
    FSGroupStrategyOptionsContentNested(FSGroupStrategyOptions item) {
      this.builder = new FSGroupStrategyOptionsBuilder(this, item);
    }
    FSGroupStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endFSGroupStrategyOptionsContent() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicyReviewContentNested<N> extends PodSecurityPolicyReviewFluent<PodSecurityPolicyReviewContentNested<N>> implements Nested<N>{
    PodSecurityPolicyReviewContentNested(PodSecurityPolicyReview item) {
      this.builder = new PodSecurityPolicyReviewBuilder(this, item);
    }
    PodSecurityPolicyReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodSecurityPolicyReviewContent() {
      return and();
    }
    
  
  }
  public class RecreateDeploymentStrategyParamsContentNested<N> extends RecreateDeploymentStrategyParamsFluent<RecreateDeploymentStrategyParamsContentNested<N>> implements Nested<N>{
    RecreateDeploymentStrategyParamsContentNested(RecreateDeploymentStrategyParams item) {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
    }
    RecreateDeploymentStrategyParamsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRecreateDeploymentStrategyParamsContent() {
      return and();
    }
    
  
  }
  public class DockerStrategyOptionsContentNested<N> extends DockerStrategyOptionsFluent<DockerStrategyOptionsContentNested<N>> implements Nested<N>{
    DockerStrategyOptionsContentNested(DockerStrategyOptions item) {
      this.builder = new DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDockerStrategyOptionsContent() {
      return and();
    }
    
  
  }
  public class ImageListContentNested<N> extends ImageListFluent<ImageListContentNested<N>> implements Nested<N>{
    ImageListContentNested(ImageList item) {
      this.builder = new ImageListBuilder(this, item);
    }
    ImageListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageListContent() {
      return and();
    }
    
  
  }
  public class ConfigMapBuildSourceContentNested<N> extends ConfigMapBuildSourceFluent<ConfigMapBuildSourceContentNested<N>> implements Nested<N>{
    ConfigMapBuildSourceContentNested(ConfigMapBuildSource item) {
      this.builder = new ConfigMapBuildSourceBuilder(this, item);
    }
    ConfigMapBuildSourceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endConfigMapBuildSourceContent() {
      return and();
    }
    
  
  }
  public class ImageTagListContentNested<N> extends ImageTagListFluent<ImageTagListContentNested<N>> implements Nested<N>{
    ImageTagListContentNested(ImageTagList item) {
      this.builder = new ImageTagListBuilder(this, item);
    }
    ImageTagListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageTagListContent() {
      return and();
    }
    
  
  }
  public class DeploymentConfigContentNested<N> extends DeploymentConfigFluent<DeploymentConfigContentNested<N>> implements Nested<N>{
    DeploymentConfigContentNested(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentConfigContent() {
      return and();
    }
    
  
  }
  public class OAuthAccessTokenContentNested<N> extends OAuthAccessTokenFluent<OAuthAccessTokenContentNested<N>> implements Nested<N>{
    OAuthAccessTokenContentNested(OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOAuthAccessTokenContent() {
      return and();
    }
    
  
  }
  public class RoleBindingContentNested<N> extends RoleBindingFluent<RoleBindingContentNested<N>> implements Nested<N>{
    RoleBindingContentNested(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRoleBindingContent() {
      return and();
    }
    
  
  }
  public class ImageContentNested<N> extends ImageFluent<ImageContentNested<N>> implements Nested<N>{
    ImageContentNested(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageContent() {
      return and();
    }
    
  
  }
  public class TLSConfigContentNested<N> extends TLSConfigFluent<TLSConfigContentNested<N>> implements Nested<N>{
    TLSConfigContentNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTLSConfigContent() {
      return and();
    }
    
  
  }
  public class BuildVolumeContentNested<N> extends BuildVolumeFluent<BuildVolumeContentNested<N>> implements Nested<N>{
    BuildVolumeContentNested(BuildVolume item) {
      this.builder = new BuildVolumeBuilder(this, item);
    }
    BuildVolumeBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildVolumeContent() {
      return and();
    }
    
  
  }
  public class TemplateInstanceSpecContentNested<N> extends TemplateInstanceSpecFluent<TemplateInstanceSpecContentNested<N>> implements Nested<N>{
    TemplateInstanceSpecContentNested(TemplateInstanceSpec item) {
      this.builder = new TemplateInstanceSpecBuilder(this, item);
    }
    TemplateInstanceSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateInstanceSpecContent() {
      return and();
    }
    
  
  }
  public class BuildStatusContentNested<N> extends BuildStatusFluent<BuildStatusContentNested<N>> implements Nested<N>{
    BuildStatusContentNested(BuildStatus item) {
      this.builder = new BuildStatusBuilder(this, item);
    }
    BuildStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildStatusContent() {
      return and();
    }
    
  
  }
  public class ImageSourceContentNested<N> extends ImageSourceFluent<ImageSourceContentNested<N>> implements Nested<N>{
    ImageSourceContentNested(ImageSource item) {
      this.builder = new ImageSourceBuilder(this, item);
    }
    ImageSourceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageSourceContent() {
      return and();
    }
    
  
  }
  public class ObjectMetaContentNested<N> extends ObjectMetaFluent<ObjectMetaContentNested<N>> implements Nested<N>{
    ObjectMetaContentNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endObjectMetaContent() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimContentNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimContentNested<N>> implements Nested<N>{
    PersistentVolumeClaimContentNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPersistentVolumeClaimContent() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySelfSubjectReviewContentNested<N> extends PodSecurityPolicySelfSubjectReviewFluent<PodSecurityPolicySelfSubjectReviewContentNested<N>> implements Nested<N>{
    PodSecurityPolicySelfSubjectReviewContentNested(PodSecurityPolicySelfSubjectReview item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodSecurityPolicySelfSubjectReviewContent() {
      return and();
    }
    
  
  }
  public class TagReferenceContentNested<N> extends TagReferenceFluent<TagReferenceContentNested<N>> implements Nested<N>{
    TagReferenceContentNested(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagReferenceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTagReferenceContent() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicyRuleContentNested<N> extends EgressNetworkPolicyRuleFluent<EgressNetworkPolicyRuleContentNested<N>> implements Nested<N>{
    EgressNetworkPolicyRuleContentNested(EgressNetworkPolicyRule item) {
      this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
    }
    EgressNetworkPolicyRuleBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endEgressNetworkPolicyRuleContent() {
      return and();
    }
    
  
  }
  public class SubjectRulesReviewStatusContentNested<N> extends SubjectRulesReviewStatusFluent<SubjectRulesReviewStatusContentNested<N>> implements Nested<N>{
    SubjectRulesReviewStatusContentNested(SubjectRulesReviewStatus item) {
      this.builder = new SubjectRulesReviewStatusBuilder(this, item);
    }
    SubjectRulesReviewStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSubjectRulesReviewStatusContent() {
      return and();
    }
    
  
  }
  public class BuildVolumeMountContentNested<N> extends BuildVolumeMountFluent<BuildVolumeMountContentNested<N>> implements Nested<N>{
    BuildVolumeMountContentNested(BuildVolumeMount item) {
      this.builder = new BuildVolumeMountBuilder(this, item);
    }
    BuildVolumeMountBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildVolumeMountContent() {
      return and();
    }
    
  
  }
  public class ClusterNetworkEntryContentNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkEntryContentNested<N>> implements Nested<N>{
    ClusterNetworkEntryContentNested(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterNetworkEntryContent() {
      return and();
    }
    
  
  }
  public class GenericKubernetesResourceContentNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceContentNested<N>> implements Nested<N>{
    GenericKubernetesResourceContentNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGenericKubernetesResourceContent() {
      return and();
    }
    
  
  }
  public class TemplateInstanceObjectContentNested<N> extends TemplateInstanceObjectFluent<TemplateInstanceObjectContentNested<N>> implements Nested<N>{
    TemplateInstanceObjectContentNested(TemplateInstanceObject item) {
      this.builder = new TemplateInstanceObjectBuilder(this, item);
    }
    TemplateInstanceObjectBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateInstanceObjectContent() {
      return and();
    }
    
  
  }
  public class BuildSourceContentNested<N> extends BuildSourceFluent<BuildSourceContentNested<N>> implements Nested<N>{
    BuildSourceContentNested(BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    BuildSourceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildSourceContent() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaStatusContentNested<N> extends ClusterResourceQuotaStatusFluent<ClusterResourceQuotaStatusContentNested<N>> implements Nested<N>{
    ClusterResourceQuotaStatusContentNested(ClusterResourceQuotaStatus item) {
      this.builder = new ClusterResourceQuotaStatusBuilder(this, item);
    }
    ClusterResourceQuotaStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterResourceQuotaStatusContent() {
      return and();
    }
    
  
  }
  public class DeploymentConditionContentNested<N> extends DeploymentConditionFluent<DeploymentConditionContentNested<N>> implements Nested<N>{
    DeploymentConditionContentNested(DeploymentCondition item) {
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    DeploymentConditionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentConditionContent() {
      return and();
    }
    
  
  }
  public class HelmChartRepositorySpecContentNested<N> extends HelmChartRepositorySpecFluent<HelmChartRepositorySpecContentNested<N>> implements Nested<N>{
    HelmChartRepositorySpecContentNested(HelmChartRepositorySpec item) {
      this.builder = new HelmChartRepositorySpecBuilder(this, item);
    }
    HelmChartRepositorySpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endHelmChartRepositorySpecContent() {
      return and();
    }
    
  
  }
  public class DeploymentCauseImageTriggerContentNested<N> extends DeploymentCauseImageTriggerFluent<DeploymentCauseImageTriggerContentNested<N>> implements Nested<N>{
    DeploymentCauseImageTriggerContentNested(DeploymentCauseImageTrigger item) {
      this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
    }
    DeploymentCauseImageTriggerBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentCauseImageTriggerContent() {
      return and();
    }
    
  
  }
  public class ImageStreamMappingContentNested<N> extends ImageStreamMappingFluent<ImageStreamMappingContentNested<N>> implements Nested<N>{
    ImageStreamMappingContentNested(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamMappingContent() {
      return and();
    }
    
  
  }
  public class SubjectRulesReviewContentNested<N> extends SubjectRulesReviewFluent<SubjectRulesReviewContentNested<N>> implements Nested<N>{
    SubjectRulesReviewContentNested(SubjectRulesReview item) {
      this.builder = new SubjectRulesReviewBuilder(this, item);
    }
    SubjectRulesReviewBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSubjectRulesReviewContent() {
      return and();
    }
    
  
  }
  public class RoleContentNested<N> extends RoleFluent<RoleContentNested<N>> implements Nested<N>{
    RoleContentNested(Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRoleContent() {
      return and();
    }
    
  
  }
  public class GitBuildSourceContentNested<N> extends GitBuildSourceFluent<GitBuildSourceContentNested<N>> implements Nested<N>{
    GitBuildSourceContentNested(GitBuildSource item) {
      this.builder = new GitBuildSourceBuilder(this, item);
    }
    GitBuildSourceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGitBuildSourceContent() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicyListContentNested<N> extends EgressNetworkPolicyListFluent<EgressNetworkPolicyListContentNested<N>> implements Nested<N>{
    EgressNetworkPolicyListContentNested(EgressNetworkPolicyList item) {
      this.builder = new EgressNetworkPolicyListBuilder(this, item);
    }
    EgressNetworkPolicyListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endEgressNetworkPolicyListContent() {
      return and();
    }
    
  
  }
  public class SelfSubjectRulesReviewSpecContentNested<N> extends SelfSubjectRulesReviewSpecFluent<SelfSubjectRulesReviewSpecContentNested<N>> implements Nested<N>{
    SelfSubjectRulesReviewSpecContentNested(SelfSubjectRulesReviewSpec item) {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
    }
    SelfSubjectRulesReviewSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSelfSubjectRulesReviewSpecContent() {
      return and();
    }
    
  
  }
  public class ImageSourcePathContentNested<N> extends ImageSourcePathFluent<ImageSourcePathContentNested<N>> implements Nested<N>{
    ImageSourcePathContentNested(ImageSourcePath item) {
      this.builder = new ImageSourcePathBuilder(this, item);
    }
    ImageSourcePathBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageSourcePathContent() {
      return and();
    }
    
  
  }
  public class BuildConfigStatusContentNested<N> extends BuildConfigStatusFluent<BuildConfigStatusContentNested<N>> implements Nested<N>{
    BuildConfigStatusContentNested(BuildConfigStatus item) {
      this.builder = new BuildConfigStatusBuilder(this, item);
    }
    BuildConfigStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildConfigStatusContent() {
      return and();
    }
    
  
  }
  public class ResourceQuotaStatusByNamespaceContentNested<N> extends ResourceQuotaStatusByNamespaceFluent<ResourceQuotaStatusByNamespaceContentNested<N>> implements Nested<N>{
    ResourceQuotaStatusByNamespaceContentNested(ResourceQuotaStatusByNamespace item) {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this, item);
    }
    ResourceQuotaStatusByNamespaceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endResourceQuotaStatusByNamespaceContent() {
      return and();
    }
    
  
  }
  public class ParameterContentNested<N> extends ParameterFluent<ParameterContentNested<N>> implements Nested<N>{
    ParameterContentNested(Parameter item) {
      this.builder = new ParameterBuilder(this, item);
    }
    ParameterBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endParameterContent() {
      return and();
    }
    
  
  }
  public class RoleBindingListContentNested<N> extends RoleBindingListFluent<RoleBindingListContentNested<N>> implements Nested<N>{
    RoleBindingListContentNested(RoleBindingList item) {
      this.builder = new RoleBindingListBuilder(this, item);
    }
    RoleBindingListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRoleBindingListContent() {
      return and();
    }
    
  
  }
  public class SourceBuildStrategyContentNested<N> extends SourceBuildStrategyFluent<SourceBuildStrategyContentNested<N>> implements Nested<N>{
    SourceBuildStrategyContentNested(SourceBuildStrategy item) {
      this.builder = new SourceBuildStrategyBuilder(this, item);
    }
    SourceBuildStrategyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSourceBuildStrategyContent() {
      return and();
    }
    
  
  }
  public class BrokerTemplateInstanceContentNested<N> extends BrokerTemplateInstanceFluent<BrokerTemplateInstanceContentNested<N>> implements Nested<N>{
    BrokerTemplateInstanceContentNested(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBrokerTemplateInstanceContent() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySelfSubjectReviewSpecContentNested<N> extends PodSecurityPolicySelfSubjectReviewSpecFluent<PodSecurityPolicySelfSubjectReviewSpecContentNested<N>> implements Nested<N>{
    PodSecurityPolicySelfSubjectReviewSpecContentNested(PodSecurityPolicySelfSubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodSecurityPolicySelfSubjectReviewSpecContent() {
      return and();
    }
    
  
  }
  public class BuildPostCommitSpecContentNested<N> extends BuildPostCommitSpecFluent<BuildPostCommitSpecContentNested<N>> implements Nested<N>{
    BuildPostCommitSpecContentNested(BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    BuildPostCommitSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildPostCommitSpecContent() {
      return and();
    }
    
  
  }
  public class DeploymentStrategyContentNested<N> extends DeploymentStrategyFluent<DeploymentStrategyContentNested<N>> implements Nested<N>{
    DeploymentStrategyContentNested(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentStrategyContent() {
      return and();
    }
    
  
  }
  public class OAuthAuthorizeTokenListContentNested<N> extends OAuthAuthorizeTokenListFluent<OAuthAuthorizeTokenListContentNested<N>> implements Nested<N>{
    OAuthAuthorizeTokenListContentNested(OAuthAuthorizeTokenList item) {
      this.builder = new OAuthAuthorizeTokenListBuilder(this, item);
    }
    OAuthAuthorizeTokenListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOAuthAuthorizeTokenListContent() {
      return and();
    }
    
  
  }
  public class SignatureSubjectContentNested<N> extends SignatureSubjectFluent<SignatureSubjectContentNested<N>> implements Nested<N>{
    SignatureSubjectContentNested(SignatureSubject item) {
      this.builder = new SignatureSubjectBuilder(this, item);
    }
    SignatureSubjectBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSignatureSubjectContent() {
      return and();
    }
    
  
  }
  public class HostSubnetListContentNested<N> extends HostSubnetListFluent<HostSubnetListContentNested<N>> implements Nested<N>{
    HostSubnetListContentNested(HostSubnetList item) {
      this.builder = new HostSubnetListBuilder(this, item);
    }
    HostSubnetListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endHostSubnetListContent() {
      return and();
    }
    
  
  }
  public class RouteIngressConditionContentNested<N> extends RouteIngressConditionFluent<RouteIngressConditionContentNested<N>> implements Nested<N>{
    RouteIngressConditionContentNested(RouteIngressCondition item) {
      this.builder = new RouteIngressConditionBuilder(this, item);
    }
    RouteIngressConditionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRouteIngressConditionContent() {
      return and();
    }
    
  
  }
  public class CustomDeploymentStrategyParamsContentNested<N> extends CustomDeploymentStrategyParamsFluent<CustomDeploymentStrategyParamsContentNested<N>> implements Nested<N>{
    CustomDeploymentStrategyParamsContentNested(CustomDeploymentStrategyParams item) {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
    }
    CustomDeploymentStrategyParamsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endCustomDeploymentStrategyParamsContent() {
      return and();
    }
    
  
  }
  public class ImageImportSpecContentNested<N> extends ImageImportSpecFluent<ImageImportSpecContentNested<N>> implements Nested<N>{
    ImageImportSpecContentNested(ImageImportSpec item) {
      this.builder = new ImageImportSpecBuilder(this, item);
    }
    ImageImportSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageImportSpecContent() {
      return and();
    }
    
  
  }
  public class StageInfoContentNested<N> extends StageInfoFluent<StageInfoContentNested<N>> implements Nested<N>{
    StageInfoContentNested(StageInfo item) {
      this.builder = new StageInfoBuilder(this, item);
    }
    StageInfoBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endStageInfoContent() {
      return and();
    }
    
  
  }
  public class RoleBindingRestrictionSpecContentNested<N> extends RoleBindingRestrictionSpecFluent<RoleBindingRestrictionSpecContentNested<N>> implements Nested<N>{
    RoleBindingRestrictionSpecContentNested(RoleBindingRestrictionSpec item) {
      this.builder = new RoleBindingRestrictionSpecBuilder(this, item);
    }
    RoleBindingRestrictionSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRoleBindingRestrictionSpecContent() {
      return and();
    }
    
  
  }
  public class IDRangeContentNested<N> extends IDRangeFluent<IDRangeContentNested<N>> implements Nested<N>{
    IDRangeContentNested(IDRange item) {
      this.builder = new IDRangeBuilder(this, item);
    }
    IDRangeBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endIDRangeContent() {
      return and();
    }
    
  
  }
  public class UserListContentNested<N> extends UserListFluent<UserListContentNested<N>> implements Nested<N>{
    UserListContentNested(UserList item) {
      this.builder = new UserListBuilder(this, item);
    }
    UserListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endUserListContent() {
      return and();
    }
    
  
  }
  public class BuildConfigSpecContentNested<N> extends BuildConfigSpecFluent<BuildConfigSpecContentNested<N>> implements Nested<N>{
    BuildConfigSpecContentNested(BuildConfigSpec item) {
      this.builder = new BuildConfigSpecBuilder(this, item);
    }
    BuildConfigSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildConfigSpecContent() {
      return and();
    }
    
  
  }
  public class UserContentNested<N> extends UserFluent<UserContentNested<N>> implements Nested<N>{
    UserContentNested(User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endUserContent() {
      return and();
    }
    
  
  }
  public class ImageStreamImageContentNested<N> extends ImageStreamImageFluent<ImageStreamImageContentNested<N>> implements Nested<N>{
    ImageStreamImageContentNested(ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamImageContent() {
      return and();
    }
    
  
  }
  public class BuildConditionContentNested<N> extends BuildConditionFluent<BuildConditionContentNested<N>> implements Nested<N>{
    BuildConditionContentNested(BuildCondition item) {
      this.builder = new BuildConditionBuilder(this, item);
    }
    BuildConditionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildConditionContent() {
      return and();
    }
    
  
  }
  public class BuildStatusOutputToContentNested<N> extends BuildStatusOutputToFluent<BuildStatusOutputToContentNested<N>> implements Nested<N>{
    BuildStatusOutputToContentNested(BuildStatusOutputTo item) {
      this.builder = new BuildStatusOutputToBuilder(this, item);
    }
    BuildStatusOutputToBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildStatusOutputToContent() {
      return and();
    }
    
  
  }
  public class ResourceAccessReviewResponseContentNested<N> extends ResourceAccessReviewResponseFluent<ResourceAccessReviewResponseContentNested<N>> implements Nested<N>{
    ResourceAccessReviewResponseContentNested(ResourceAccessReviewResponse item) {
      this.builder = new ResourceAccessReviewResponseBuilder(this, item);
    }
    ResourceAccessReviewResponseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endResourceAccessReviewResponseContent() {
      return and();
    }
    
  
  }
  public class ExecNewPodHookContentNested<N> extends ExecNewPodHookFluent<ExecNewPodHookContentNested<N>> implements Nested<N>{
    ExecNewPodHookContentNested(ExecNewPodHook item) {
      this.builder = new ExecNewPodHookBuilder(this, item);
    }
    ExecNewPodHookBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endExecNewPodHookContent() {
      return and();
    }
    
  
  }
  public class SecretSpecContentNested<N> extends SecretSpecFluent<SecretSpecContentNested<N>> implements Nested<N>{
    SecretSpecContentNested(SecretSpec item) {
      this.builder = new SecretSpecBuilder(this, item);
    }
    SecretSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSecretSpecContent() {
      return and();
    }
    
  
  }
  public class ClusterRoleBindingListContentNested<N> extends ClusterRoleBindingListFluent<ClusterRoleBindingListContentNested<N>> implements Nested<N>{
    ClusterRoleBindingListContentNested(ClusterRoleBindingList item) {
      this.builder = new ClusterRoleBindingListBuilder(this, item);
    }
    ClusterRoleBindingListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterRoleBindingListContent() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicyPeerContentNested<N> extends EgressNetworkPolicyPeerFluent<EgressNetworkPolicyPeerContentNested<N>> implements Nested<N>{
    EgressNetworkPolicyPeerContentNested(EgressNetworkPolicyPeer item) {
      this.builder = new EgressNetworkPolicyPeerBuilder(this, item);
    }
    EgressNetworkPolicyPeerBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endEgressNetworkPolicyPeerContent() {
      return and();
    }
    
  
  }
  public class ProjectHelmChartRepositoryListContentNested<N> extends ProjectHelmChartRepositoryListFluent<ProjectHelmChartRepositoryListContentNested<N>> implements Nested<N>{
    ProjectHelmChartRepositoryListContentNested(ProjectHelmChartRepositoryList item) {
      this.builder = new ProjectHelmChartRepositoryListBuilder(this, item);
    }
    ProjectHelmChartRepositoryListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endProjectHelmChartRepositoryListContent() {
      return and();
    }
    
  
  }
  public class TemplateInstanceContentNested<N> extends TemplateInstanceFluent<TemplateInstanceContentNested<N>> implements Nested<N>{
    TemplateInstanceContentNested(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateInstanceContent() {
      return and();
    }
    
  
  }
  public class WebHookTriggerContentNested<N> extends WebHookTriggerFluent<WebHookTriggerContentNested<N>> implements Nested<N>{
    WebHookTriggerContentNested(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endWebHookTriggerContent() {
      return and();
    }
    
  
  }
  public class BuildContentNested<N> extends BuildFluent<BuildContentNested<N>> implements Nested<N>{
    BuildContentNested(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildContent() {
      return and();
    }
    
  
  }
  public class ServiceAccountReferenceContentNested<N> extends ServiceAccountReferenceFluent<ServiceAccountReferenceContentNested<N>> implements Nested<N>{
    ServiceAccountReferenceContentNested(ServiceAccountReference item) {
      this.builder = new ServiceAccountReferenceBuilder(this, item);
    }
    ServiceAccountReferenceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endServiceAccountReferenceContent() {
      return and();
    }
    
  
  }
  public class RoleBindingRestrictionContentNested<N> extends RoleBindingRestrictionFluent<RoleBindingRestrictionContentNested<N>> implements Nested<N>{
    RoleBindingRestrictionContentNested(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRoleBindingRestrictionContent() {
      return and();
    }
    
  
  }
  public class TagImportPolicyContentNested<N> extends TagImportPolicyFluent<TagImportPolicyContentNested<N>> implements Nested<N>{
    TagImportPolicyContentNested(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    TagImportPolicyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTagImportPolicyContent() {
      return and();
    }
    
  
  }
  public class ImageStreamTagContentNested<N> extends ImageStreamTagFluent<ImageStreamTagContentNested<N>> implements Nested<N>{
    ImageStreamTagContentNested(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamTagContent() {
      return and();
    }
    
  
  }
  public class BuildTriggerPolicyContentNested<N> extends BuildTriggerPolicyFluent<BuildTriggerPolicyContentNested<N>> implements Nested<N>{
    BuildTriggerPolicyContentNested(BuildTriggerPolicy item) {
      this.builder = new BuildTriggerPolicyBuilder(this, item);
    }
    BuildTriggerPolicyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildTriggerPolicyContent() {
      return and();
    }
    
  
  }
  public class RoutePortContentNested<N> extends RoutePortFluent<RoutePortContentNested<N>> implements Nested<N>{
    RoutePortContentNested(RoutePort item) {
      this.builder = new RoutePortBuilder(this, item);
    }
    RoutePortBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRoutePortContent() {
      return and();
    }
    
  
  }
  public class TemplateInstanceRequesterContentNested<N> extends TemplateInstanceRequesterFluent<TemplateInstanceRequesterContentNested<N>> implements Nested<N>{
    TemplateInstanceRequesterContentNested(TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    TemplateInstanceRequesterBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateInstanceRequesterContent() {
      return and();
    }
    
  
  }
  public class GroupContentNested<N> extends GroupFluent<GroupContentNested<N>> implements Nested<N>{
    GroupContentNested(Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGroupContent() {
      return and();
    }
    
  
  }
  public class BuildTriggerCauseContentNested<N> extends BuildTriggerCauseFluent<BuildTriggerCauseContentNested<N>> implements Nested<N>{
    BuildTriggerCauseContentNested(BuildTriggerCause item) {
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    BuildTriggerCauseBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildTriggerCauseContent() {
      return and();
    }
    
  
  }
  public class ImageSignatureContentNested<N> extends ImageSignatureFluent<ImageSignatureContentNested<N>> implements Nested<N>{
    ImageSignatureContentNested(ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageSignatureContent() {
      return and();
    }
    
  
  }
  public class HelmChartRepositoryStatusContentNested<N> extends HelmChartRepositoryStatusFluent<HelmChartRepositoryStatusContentNested<N>> implements Nested<N>{
    HelmChartRepositoryStatusContentNested(HelmChartRepositoryStatus item) {
      this.builder = new HelmChartRepositoryStatusBuilder(this, item);
    }
    HelmChartRepositoryStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endHelmChartRepositoryStatusContent() {
      return and();
    }
    
  
  }
  public class DeploymentConfigSpecContentNested<N> extends DeploymentConfigSpecFluent<DeploymentConfigSpecContentNested<N>> implements Nested<N>{
    DeploymentConfigSpecContentNested(DeploymentConfigSpec item) {
      this.builder = new DeploymentConfigSpecBuilder(this, item);
    }
    DeploymentConfigSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentConfigSpecContent() {
      return and();
    }
    
  
  }
  public class HostSubnetContentNested<N> extends HostSubnetFluent<HostSubnetContentNested<N>> implements Nested<N>{
    HostSubnetContentNested(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endHostSubnetContent() {
      return and();
    }
    
  
  }
  public class AppliedClusterResourceQuotaContentNested<N> extends AppliedClusterResourceQuotaFluent<AppliedClusterResourceQuotaContentNested<N>> implements Nested<N>{
    AppliedClusterResourceQuotaContentNested(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endAppliedClusterResourceQuotaContent() {
      return and();
    }
    
  
  }
  public class GroupRestrictionContentNested<N> extends GroupRestrictionFluent<GroupRestrictionContentNested<N>> implements Nested<N>{
    GroupRestrictionContentNested(GroupRestriction item) {
      this.builder = new GroupRestrictionBuilder(this, item);
    }
    GroupRestrictionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endGroupRestrictionContent() {
      return and();
    }
    
  
  }
  public class OAuthAccessTokenListContentNested<N> extends OAuthAccessTokenListFluent<OAuthAccessTokenListContentNested<N>> implements Nested<N>{
    OAuthAccessTokenListContentNested(OAuthAccessTokenList item) {
      this.builder = new OAuthAccessTokenListBuilder(this, item);
    }
    OAuthAccessTokenListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOAuthAccessTokenListContent() {
      return and();
    }
    
  
  }
  public class JenkinsPipelineBuildStrategyContentNested<N> extends JenkinsPipelineBuildStrategyFluent<JenkinsPipelineBuildStrategyContentNested<N>> implements Nested<N>{
    JenkinsPipelineBuildStrategyContentNested(JenkinsPipelineBuildStrategy item) {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
    }
    JenkinsPipelineBuildStrategyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endJenkinsPipelineBuildStrategyContent() {
      return and();
    }
    
  
  }
  public class SecurityContextConstraintsContentNested<N> extends SecurityContextConstraintsFluent<SecurityContextConstraintsContentNested<N>> implements Nested<N>{
    SecurityContextConstraintsContentNested(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSecurityContextConstraintsContent() {
      return and();
    }
    
  
  }
  public class SupplementalGroupsStrategyOptionsContentNested<N> extends SupplementalGroupsStrategyOptionsFluent<SupplementalGroupsStrategyOptionsContentNested<N>> implements Nested<N>{
    SupplementalGroupsStrategyOptionsContentNested(SupplementalGroupsStrategyOptions item) {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSupplementalGroupsStrategyOptionsContent() {
      return and();
    }
    
  
  }
  public class ServiceAccountPodSecurityPolicyReviewStatusContentNested<N> extends ServiceAccountPodSecurityPolicyReviewStatusFluent<ServiceAccountPodSecurityPolicyReviewStatusContentNested<N>> implements Nested<N>{
    ServiceAccountPodSecurityPolicyReviewStatusContentNested(ServiceAccountPodSecurityPolicyReviewStatus item) {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
    }
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endServiceAccountPodSecurityPolicyReviewStatusContent() {
      return and();
    }
    
  
  }
  public class BuildRequestContentNested<N> extends BuildRequestFluent<BuildRequestContentNested<N>> implements Nested<N>{
    BuildRequestContentNested(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildRequestContent() {
      return and();
    }
    
  
  }
  public class SELinuxContextStrategyOptionsContentNested<N> extends SELinuxContextStrategyOptionsFluent<SELinuxContextStrategyOptionsContentNested<N>> implements Nested<N>{
    SELinuxContextStrategyOptionsContentNested(SELinuxContextStrategyOptions item) {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
    }
    SELinuxContextStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSELinuxContextStrategyOptionsContent() {
      return and();
    }
    
  
  }
  public class ClusterRoleListContentNested<N> extends ClusterRoleListFluent<ClusterRoleListContentNested<N>> implements Nested<N>{
    ClusterRoleListContentNested(ClusterRoleList item) {
      this.builder = new ClusterRoleListBuilder(this, item);
    }
    ClusterRoleListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterRoleListContent() {
      return and();
    }
    
  
  }
  public class RouteListContentNested<N> extends RouteListFluent<RouteListContentNested<N>> implements Nested<N>{
    RouteListContentNested(RouteList item) {
      this.builder = new RouteListBuilder(this, item);
    }
    RouteListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRouteListContent() {
      return and();
    }
    
  
  }
  public class ImageStreamStatusContentNested<N> extends ImageStreamStatusFluent<ImageStreamStatusContentNested<N>> implements Nested<N>{
    ImageStreamStatusContentNested(ImageStreamStatus item) {
      this.builder = new ImageStreamStatusBuilder(this, item);
    }
    ImageStreamStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamStatusContent() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicyContentNested<N> extends EgressNetworkPolicyFluent<EgressNetworkPolicyContentNested<N>> implements Nested<N>{
    EgressNetworkPolicyContentNested(EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endEgressNetworkPolicyContent() {
      return and();
    }
    
  
  }
  public class NetNamespaceContentNested<N> extends NetNamespaceFluent<NetNamespaceContentNested<N>> implements Nested<N>{
    NetNamespaceContentNested(NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endNetNamespaceContent() {
      return and();
    }
    
  
  }
  public class DeploymentDetailsContentNested<N> extends DeploymentDetailsFluent<DeploymentDetailsContentNested<N>> implements Nested<N>{
    DeploymentDetailsContentNested(DeploymentDetails item) {
      this.builder = new DeploymentDetailsBuilder(this, item);
    }
    DeploymentDetailsBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endDeploymentDetailsContent() {
      return and();
    }
    
  
  }
  public class UserIdentityMappingContentNested<N> extends UserIdentityMappingFluent<UserIdentityMappingContentNested<N>> implements Nested<N>{
    UserIdentityMappingContentNested(UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endUserIdentityMappingContent() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySubjectReviewStatusContentNested<N> extends PodSecurityPolicySubjectReviewStatusFluent<PodSecurityPolicySubjectReviewStatusContentNested<N>> implements Nested<N>{
    PodSecurityPolicySubjectReviewStatusContentNested(PodSecurityPolicySubjectReviewStatus item) {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewStatusBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodSecurityPolicySubjectReviewStatusContent() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySubjectReviewSpecContentNested<N> extends PodSecurityPolicySubjectReviewSpecFluent<PodSecurityPolicySubjectReviewSpecContentNested<N>> implements Nested<N>{
    PodSecurityPolicySubjectReviewSpecContentNested(PodSecurityPolicySubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endPodSecurityPolicySubjectReviewSpecContent() {
      return and();
    }
    
  
  }
  public class ImageStreamContentNested<N> extends ImageStreamFluent<ImageStreamContentNested<N>> implements Nested<N>{
    ImageStreamContentNested(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamContent() {
      return and();
    }
    
  
  }
  public class BuildListContentNested<N> extends BuildListFluent<BuildListContentNested<N>> implements Nested<N>{
    BuildListContentNested(BuildList item) {
      this.builder = new BuildListBuilder(this, item);
    }
    BuildListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildListContent() {
      return and();
    }
    
  
  }
  public class BuildOutputContentNested<N> extends BuildOutputFluent<BuildOutputContentNested<N>> implements Nested<N>{
    BuildOutputContentNested(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    BuildOutputBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endBuildOutputContent() {
      return and();
    }
    
  
  }
  public class TemplateListContentNested<N> extends TemplateListFluent<TemplateListContentNested<N>> implements Nested<N>{
    TemplateListContentNested(TemplateList item) {
      this.builder = new TemplateListBuilder(this, item);
    }
    TemplateListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endTemplateListContent() {
      return and();
    }
    
  
  }
  public class ProjectSpecContentNested<N> extends ProjectSpecFluent<ProjectSpecContentNested<N>> implements Nested<N>{
    ProjectSpecContentNested(ProjectSpec item) {
      this.builder = new ProjectSpecBuilder(this, item);
    }
    ProjectSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endProjectSpecContent() {
      return and();
    }
    
  
  }
  public class SourceRevisionContentNested<N> extends SourceRevisionFluent<SourceRevisionContentNested<N>> implements Nested<N>{
    SourceRevisionContentNested(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    SourceRevisionBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSourceRevisionContent() {
      return and();
    }
    
  
  }
  public class ObjectReferenceContentNested<N> extends ObjectReferenceFluent<ObjectReferenceContentNested<N>> implements Nested<N>{
    ObjectReferenceContentNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endObjectReferenceContent() {
      return and();
    }
    
  
  }
  public class SignatureIssuerContentNested<N> extends SignatureIssuerFluent<SignatureIssuerContentNested<N>> implements Nested<N>{
    SignatureIssuerContentNested(SignatureIssuer item) {
      this.builder = new SignatureIssuerBuilder(this, item);
    }
    SignatureIssuerBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endSignatureIssuerContent() {
      return and();
    }
    
  
  }
  public class ImageLayerContentNested<N> extends ImageLayerFluent<ImageLayerContentNested<N>> implements Nested<N>{
    ImageLayerContentNested(ImageLayer item) {
      this.builder = new ImageLayerBuilder(this, item);
    }
    ImageLayerBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageLayerContent() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaSpecContentNested<N> extends ClusterResourceQuotaSpecFluent<ClusterResourceQuotaSpecContentNested<N>> implements Nested<N>{
    ClusterResourceQuotaSpecContentNested(ClusterResourceQuotaSpec item) {
      this.builder = new ClusterResourceQuotaSpecBuilder(this, item);
    }
    ClusterResourceQuotaSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endClusterResourceQuotaSpecContent() {
      return and();
    }
    
  
  }
  public class ImageStreamSpecContentNested<N> extends ImageStreamSpecFluent<ImageStreamSpecContentNested<N>> implements Nested<N>{
    ImageStreamSpecContentNested(ImageStreamSpec item) {
      this.builder = new ImageStreamSpecBuilder(this, item);
    }
    ImageStreamSpecBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endImageStreamSpecContent() {
      return and();
    }
    
  
  }
  public class RouteIngressContentNested<N> extends RouteIngressFluent<RouteIngressContentNested<N>> implements Nested<N>{
    RouteIngressContentNested(RouteIngress item) {
      this.builder = new RouteIngressBuilder(this, item);
    }
    RouteIngressBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRouteIngressContent() {
      return and();
    }
    
  
  }
  public class OAuthClientContentNested<N> extends OAuthClientFluent<OAuthClientContentNested<N>> implements Nested<N>{
    OAuthClientContentNested(OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endOAuthClientContent() {
      return and();
    }
    
  
  }
  public class IdentityContentNested<N> extends IdentityFluent<IdentityContentNested<N>> implements Nested<N>{
    IdentityContentNested(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endIdentityContent() {
      return and();
    }
    
  
  }
  public class RangeAllocationListContentNested<N> extends RangeAllocationListFluent<RangeAllocationListContentNested<N>> implements Nested<N>{
    RangeAllocationListContentNested(RangeAllocationList item) {
      this.builder = new RangeAllocationListBuilder(this, item);
    }
    RangeAllocationListBuilder builder;
    
    public N and() {
      return (N) SubjectAccessReviewFluent.this.withContent(builder.build());
    }
    
    public N endRangeAllocationListContent() {
      return and();
    }
    
  
  }

}