package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OAuthClientListBuilder extends OAuthClientListFluent<OAuthClientListBuilder> implements VisitableBuilder<OAuthClientList,OAuthClientListBuilder>{
  public OAuthClientListBuilder() {
    this(new OAuthClientList());
  }
  
  public OAuthClientListBuilder(OAuthClientListFluent<?> fluent) {
    this(fluent, new OAuthClientList());
  }
  
  public OAuthClientListBuilder(OAuthClientListFluent<?> fluent,OAuthClientList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OAuthClientListBuilder(OAuthClientList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OAuthClientListFluent<?> fluent;
  
  public OAuthClientList build() {
    OAuthClientList buildable = new OAuthClientList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}