package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeploymentConfigBuilder extends DeploymentConfigFluent<DeploymentConfigBuilder> implements VisitableBuilder<DeploymentConfig,DeploymentConfigBuilder>{
  public DeploymentConfigBuilder() {
    this(new DeploymentConfig());
  }
  
  public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent) {
    this(fluent, new DeploymentConfig());
  }
  
  public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent,DeploymentConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeploymentConfigBuilder(DeploymentConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeploymentConfigFluent<?> fluent;
  
  public DeploymentConfig build() {
    DeploymentConfig buildable = new DeploymentConfig(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}