package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class SecretSpecBuilder extends io.fabric8.openshift.api.model.SecretSpecFluentImpl<io.fabric8.openshift.api.model.SecretSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.SecretSpec,io.fabric8.openshift.api.model.SecretSpecBuilder>{
  public SecretSpecBuilder() {
    this(false);
  }
  public SecretSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new SecretSpec(), validationEnabled);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretSpec(), validationEnabled);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent,io.fabric8.openshift.api.model.SecretSpec instance) {
    this(fluent, instance, false);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent,io.fabric8.openshift.api.model.SecretSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMountPath(instance.getMountPath()); 
    fluent.withSecretSource(instance.getSecretSource()); 
    this.validationEnabled = validationEnabled; 
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpec instance) {
    this(instance,false);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMountPath(instance.getMountPath()); 
    this.withSecretSource(instance.getSecretSource()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SecretSpec build() {
    SecretSpec buildable = new SecretSpec(fluent.getMountPath(),fluent.getSecretSource());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretSpecBuilder that = (SecretSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}