package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ImageStreamStatusBuilder extends io.fabric8.openshift.api.model.ImageStreamStatusFluentImpl<io.fabric8.openshift.api.model.ImageStreamStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamStatus,io.fabric8.openshift.api.model.ImageStreamStatusBuilder>{
  public ImageStreamStatusBuilder() {
    this(false);
  }
  public ImageStreamStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new ImageStreamStatus(), validationEnabled);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamStatus(), validationEnabled);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamStatus instance) {
    this(fluent, instance, false);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDockerImageRepository(instance.getDockerImageRepository()); 
    fluent.withPublicDockerImageRepository(instance.getPublicDockerImageRepository()); 
    fluent.withTags(instance.getTags()); 
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatus instance) {
    this(instance,false);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDockerImageRepository(instance.getDockerImageRepository()); 
    this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository()); 
    this.withTags(instance.getTags()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamStatus build() {
    ImageStreamStatus buildable = new ImageStreamStatus(fluent.getDockerImageRepository(),fluent.getPublicDockerImageRepository(),fluent.getTags());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamStatusBuilder that = (ImageStreamStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}