package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class DeploymentConfigStatusFluentImpl<A extends io.fabric8.openshift.api.model.DeploymentConfigStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.DeploymentConfigStatusFluent<A>{
  public DeploymentConfigStatusFluentImpl() {
  }
  public DeploymentConfigStatusFluentImpl(io.fabric8.openshift.api.model.DeploymentConfigStatus instance) {
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withDetails(instance.getDetails()); 
    this.withLatestVersion(instance.getLatestVersion()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
  }
  private java.lang.Integer availableReplicas;
  private java.util.List<io.fabric8.openshift.api.model.DeploymentConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();
  private io.fabric8.openshift.api.model.DeploymentDetailsBuilder details;
  private java.lang.Long latestVersion;
  private java.lang.Long observedGeneration;
  private java.lang.Integer readyReplicas;
  private java.lang.Integer replicas;
  private java.lang.Integer unavailableReplicas;
  private java.lang.Integer updatedReplicas;
  public java.lang.Integer getAvailableReplicas() {
    return this.availableReplicas;
  }
  public A withAvailableReplicas(java.lang.Integer availableReplicas) {
    this.availableReplicas=availableReplicas; return (A) this;
  }
  public java.lang.Boolean hasAvailableReplicas() {
    return this.availableReplicas != null;
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.DeploymentCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();}
    io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.DeploymentCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();}
    io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.DeploymentCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();}
    for (io.fabric8.openshift.api.model.DeploymentCondition item : items) {io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.openshift.api.model.DeploymentCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>();}
    for (io.fabric8.openshift.api.model.DeploymentCondition item : items) {io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.DeploymentCondition... items) {
    for (io.fabric8.openshift.api.model.DeploymentCondition item : items) {io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.DeploymentCondition> items) {
    for (io.fabric8.openshift.api.model.DeploymentCondition item : items) {io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.openshift.api.model.DeploymentConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.DeploymentConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.DeploymentConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.DeploymentCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.openshift.api.model.DeploymentCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.openshift.api.model.DeploymentCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.DeploymentCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.DeploymentCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.DeploymentCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.DeploymentConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.DeploymentConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.DeploymentConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.DeploymentConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.DeploymentCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.DeploymentConditionBuilder>(); for (io.fabric8.openshift.api.model.DeploymentCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.DeploymentCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.DeploymentCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.DeploymentCondition item) {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.DeploymentCondition item) {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.DeploymentConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDetails instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.DeploymentDetails getDetails() {
    return this.details!=null?this.details.build():null;
  }
  public io.fabric8.openshift.api.model.DeploymentDetails buildDetails() {
    return this.details!=null?this.details.build():null;
  }
  public A withDetails(io.fabric8.openshift.api.model.DeploymentDetails details) {
    _visitables.get("details").remove(this.details);
    if (details!=null){ this.details= new io.fabric8.openshift.api.model.DeploymentDetailsBuilder(details); _visitables.get("details").add(this.details);} return (A) this;
  }
  public java.lang.Boolean hasDetails() {
    return this.details != null;
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails() {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl.DetailsNestedImpl();
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(io.fabric8.openshift.api.model.DeploymentDetails item) {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl.DetailsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> editDetails() {
    return withNewDetailsLike(getDetails());
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetails() {
    return withNewDetailsLike(getDetails() != null ? getDetails(): new io.fabric8.openshift.api.model.DeploymentDetailsBuilder().build());
  }
  public io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetailsLike(io.fabric8.openshift.api.model.DeploymentDetails item) {
    return withNewDetailsLike(getDetails() != null ? getDetails(): item);
  }
  public java.lang.Long getLatestVersion() {
    return this.latestVersion;
  }
  public A withLatestVersion(java.lang.Long latestVersion) {
    this.latestVersion=latestVersion; return (A) this;
  }
  public java.lang.Boolean hasLatestVersion() {
    return this.latestVersion != null;
  }
  public java.lang.Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(java.lang.Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public java.lang.Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public java.lang.Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  public A withReadyReplicas(java.lang.Integer readyReplicas) {
    this.readyReplicas=readyReplicas; return (A) this;
  }
  public java.lang.Boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  public java.lang.Integer getUnavailableReplicas() {
    return this.unavailableReplicas;
  }
  public A withUnavailableReplicas(java.lang.Integer unavailableReplicas) {
    this.unavailableReplicas=unavailableReplicas; return (A) this;
  }
  public java.lang.Boolean hasUnavailableReplicas() {
    return this.unavailableReplicas != null;
  }
  public java.lang.Integer getUpdatedReplicas() {
    return this.updatedReplicas;
  }
  public A withUpdatedReplicas(java.lang.Integer updatedReplicas) {
    this.updatedReplicas=updatedReplicas; return (A) this;
  }
  public java.lang.Boolean hasUpdatedReplicas() {
    return this.updatedReplicas != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeploymentConfigStatusFluentImpl that = (DeploymentConfigStatusFluentImpl) o;
    if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (details != null ? !details.equals(that.details) :that.details != null) return false;
    if (latestVersion != null ? !latestVersion.equals(that.latestVersion) :that.latestVersion != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (unavailableReplicas != null ? !unavailableReplicas.equals(that.unavailableReplicas) :that.unavailableReplicas != null) return false;
    if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableReplicas,  conditions,  details,  latestVersion,  observedGeneration,  readyReplicas,  replicas,  unavailableReplicas,  updatedReplicas,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.DeploymentConditionFluentImpl<io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.DeploymentCondition item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.DeploymentConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.DeploymentConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) DeploymentConfigStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class DetailsNestedImpl<N> extends io.fabric8.openshift.api.model.DeploymentDetailsFluentImpl<io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<N>> implements io.fabric8.openshift.api.model.DeploymentConfigStatusFluent.DetailsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DetailsNestedImpl(io.fabric8.openshift.api.model.DeploymentDetails item) {
      this.builder = new io.fabric8.openshift.api.model.DeploymentDetailsBuilder(this, item);
    }
    DetailsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.DeploymentDetailsBuilder(this);
    }
    io.fabric8.openshift.api.model.DeploymentDetailsBuilder builder;
    public N and() {
      return (N) DeploymentConfigStatusFluentImpl.this.withDetails(builder.build());
    }
    public N endDetails() {
      return and();
    }
    
  }
  
}