package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DeploymentConfigBuilder extends io.fabric8.openshift.api.model.DeploymentConfigFluentImpl<io.fabric8.openshift.api.model.DeploymentConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.DeploymentConfig,io.fabric8.openshift.api.model.DeploymentConfigBuilder>{
  public DeploymentConfigBuilder() {
    this(false);
  }
  public DeploymentConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new DeploymentConfig(), validationEnabled);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentConfig(), validationEnabled);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfig instance) {
    this(fluent, instance, false);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfig instance) {
    this(instance,false);
  }
  public DeploymentConfigBuilder(io.fabric8.openshift.api.model.DeploymentConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DeploymentConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DeploymentConfig build() {
    DeploymentConfig buildable = new DeploymentConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentConfigBuilder that = (DeploymentConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}