package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ConsoleListBuilder extends io.fabric8.openshift.api.model.ConsoleListFluentImpl<io.fabric8.openshift.api.model.ConsoleListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ConsoleList,io.fabric8.openshift.api.model.ConsoleListBuilder>{
  public ConsoleListBuilder() {
    this(false);
  }
  public ConsoleListBuilder(java.lang.Boolean validationEnabled) {
    this(new ConsoleList(), validationEnabled);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleList(), validationEnabled);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleList instance) {
    this(fluent, instance, false);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleList instance) {
    this(instance,false);
  }
  public ConsoleListBuilder(io.fabric8.openshift.api.model.ConsoleList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConsoleListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConsoleList build() {
    ConsoleList buildable = new ConsoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleListBuilder that = (ConsoleListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}