package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class APIServerSpecBuilder extends io.fabric8.openshift.api.model.APIServerSpecFluentImpl<io.fabric8.openshift.api.model.APIServerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.APIServerSpec,io.fabric8.openshift.api.model.APIServerSpecBuilder>{
  public APIServerSpecBuilder() {
    this(false);
  }
  public APIServerSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new APIServerSpec(), validationEnabled);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServerSpec(), validationEnabled);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent,io.fabric8.openshift.api.model.APIServerSpec instance) {
    this(fluent, instance, false);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent,io.fabric8.openshift.api.model.APIServerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins()); 
    fluent.withAudit(instance.getAudit()); 
    fluent.withClientCA(instance.getClientCA()); 
    fluent.withEncryption(instance.getEncryption()); 
    fluent.withServingCerts(instance.getServingCerts()); 
    fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    this.validationEnabled = validationEnabled; 
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpec instance) {
    this(instance,false);
  }
  public APIServerSpecBuilder(io.fabric8.openshift.api.model.APIServerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins()); 
    this.withAudit(instance.getAudit()); 
    this.withClientCA(instance.getClientCA()); 
    this.withEncryption(instance.getEncryption()); 
    this.withServingCerts(instance.getServingCerts()); 
    this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.APIServerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.APIServerSpec build() {
    APIServerSpec buildable = new APIServerSpec(fluent.getAdditionalCORSAllowedOrigins(),fluent.getAudit(),fluent.getClientCA(),fluent.getEncryption(),fluent.getServingCerts(),fluent.getTlsSecurityProfile());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerSpecBuilder that = (APIServerSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}