package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class APIServerBuilder extends io.fabric8.openshift.api.model.APIServerFluentImpl<io.fabric8.openshift.api.model.APIServerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.APIServer,io.fabric8.openshift.api.model.APIServerBuilder>{
  public APIServerBuilder() {
    this(false);
  }
  public APIServerBuilder(java.lang.Boolean validationEnabled) {
    this(new APIServer(), validationEnabled);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServerFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServer(), validationEnabled);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServerFluent<?> fluent,io.fabric8.openshift.api.model.APIServer instance) {
    this(fluent, instance, false);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServerFluent<?> fluent,io.fabric8.openshift.api.model.APIServer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServer instance) {
    this(instance,false);
  }
  public APIServerBuilder(io.fabric8.openshift.api.model.APIServer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.APIServerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.APIServer build() {
    APIServer buildable = new APIServer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerBuilder that = (APIServerBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}