package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TLSProfileSpecBuilder extends io.fabric8.openshift.api.model.TLSProfileSpecFluentImpl<io.fabric8.openshift.api.model.TLSProfileSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.TLSProfileSpec,io.fabric8.openshift.api.model.TLSProfileSpecBuilder> {

    io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TLSProfileSpecBuilder() {
        this(true);
    }

    public TLSProfileSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new TLSProfileSpec(), validationEnabled);
    }

    public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TLSProfileSpec(), validationEnabled);
    }

    public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent,io.fabric8.openshift.api.model.TLSProfileSpec instance) {
        this(fluent, instance, true);
    }

    public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpecFluent<?> fluent,io.fabric8.openshift.api.model.TLSProfileSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCiphers(instance.getCiphers()); 
        fluent.withMinTLSVersion(instance.getMinTLSVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpec instance) {
        this(instance,true);
    }

    public TLSProfileSpecBuilder(io.fabric8.openshift.api.model.TLSProfileSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCiphers(instance.getCiphers()); 
        this.withMinTLSVersion(instance.getMinTLSVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.TLSProfileSpec build() {
        TLSProfileSpec buildable = new TLSProfileSpec(fluent.getCiphers(),fluent.getMinTLSVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TLSProfileSpecBuilder that = (TLSProfileSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
