package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceAccountReferenceBuilder extends io.fabric8.openshift.api.model.ServiceAccountReferenceFluentImpl<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ServiceAccountReference,io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder> {

    io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceAccountReferenceBuilder() {
        this(true);
    }

    public ServiceAccountReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new ServiceAccountReference(), validationEnabled);
    }

    public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServiceAccountReference(), validationEnabled);
    }

    public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ServiceAccountReference instance) {
        this(fluent, instance, true);
    }

    public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ServiceAccountReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReference instance) {
        this(instance,true);
    }

    public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ServiceAccountReference build() {
        ServiceAccountReference buildable = new ServiceAccountReference(fluent.getName(),fluent.getNamespace());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceAccountReferenceBuilder that = (ServiceAccountReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
