package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ScopeRestrictionBuilder extends io.fabric8.openshift.api.model.ScopeRestrictionFluentImpl<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ScopeRestriction,io.fabric8.openshift.api.model.ScopeRestrictionBuilder> {

    io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ScopeRestrictionBuilder() {
        this(true);
    }

    public ScopeRestrictionBuilder(java.lang.Boolean validationEnabled) {
        this(new ScopeRestriction(), validationEnabled);
    }

    public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent) {
        this(fluent, true);
    }

    public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ScopeRestriction(), validationEnabled);
    }

    public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.ScopeRestriction instance) {
        this(fluent, instance, true);
    }

    public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.ScopeRestriction instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClusterRole(instance.getClusterRole()); 
        fluent.withLiterals(instance.getLiterals()); 
        this.validationEnabled = validationEnabled; 
    }

    public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestriction instance) {
        this(instance,true);
    }

    public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestriction instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withClusterRole(instance.getClusterRole()); 
        this.withLiterals(instance.getLiterals()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ScopeRestriction build() {
        ScopeRestriction buildable = new ScopeRestriction(fluent.getClusterRole(),fluent.getLiterals());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ScopeRestrictionBuilder that = (ScopeRestrictionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
