package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProjectRequestBuilder extends io.fabric8.openshift.api.model.ProjectRequestFluentImpl<io.fabric8.openshift.api.model.ProjectRequestBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ProjectRequest,io.fabric8.openshift.api.model.ProjectRequestBuilder> {

    io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ProjectRequestBuilder() {
        this(true);
    }

    public ProjectRequestBuilder(java.lang.Boolean validationEnabled) {
        this(new ProjectRequest(), validationEnabled);
    }

    public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent) {
        this(fluent, true);
    }

    public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ProjectRequest(), validationEnabled);
    }

    public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent,io.fabric8.openshift.api.model.ProjectRequest instance) {
        this(fluent, instance, true);
    }

    public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent,io.fabric8.openshift.api.model.ProjectRequest instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withDescription(instance.getDescription()); 
        fluent.withDisplayName(instance.getDisplayName()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequest instance) {
        this(instance,true);
    }

    public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequest instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ProjectRequest build() {
        ProjectRequest buildable = new ProjectRequest(fluent.getApiVersion(),fluent.getDescription(),fluent.getDisplayName(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProjectRequestBuilder that = (ProjectRequestBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
