package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodSecurityPolicyReviewStatusFluentImpl<A extends io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder> allowedServiceAccounts =  new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder>();

    public PodSecurityPolicyReviewStatusFluentImpl() {
    }

    public PodSecurityPolicyReviewStatusFluentImpl(io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatus instance) {
        this.withAllowedServiceAccounts(instance.getAllowedServiceAccounts()); 
    }

    public A addToAllowedServiceAccounts(int index,io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item) {
        if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
        io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(index >= 0 ? index : _visitables.get("allowedServiceAccounts").size(), builder);this.allowedServiceAccounts.add(index >= 0 ? index : allowedServiceAccounts.size(), builder); return (A)this;
    }

    public A setToAllowedServiceAccounts(int index,io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item) {
        if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
        io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("allowedServiceAccounts").size()) { _visitables.get("allowedServiceAccounts").add(builder); } else { _visitables.get("allowedServiceAccounts").set(index, builder);}
        if (index < 0 || index >= allowedServiceAccounts.size()) { allowedServiceAccounts.add(builder); } else { allowedServiceAccounts.set(index, builder);}
         return (A)this;
    }

    public A addToAllowedServiceAccounts(io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus... items) {
        if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
        for (io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item : items) {io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(builder);this.allowedServiceAccounts.add(builder);} return (A)this;
    }

    public A addAllToAllowedServiceAccounts(java.util.Collection<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus> items) {
        if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
        for (io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item : items) {io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(builder);this.allowedServiceAccounts.add(builder);} return (A)this;
    }

    public A removeFromAllowedServiceAccounts(io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus... items) {
        for (io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item : items) {io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").remove(builder);if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromAllowedServiceAccounts(java.util.Collection<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus> items) {
        for (io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item : items) {io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").remove(builder);if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAllowedServiceAccounts(java.util.function.Predicate<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        if (allowedServiceAccounts == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder> each = allowedServiceAccounts.iterator();
        final List visitables = _visitables.get("allowedServiceAccounts");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAllowedServiceAccounts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus> getAllowedServiceAccounts() {
        return build(allowedServiceAccounts);
    }

    public java.util.List<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus> buildAllowedServiceAccounts() {
        return build(allowedServiceAccounts);
    }

    public io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus buildAllowedServiceAccount(int index) {
        return this.allowedServiceAccounts.get(index).build();
    }

    public io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus buildFirstAllowedServiceAccount() {
        return this.allowedServiceAccounts.get(0).build();
    }

    public io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus buildLastAllowedServiceAccount() {
        return this.allowedServiceAccounts.get(allowedServiceAccounts.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus buildMatchingAllowedServiceAccount(java.util.function.Predicate<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder item: allowedServiceAccounts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingAllowedServiceAccount(java.util.function.Predicate<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder item: allowedServiceAccounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAllowedServiceAccounts(java.util.List<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus> allowedServiceAccounts) {
        if (this.allowedServiceAccounts != null) { _visitables.get("allowedServiceAccounts").removeAll(this.allowedServiceAccounts);}
        if (allowedServiceAccounts != null) {this.allowedServiceAccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder>(); for (io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item : allowedServiceAccounts){this.addToAllowedServiceAccounts(item);}} else { this.allowedServiceAccounts = null;} return (A) this;
    }

    public A withAllowedServiceAccounts(io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus... allowedServiceAccounts) {
        if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.clear();}
        if (allowedServiceAccounts != null) {for (io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item :allowedServiceAccounts){ this.addToAllowedServiceAccounts(item);}} return (A) this;
    }

    public java.lang.Boolean hasAllowedServiceAccounts() {
        return allowedServiceAccounts != null && !allowedServiceAccounts.isEmpty();
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> addNewAllowedServiceAccount() {
        return new io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluentImpl.AllowedServiceAccountsNestedImpl();
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> addNewAllowedServiceAccountLike(io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item) {
        return new io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluentImpl.AllowedServiceAccountsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> setNewAllowedServiceAccountLike(int index,io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item) {
        return new io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluentImpl.AllowedServiceAccountsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editAllowedServiceAccount(int index) {
        if (allowedServiceAccounts.size() <= index) throw new RuntimeException("Can't edit allowedServiceAccounts. Index exceeds size.");
        return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editFirstAllowedServiceAccount() {
        if (allowedServiceAccounts.size() == 0) throw new RuntimeException("Can't edit first allowedServiceAccounts. The list is empty.");
        return setNewAllowedServiceAccountLike(0, buildAllowedServiceAccount(0));
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editLastAllowedServiceAccount() {
        int index = allowedServiceAccounts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last allowedServiceAccounts. The list is empty.");
        return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
    }

    public io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editMatchingAllowedServiceAccount(java.util.function.Predicate<io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<allowedServiceAccounts.size();i++) { 
        if (predicate.test(allowedServiceAccounts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching allowedServiceAccounts. No match found.");
        return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSecurityPolicyReviewStatusFluentImpl that = (PodSecurityPolicyReviewStatusFluentImpl) o;
        if (allowedServiceAccounts != null ? !allowedServiceAccounts.equals(that.allowedServiceAccounts) :that.allowedServiceAccounts != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allowedServiceAccounts,  super.hashCode());
    }

    public class AllowedServiceAccountsNestedImpl<N> extends io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<N>> implements io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
        private final int index;

            AllowedServiceAccountsNestedImpl(int index,io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
                        
            }

            AllowedServiceAccountsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PodSecurityPolicyReviewStatusFluentImpl.this.setToAllowedServiceAccounts(index,builder.build());
            }

            public N endAllowedServiceAccount() {
                return and();
            }
    }


}
