package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class OAuthClientAuthorizationFluentImpl<A extends io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String clientName;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.util.List<java.lang.String> scopes = new java.util.ArrayList<java.lang.String>();
    private java.lang.String userName;
    private java.lang.String userUID;

    public OAuthClientAuthorizationFluentImpl() {
    }

    public OAuthClientAuthorizationFluentImpl(io.fabric8.openshift.api.model.OAuthClientAuthorization instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withClientName(instance.getClientName()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withScopes(instance.getScopes()); 
        this.withUserName(instance.getUserName()); 
        this.withUserUID(instance.getUserUID()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getClientName() {
        return this.clientName;
    }

    public A withClientName(java.lang.String clientName) {
        this.clientName=clientName; return (A) this;
    }

    public java.lang.Boolean hasClientName() {
        return this.clientName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientName instead.
     */
        public A withNewClientName(java.lang.String arg0) {
        return (A)withClientName(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToScopes(int index,java.lang.String item) {
        if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
        this.scopes.add(index, item);
        return (A)this;
    }

    public A setToScopes(int index,java.lang.String item) {
        if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
        this.scopes.set(index, item); return (A)this;
    }

    public A addToScopes(java.lang.String... items) {
        if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A addAllToScopes(java.util.Collection<java.lang.String> items) {
        if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A removeFromScopes(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
    }

    public A removeAllFromScopes(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getScopes() {
        return this.scopes;
    }

    public java.lang.String getScope(int index) {
        return this.scopes.get(index);
    }

    public java.lang.String getFirstScope() {
        return this.scopes.get(0);
    }

    public java.lang.String getLastScope() {
        return this.scopes.get(scopes.size() - 1);
    }

    public java.lang.String getMatchingScope(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: scopes) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingScope(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: scopes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withScopes(java.util.List<java.lang.String> scopes) {
        if (this.scopes != null) { _visitables.get("scopes").removeAll(this.scopes);}
        if (scopes != null) {this.scopes = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
    }

    public A withScopes(java.lang.String... scopes) {
        if (this.scopes != null) {this.scopes.clear();}
        if (scopes != null) {for (java.lang.String item :scopes){ this.addToScopes(item);}} return (A) this;
    }

    public java.lang.Boolean hasScopes() {
        return scopes != null && !scopes.isEmpty();
    }

    public A addNewScope(java.lang.String arg0) {
        return (A)addToScopes(new String(arg0));
    }

    public java.lang.String getUserName() {
        return this.userName;
    }

    public A withUserName(java.lang.String userName) {
        this.userName=userName; return (A) this;
    }

    public java.lang.Boolean hasUserName() {
        return this.userName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUserName instead.
     */
        public A withNewUserName(java.lang.String arg0) {
        return (A)withUserName(new String(arg0));
    }

    public java.lang.String getUserUID() {
        return this.userUID;
    }

    public A withUserUID(java.lang.String userUID) {
        this.userUID=userUID; return (A) this;
    }

    public java.lang.Boolean hasUserUID() {
        return this.userUID != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUserUID instead.
     */
        public A withNewUserUID(java.lang.String arg0) {
        return (A)withUserUID(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OAuthClientAuthorizationFluentImpl that = (OAuthClientAuthorizationFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (clientName != null ? !clientName.equals(that.clientName) :that.clientName != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
        if (userName != null ? !userName.equals(that.userName) :that.userName != null) return false;
        if (userUID != null ? !userUID.equals(that.userUID) :that.userUID != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  clientName,  kind,  metadata,  scopes,  userName,  userUID,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) OAuthClientAuthorizationFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
