package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageStreamTagListBuilder extends io.fabric8.openshift.api.model.ImageStreamTagListFluentImpl<io.fabric8.openshift.api.model.ImageStreamTagListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamTagList,io.fabric8.openshift.api.model.ImageStreamTagListBuilder> {

    io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ImageStreamTagListBuilder() {
        this(true);
    }

    public ImageStreamTagListBuilder(java.lang.Boolean validationEnabled) {
        this(new ImageStreamTagList(), validationEnabled);
    }

    public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ImageStreamTagList(), validationEnabled);
    }

    public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTagList instance) {
        this(fluent, instance, true);
    }

    public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTagList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagList instance) {
        this(instance,true);
    }

    public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ImageStreamTagList build() {
        ImageStreamTagList buildable = new ImageStreamTagList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageStreamTagListBuilder that = (ImageStreamTagListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
