package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageStreamTagBuilder extends io.fabric8.openshift.api.model.ImageStreamTagFluentImpl<io.fabric8.openshift.api.model.ImageStreamTagBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamTag,io.fabric8.openshift.api.model.ImageStreamTagBuilder> {

    io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ImageStreamTagBuilder() {
        this(true);
    }

    public ImageStreamTagBuilder(java.lang.Boolean validationEnabled) {
        this(new ImageStreamTag(), validationEnabled);
    }

    public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ImageStreamTag(), validationEnabled);
    }

    public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTag instance) {
        this(fluent, instance, true);
    }

    public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTag instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGeneration(instance.getGeneration()); 
        fluent.withImage(instance.getImage()); 
        fluent.withKind(instance.getKind()); 
        fluent.withLookupPolicy(instance.getLookupPolicy()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withTag(instance.getTag()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTag instance) {
        this(instance,true);
    }

    public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTag instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withConditions(instance.getConditions()); 
        this.withGeneration(instance.getGeneration()); 
        this.withImage(instance.getImage()); 
        this.withKind(instance.getKind()); 
        this.withLookupPolicy(instance.getLookupPolicy()); 
        this.withMetadata(instance.getMetadata()); 
        this.withTag(instance.getTag()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ImageStreamTag build() {
        ImageStreamTag buildable = new ImageStreamTag(fluent.getApiVersion(),fluent.getConditions(),fluent.getGeneration(),fluent.getImage(),fluent.getKind(),fluent.getLookupPolicy(),fluent.getMetadata(),fluent.getTag());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageStreamTagBuilder that = (ImageStreamTagBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
