package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class GroupFluentImpl<A extends io.fabric8.openshift.api.model.GroupFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.GroupFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.util.List<java.lang.String> users = new java.util.ArrayList<java.lang.String>();

    public GroupFluentImpl() {
    }

    public GroupFluentImpl(io.fabric8.openshift.api.model.Group instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withUsers(instance.getUsers()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.GroupFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.GroupFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToUsers(int index,java.lang.String item) {
        if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
        this.users.add(index, item);
        return (A)this;
    }

    public A setToUsers(int index,java.lang.String item) {
        if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
        this.users.set(index, item); return (A)this;
    }

    public A addToUsers(java.lang.String... items) {
        if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.users.add(item);} return (A)this;
    }

    public A addAllToUsers(java.util.Collection<java.lang.String> items) {
        if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.users.add(item);} return (A)this;
    }

    public A removeFromUsers(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
    }

    public A removeAllFromUsers(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getUsers() {
        return this.users;
    }

    public java.lang.String getUser(int index) {
        return this.users.get(index);
    }

    public java.lang.String getFirstUser() {
        return this.users.get(0);
    }

    public java.lang.String getLastUser() {
        return this.users.get(users.size() - 1);
    }

    public java.lang.String getMatchingUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: users) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: users) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withUsers(java.util.List<java.lang.String> users) {
        if (this.users != null) { _visitables.get("users").removeAll(this.users);}
        if (users != null) {this.users = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
    }

    public A withUsers(java.lang.String... users) {
        if (this.users != null) {this.users.clear();}
        if (users != null) {for (java.lang.String item :users){ this.addToUsers(item);}} return (A) this;
    }

    public java.lang.Boolean hasUsers() {
        return users != null && !users.isEmpty();
    }

    public A addNewUser(java.lang.String arg0) {
        return (A)addToUsers(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GroupFluentImpl that = (GroupFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (users != null ? !users.equals(that.users) :that.users != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  users,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.GroupFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.GroupFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) GroupFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
