package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GCPPlatformStatusBuilder extends io.fabric8.openshift.api.model.GCPPlatformStatusFluentImpl<io.fabric8.openshift.api.model.GCPPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.GCPPlatformStatus,io.fabric8.openshift.api.model.GCPPlatformStatusBuilder> {

    io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GCPPlatformStatusBuilder() {
        this(true);
    }

    public GCPPlatformStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new GCPPlatformStatus(), validationEnabled);
    }

    public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GCPPlatformStatus(), validationEnabled);
    }

    public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.GCPPlatformStatus instance) {
        this(fluent, instance, true);
    }

    public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.GCPPlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withProjectID(instance.getProjectID()); 
        fluent.withRegion(instance.getRegion()); 
        this.validationEnabled = validationEnabled; 
    }

    public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatus instance) {
        this(instance,true);
    }

    public GCPPlatformStatusBuilder(io.fabric8.openshift.api.model.GCPPlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withProjectID(instance.getProjectID()); 
        this.withRegion(instance.getRegion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.GCPPlatformStatus build() {
        GCPPlatformStatus buildable = new GCPPlatformStatus(fluent.getProjectID(),fluent.getRegion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GCPPlatformStatusBuilder that = (GCPPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
