package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExecNewPodHookBuilder extends io.fabric8.openshift.api.model.ExecNewPodHookFluentImpl<io.fabric8.openshift.api.model.ExecNewPodHookBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ExecNewPodHook,io.fabric8.openshift.api.model.ExecNewPodHookBuilder> {

    io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExecNewPodHookBuilder() {
        this(true);
    }

    public ExecNewPodHookBuilder(java.lang.Boolean validationEnabled) {
        this(new ExecNewPodHook(), validationEnabled);
    }

    public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent) {
        this(fluent, true);
    }

    public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExecNewPodHook(), validationEnabled);
    }

    public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent,io.fabric8.openshift.api.model.ExecNewPodHook instance) {
        this(fluent, instance, true);
    }

    public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHookFluent<?> fluent,io.fabric8.openshift.api.model.ExecNewPodHook instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCommand(instance.getCommand()); 
        fluent.withContainerName(instance.getContainerName()); 
        fluent.withEnv(instance.getEnv()); 
        fluent.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }

    public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHook instance) {
        this(instance,true);
    }

    public ExecNewPodHookBuilder(io.fabric8.openshift.api.model.ExecNewPodHook instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCommand(instance.getCommand()); 
        this.withContainerName(instance.getContainerName()); 
        this.withEnv(instance.getEnv()); 
        this.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ExecNewPodHook build() {
        ExecNewPodHook buildable = new ExecNewPodHook(fluent.getCommand(),fluent.getContainerName(),fluent.getEnv(),fluent.getVolumes());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExecNewPodHookBuilder that = (ExecNewPodHookBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
