package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EgressNetworkPolicyBuilder extends io.fabric8.openshift.api.model.EgressNetworkPolicyFluentImpl<io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.EgressNetworkPolicy,io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder> {

    io.fabric8.openshift.api.model.EgressNetworkPolicyFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EgressNetworkPolicyBuilder() {
        this(true);
    }

    public EgressNetworkPolicyBuilder(java.lang.Boolean validationEnabled) {
        this(new EgressNetworkPolicy(), validationEnabled);
    }

    public EgressNetworkPolicyBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyFluent<?> fluent) {
        this(fluent, true);
    }

    public EgressNetworkPolicyBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EgressNetworkPolicy(), validationEnabled);
    }

    public EgressNetworkPolicyBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyFluent<?> fluent,io.fabric8.openshift.api.model.EgressNetworkPolicy instance) {
        this(fluent, instance, true);
    }

    public EgressNetworkPolicyBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicyFluent<?> fluent,io.fabric8.openshift.api.model.EgressNetworkPolicy instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public EgressNetworkPolicyBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicy instance) {
        this(instance,true);
    }

    public EgressNetworkPolicyBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicy instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.EgressNetworkPolicy build() {
        EgressNetworkPolicy buildable = new EgressNetworkPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EgressNetworkPolicyBuilder that = (EgressNetworkPolicyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
