package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DeploymentConfigSpecBuilder extends io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl<io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.DeploymentConfigSpec,io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder> {

    io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public DeploymentConfigSpecBuilder() {
        this(true);
    }

    public DeploymentConfigSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new DeploymentConfigSpec(), validationEnabled);
    }

    public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new DeploymentConfigSpec(), validationEnabled);
    }

    public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfigSpec instance) {
        this(fluent, instance, true);
    }

    public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfigSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
        fluent.withPaused(instance.getPaused()); 
        fluent.withReplicas(instance.getReplicas()); 
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withStrategy(instance.getStrategy()); 
        fluent.withTemplate(instance.getTemplate()); 
        fluent.withTest(instance.getTest()); 
        fluent.withTriggers(instance.getTriggers()); 
        this.validationEnabled = validationEnabled; 
    }

    public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpec instance) {
        this(instance,true);
    }

    public DeploymentConfigSpecBuilder(io.fabric8.openshift.api.model.DeploymentConfigSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMinReadySeconds(instance.getMinReadySeconds()); 
        this.withPaused(instance.getPaused()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
        this.withSelector(instance.getSelector()); 
        this.withStrategy(instance.getStrategy()); 
        this.withTemplate(instance.getTemplate()); 
        this.withTest(instance.getTest()); 
        this.withTriggers(instance.getTriggers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.DeploymentConfigSpec build() {
        DeploymentConfigSpec buildable = new DeploymentConfigSpec(fluent.getMinReadySeconds(),fluent.getPaused(),fluent.getReplicas(),fluent.getRevisionHistoryLimit(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate(),fluent.getTest(),fluent.getTriggers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DeploymentConfigSpecBuilder that = (DeploymentConfigSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
