package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaSpecBuilder extends io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluentImpl<io.fabric8.openshift.api.model.ClusterResourceQuotaSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterResourceQuotaSpec,io.fabric8.openshift.api.model.ClusterResourceQuotaSpecBuilder> {

    io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterResourceQuotaSpecBuilder() {
        this(true);
    }

    public ClusterResourceQuotaSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterResourceQuotaSpec(), validationEnabled);
    }

    public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterResourceQuotaSpec(), validationEnabled);
    }

    public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaSpec instance) {
        this(fluent, instance, true);
    }

    public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpecFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuotaSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withQuota(instance.getQuota()); 
        fluent.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpec instance) {
        this(instance,true);
    }

    public ClusterResourceQuotaSpecBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withQuota(instance.getQuota()); 
        this.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ClusterResourceQuotaSpec build() {
        ClusterResourceQuotaSpec buildable = new ClusterResourceQuotaSpec(fluent.getQuota(),fluent.getSelector());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterResourceQuotaSpecBuilder that = (ClusterResourceQuotaSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
