package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaBuilder extends io.fabric8.openshift.api.model.ClusterResourceQuotaFluentImpl<io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterResourceQuota,io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder> {

    io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterResourceQuotaBuilder() {
        this(true);
    }

    public ClusterResourceQuotaBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterResourceQuota(), validationEnabled);
    }

    public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterResourceQuota(), validationEnabled);
    }

    public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuota instance) {
        this(fluent, instance, true);
    }

    public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuotaFluent<?> fluent,io.fabric8.openshift.api.model.ClusterResourceQuota instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuota instance) {
        this(instance,true);
    }

    public ClusterResourceQuotaBuilder(io.fabric8.openshift.api.model.ClusterResourceQuota instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ClusterResourceQuota build() {
        ClusterResourceQuota buildable = new ClusterResourceQuota(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterResourceQuotaBuilder that = (ClusterResourceQuotaBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
