package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildConfigSpecBuilder extends io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl<io.fabric8.openshift.api.model.BuildConfigSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BuildConfigSpec,io.fabric8.openshift.api.model.BuildConfigSpecBuilder> {

    io.fabric8.openshift.api.model.BuildConfigSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildConfigSpecBuilder() {
        this(true);
    }

    public BuildConfigSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new BuildConfigSpec(), validationEnabled);
    }

    public BuildConfigSpecBuilder(io.fabric8.openshift.api.model.BuildConfigSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildConfigSpecBuilder(io.fabric8.openshift.api.model.BuildConfigSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BuildConfigSpec(), validationEnabled);
    }

    public BuildConfigSpecBuilder(io.fabric8.openshift.api.model.BuildConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfigSpec instance) {
        this(fluent, instance, true);
    }

    public BuildConfigSpecBuilder(io.fabric8.openshift.api.model.BuildConfigSpecFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfigSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
        fluent.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit()); 
        fluent.withNodeSelector(instance.getNodeSelector()); 
        fluent.withOutput(instance.getOutput()); 
        fluent.withPostCommit(instance.getPostCommit()); 
        fluent.withResources(instance.getResources()); 
        fluent.withRevision(instance.getRevision()); 
        fluent.withRunPolicy(instance.getRunPolicy()); 
        fluent.withServiceAccount(instance.getServiceAccount()); 
        fluent.withSource(instance.getSource()); 
        fluent.withStrategy(instance.getStrategy()); 
        fluent.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit()); 
        fluent.withTriggers(instance.getTriggers()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildConfigSpecBuilder(io.fabric8.openshift.api.model.BuildConfigSpec instance) {
        this(instance,true);
    }

    public BuildConfigSpecBuilder(io.fabric8.openshift.api.model.BuildConfigSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); 
        this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withOutput(instance.getOutput()); 
        this.withPostCommit(instance.getPostCommit()); 
        this.withResources(instance.getResources()); 
        this.withRevision(instance.getRevision()); 
        this.withRunPolicy(instance.getRunPolicy()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withSource(instance.getSource()); 
        this.withStrategy(instance.getStrategy()); 
        this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit()); 
        this.withTriggers(instance.getTriggers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.BuildConfigSpec build() {
        BuildConfigSpec buildable = new BuildConfigSpec(fluent.getCompletionDeadlineSeconds(),fluent.getFailedBuildsHistoryLimit(),fluent.getNodeSelector(),fluent.getOutput(),fluent.getPostCommit(),fluent.getResources(),fluent.getRevision(),fluent.getRunPolicy(),fluent.getServiceAccount(),fluent.getSource(),fluent.getStrategy(),fluent.getSuccessfulBuildsHistoryLimit(),fluent.getTriggers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildConfigSpecBuilder that = (BuildConfigSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
