package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildConfigBuilder extends io.fabric8.openshift.api.model.BuildConfigFluentImpl<io.fabric8.openshift.api.model.BuildConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.BuildConfig,io.fabric8.openshift.api.model.BuildConfigBuilder> {

    io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildConfigBuilder() {
        this(true);
    }

    public BuildConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new BuildConfig(), validationEnabled);
    }

    public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BuildConfig(), validationEnabled);
    }

    public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfig instance) {
        this(fluent, instance, true);
    }

    public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfigFluent<?> fluent,io.fabric8.openshift.api.model.BuildConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfig instance) {
        this(instance,true);
    }

    public BuildConfigBuilder(io.fabric8.openshift.api.model.BuildConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.BuildConfig build() {
        BuildConfig buildable = new BuildConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildConfigBuilder that = (BuildConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
