package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuthenticationSpecBuilder extends io.fabric8.openshift.api.model.AuthenticationSpecFluentImpl<io.fabric8.openshift.api.model.AuthenticationSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.AuthenticationSpec,io.fabric8.openshift.api.model.AuthenticationSpecBuilder> {

    io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public AuthenticationSpecBuilder() {
        this(true);
    }

    public AuthenticationSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new AuthenticationSpec(), validationEnabled);
    }

    public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new AuthenticationSpec(), validationEnabled);
    }

    public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent,io.fabric8.openshift.api.model.AuthenticationSpec instance) {
        this(fluent, instance, true);
    }

    public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpecFluent<?> fluent,io.fabric8.openshift.api.model.AuthenticationSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withOauthMetadata(instance.getOauthMetadata()); 
        fluent.withServiceAccountIssuer(instance.getServiceAccountIssuer()); 
        fluent.withType(instance.getType()); 
        fluent.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator()); 
        fluent.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators()); 
        this.validationEnabled = validationEnabled; 
    }

    public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpec instance) {
        this(instance,true);
    }

    public AuthenticationSpecBuilder(io.fabric8.openshift.api.model.AuthenticationSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withOauthMetadata(instance.getOauthMetadata()); 
        this.withServiceAccountIssuer(instance.getServiceAccountIssuer()); 
        this.withType(instance.getType()); 
        this.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator()); 
        this.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.AuthenticationSpec build() {
        AuthenticationSpec buildable = new AuthenticationSpec(fluent.getOauthMetadata(),fluent.getServiceAccountIssuer(),fluent.getType(),fluent.getWebhookTokenAuthenticator(),fluent.getWebhookTokenAuthenticators());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AuthenticationSpecBuilder that = (AuthenticationSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
