package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class PowerVSPlatformStatusFluentImpl<A extends io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent<A>{
  public PowerVSPlatformStatusFluentImpl() {
  }
  public PowerVSPlatformStatusFluentImpl(io.fabric8.openshift.api.model.PowerVSPlatformStatus instance) {
    this.withCisInstanceCRN(instance.getCisInstanceCRN()); 
    this.withRegion(instance.getRegion()); 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withZone(instance.getZone()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String cisInstanceCRN;
  private java.lang.String region;
  private java.util.List<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder> serviceEndpoints =  new java.util.ArrayList<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder>();
  private java.lang.String zone;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getCisInstanceCRN() {
    return this.cisInstanceCRN;
  }
  public A withCisInstanceCRN(java.lang.String cisInstanceCRN) {
    this.cisInstanceCRN=cisInstanceCRN; return (A) this;
  }
  public java.lang.Boolean hasCisInstanceCRN() {
    return this.cisInstanceCRN != null;
  }
  
  /**
   * Method is deprecated. use withCisInstanceCRN instead.
   */
  @java.lang.Deprecated
  public A withNewCisInstanceCRN(java.lang.String arg0) {
    return (A)withCisInstanceCRN(new String(arg0));
  }
  public java.lang.String getRegion() {
    return this.region;
  }
  public A withRegion(java.lang.String region) {
    this.region=region; return (A) this;
  }
  public java.lang.Boolean hasRegion() {
    return this.region != null;
  }
  
  /**
   * Method is deprecated. use withRegion instead.
   */
  @java.lang.Deprecated
  public A withNewRegion(java.lang.String arg0) {
    return (A)withRegion(new String(arg0));
  }
  public A addToServiceEndpoints(java.lang.Integer index,io.fabric8.openshift.api.model.PowerVSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder>();}
    io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(index >= 0 ? index : _visitables.get("serviceEndpoints").size(), builder);this.serviceEndpoints.add(index >= 0 ? index : serviceEndpoints.size(), builder); return (A)this;
  }
  public A setToServiceEndpoints(java.lang.Integer index,io.fabric8.openshift.api.model.PowerVSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder>();}
    io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder(item);
    if (index < 0 || index >= _visitables.get("serviceEndpoints").size()) { _visitables.get("serviceEndpoints").add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder);}
    if (index < 0 || index >= serviceEndpoints.size()) { serviceEndpoints.add(builder); } else { serviceEndpoints.set(index, builder);}
     return (A)this;
  }
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.PowerVSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder>();}
    for (io.fabric8.openshift.api.model.PowerVSServiceEndpoint item : items) {io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A addAllToServiceEndpoints(java.util.Collection<io.fabric8.openshift.api.model.PowerVSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new java.util.ArrayList<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder>();}
    for (io.fabric8.openshift.api.model.PowerVSServiceEndpoint item : items) {io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.PowerVSServiceEndpoint... items) {
    for (io.fabric8.openshift.api.model.PowerVSServiceEndpoint item : items) {io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceEndpoints(java.util.Collection<io.fabric8.openshift.api.model.PowerVSServiceEndpoint> items) {
    for (io.fabric8.openshift.api.model.PowerVSServiceEndpoint item : items) {io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder builder = new io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceEndpoints(java.util.function.Predicate<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceEndpoints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.PowerVSServiceEndpoint> getServiceEndpoints() {
    return build(serviceEndpoints);
  }
  public java.util.List<io.fabric8.openshift.api.model.PowerVSServiceEndpoint> buildServiceEndpoints() {
    return build(serviceEndpoints);
  }
  public io.fabric8.openshift.api.model.PowerVSServiceEndpoint buildServiceEndpoint(java.lang.Integer index) {
    return this.serviceEndpoints.get(index).build();
  }
  public io.fabric8.openshift.api.model.PowerVSServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  public io.fabric8.openshift.api.model.PowerVSServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.PowerVSServiceEndpoint buildMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder> predicate) {
    for (io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder> predicate) {
    for (io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceEndpoints(java.util.List<io.fabric8.openshift.api.model.PowerVSServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").removeAll(this.serviceEndpoints);}
    if (serviceEndpoints != null) {this.serviceEndpoints = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.PowerVSServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
  }
  public A withServiceEndpoints(io.fabric8.openshift.api.model.PowerVSServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {this.serviceEndpoints.clear();}
    if (serviceEndpoints != null) {for (io.fabric8.openshift.api.model.PowerVSServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
  }
  public java.lang.Boolean hasServiceEndpoints() {
    return serviceEndpoints != null && !serviceEndpoints.isEmpty();
  }
  public A addNewServiceEndpoint(java.lang.String name,java.lang.String url) {
    return (A)addToServiceEndpoints(new PowerVSServiceEndpoint(name, url));
  }
  public io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new io.fabric8.openshift.api.model.PowerVSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(io.fabric8.openshift.api.model.PowerVSServiceEndpoint item) {
    return new io.fabric8.openshift.api.model.PowerVSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(java.lang.Integer index,io.fabric8.openshift.api.model.PowerVSServiceEndpoint item) {
    return new io.fabric8.openshift.api.model.PowerVSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> editServiceEndpoint(java.lang.Integer index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  public io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public java.lang.String getZone() {
    return this.zone;
  }
  public A withZone(java.lang.String zone) {
    this.zone=zone; return (A) this;
  }
  public java.lang.Boolean hasZone() {
    return this.zone != null;
  }
  
  /**
   * Method is deprecated. use withZone instead.
   */
  @java.lang.Deprecated
  public A withNewZone(java.lang.String arg0) {
    return (A)withZone(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PowerVSPlatformStatusFluentImpl that = (PowerVSPlatformStatusFluentImpl) o;
    if (cisInstanceCRN != null ? !cisInstanceCRN.equals(that.cisInstanceCRN) :that.cisInstanceCRN != null) return false;
    if (region != null ? !region.equals(that.region) :that.region != null) return false;
    if (serviceEndpoints != null ? !serviceEndpoints.equals(that.serviceEndpoints) :that.serviceEndpoints != null) return false;
    if (zone != null ? !zone.equals(that.zone) :that.zone != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cisInstanceCRN,  region,  serviceEndpoints,  zone,  additionalProperties,  super.hashCode());
  }
  public class ServiceEndpointsNestedImpl<N> extends io.fabric8.openshift.api.model.PowerVSServiceEndpointFluentImpl<io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<N>> implements io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent.ServiceEndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceEndpointsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.PowerVSServiceEndpoint item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder(this, item);
    }
    ServiceEndpointsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder(this);
    }
    io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PowerVSPlatformStatusFluentImpl.this.setToServiceEndpoints(index,builder.build());
    }
    public N endServiceEndpoint() {
      return and();
    }
    
  }
  
}