package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PowerVSPlatformStatusBuilder extends io.fabric8.openshift.api.model.PowerVSPlatformStatusFluentImpl<io.fabric8.openshift.api.model.PowerVSPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.PowerVSPlatformStatus,io.fabric8.openshift.api.model.PowerVSPlatformStatusBuilder>{
  public PowerVSPlatformStatusBuilder() {
    this(false);
  }
  public PowerVSPlatformStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new PowerVSPlatformStatus(), validationEnabled);
  }
  public PowerVSPlatformStatusBuilder(io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PowerVSPlatformStatusBuilder(io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PowerVSPlatformStatus(), validationEnabled);
  }
  public PowerVSPlatformStatusBuilder(io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.PowerVSPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public PowerVSPlatformStatusBuilder(io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.PowerVSPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCisInstanceCRN(instance.getCisInstanceCRN()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
    fluent.withZone(instance.getZone()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PowerVSPlatformStatusBuilder(io.fabric8.openshift.api.model.PowerVSPlatformStatus instance) {
    this(instance,false);
  }
  public PowerVSPlatformStatusBuilder(io.fabric8.openshift.api.model.PowerVSPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCisInstanceCRN(instance.getCisInstanceCRN()); 
    this.withRegion(instance.getRegion()); 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withZone(instance.getZone()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.PowerVSPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.PowerVSPlatformStatus build() {
    PowerVSPlatformStatus buildable = new PowerVSPlatformStatus(fluent.getCisInstanceCRN(),fluent.getRegion(),fluent.getServiceEndpoints(),fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PowerVSPlatformStatusBuilder that = (PowerVSPlatformStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}