package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ImageSignatureFluentImpl<A extends io.fabric8.openshift.api.model.ImageSignatureFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ImageSignatureFluent<A>{
  public ImageSignatureFluentImpl() {
  }
  public ImageSignatureFluentImpl(io.fabric8.openshift.api.model.ImageSignature instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withContent(instance.getContent()); 
    this.withCreated(instance.getCreated()); 
    this.withImageIdentity(instance.getImageIdentity()); 
    this.withIssuedBy(instance.getIssuedBy()); 
    this.withIssuedTo(instance.getIssuedTo()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSignedClaims(instance.getSignedClaims()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.util.List<io.fabric8.openshift.api.model.SignatureConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.openshift.api.model.SignatureConditionBuilder>();
  private java.lang.String content;
  private java.lang.String created;
  private java.lang.String imageIdentity;
  private io.fabric8.openshift.api.model.SignatureIssuerBuilder issuedBy;
  private io.fabric8.openshift.api.model.SignatureSubjectBuilder issuedTo;
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.util.Map<java.lang.String,java.lang.String> signedClaims;
  private java.lang.String type;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.SignatureCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.SignatureConditionBuilder>();}
    io.fabric8.openshift.api.model.SignatureConditionBuilder builder = new io.fabric8.openshift.api.model.SignatureConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.SignatureCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.SignatureConditionBuilder>();}
    io.fabric8.openshift.api.model.SignatureConditionBuilder builder = new io.fabric8.openshift.api.model.SignatureConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.SignatureCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.SignatureConditionBuilder>();}
    for (io.fabric8.openshift.api.model.SignatureCondition item : items) {io.fabric8.openshift.api.model.SignatureConditionBuilder builder = new io.fabric8.openshift.api.model.SignatureConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.openshift.api.model.SignatureCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.SignatureConditionBuilder>();}
    for (io.fabric8.openshift.api.model.SignatureCondition item : items) {io.fabric8.openshift.api.model.SignatureConditionBuilder builder = new io.fabric8.openshift.api.model.SignatureConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.SignatureCondition... items) {
    for (io.fabric8.openshift.api.model.SignatureCondition item : items) {io.fabric8.openshift.api.model.SignatureConditionBuilder builder = new io.fabric8.openshift.api.model.SignatureConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.SignatureCondition> items) {
    for (io.fabric8.openshift.api.model.SignatureCondition item : items) {io.fabric8.openshift.api.model.SignatureConditionBuilder builder = new io.fabric8.openshift.api.model.SignatureConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.openshift.api.model.SignatureConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.SignatureConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.SignatureConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.SignatureCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.openshift.api.model.SignatureCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.openshift.api.model.SignatureCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.SignatureCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.SignatureCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.SignatureCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.SignatureConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.SignatureConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.SignatureConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.SignatureConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.SignatureCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.SignatureCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.SignatureCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.SignatureCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.SignatureCondition item) {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.SignatureCondition item) {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.SignatureConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.String getContent() {
    return this.content;
  }
  public A withContent(java.lang.String content) {
    this.content=content; return (A) this;
  }
  public java.lang.Boolean hasContent() {
    return this.content != null;
  }
  
  /**
   * Method is deprecated. use withContent instead.
   */
  @java.lang.Deprecated
  public A withNewContent(java.lang.String arg0) {
    return (A)withContent(new String(arg0));
  }
  public java.lang.String getCreated() {
    return this.created;
  }
  public A withCreated(java.lang.String created) {
    this.created=created; return (A) this;
  }
  public java.lang.Boolean hasCreated() {
    return this.created != null;
  }
  
  /**
   * Method is deprecated. use withCreated instead.
   */
  @java.lang.Deprecated
  public A withNewCreated(java.lang.String arg0) {
    return (A)withCreated(new String(arg0));
  }
  public java.lang.String getImageIdentity() {
    return this.imageIdentity;
  }
  public A withImageIdentity(java.lang.String imageIdentity) {
    this.imageIdentity=imageIdentity; return (A) this;
  }
  public java.lang.Boolean hasImageIdentity() {
    return this.imageIdentity != null;
  }
  
  /**
   * Method is deprecated. use withImageIdentity instead.
   */
  @java.lang.Deprecated
  public A withNewImageIdentity(java.lang.String arg0) {
    return (A)withImageIdentity(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildIssuedBy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.SignatureIssuer getIssuedBy() {
    return this.issuedBy!=null?this.issuedBy.build():null;
  }
  public io.fabric8.openshift.api.model.SignatureIssuer buildIssuedBy() {
    return this.issuedBy!=null?this.issuedBy.build():null;
  }
  public A withIssuedBy(io.fabric8.openshift.api.model.SignatureIssuer issuedBy) {
    _visitables.get("issuedBy").remove(this.issuedBy);
    if (issuedBy!=null){ this.issuedBy= new io.fabric8.openshift.api.model.SignatureIssuerBuilder(issuedBy); _visitables.get("issuedBy").add(this.issuedBy);} return (A) this;
  }
  public java.lang.Boolean hasIssuedBy() {
    return this.issuedBy != null;
  }
  public A withNewIssuedBy(java.lang.String commonName,java.lang.String organization) {
    return (A)withIssuedBy(new SignatureIssuer(commonName, organization));
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> withNewIssuedBy() {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.IssuedByNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> withNewIssuedByLike(io.fabric8.openshift.api.model.SignatureIssuer item) {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.IssuedByNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> editIssuedBy() {
    return withNewIssuedByLike(getIssuedBy());
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedBy() {
    return withNewIssuedByLike(getIssuedBy() != null ? getIssuedBy(): new io.fabric8.openshift.api.model.SignatureIssuerBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedByLike(io.fabric8.openshift.api.model.SignatureIssuer item) {
    return withNewIssuedByLike(getIssuedBy() != null ? getIssuedBy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIssuedTo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.SignatureSubject getIssuedTo() {
    return this.issuedTo!=null?this.issuedTo.build():null;
  }
  public io.fabric8.openshift.api.model.SignatureSubject buildIssuedTo() {
    return this.issuedTo!=null?this.issuedTo.build():null;
  }
  public A withIssuedTo(io.fabric8.openshift.api.model.SignatureSubject issuedTo) {
    _visitables.get("issuedTo").remove(this.issuedTo);
    if (issuedTo!=null){ this.issuedTo= new io.fabric8.openshift.api.model.SignatureSubjectBuilder(issuedTo); _visitables.get("issuedTo").add(this.issuedTo);} return (A) this;
  }
  public java.lang.Boolean hasIssuedTo() {
    return this.issuedTo != null;
  }
  public A withNewIssuedTo(java.lang.String commonName,java.lang.String organization,java.lang.String publicKeyID) {
    return (A)withIssuedTo(new SignatureSubject(commonName, organization, publicKeyID));
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> withNewIssuedTo() {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.IssuedToNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> withNewIssuedToLike(io.fabric8.openshift.api.model.SignatureSubject item) {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.IssuedToNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> editIssuedTo() {
    return withNewIssuedToLike(getIssuedTo());
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedTo() {
    return withNewIssuedToLike(getIssuedTo() != null ? getIssuedTo(): new io.fabric8.openshift.api.model.SignatureSubjectBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedToLike(io.fabric8.openshift.api.model.SignatureSubject item) {
    return withNewIssuedToLike(getIssuedTo() != null ? getIssuedTo(): item);
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.ImageSignatureFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToSignedClaims(java.lang.String key,java.lang.String value) {
    if(this.signedClaims == null && key != null && value != null) { this.signedClaims = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.signedClaims.put(key, value);} return (A)this;
  }
  public A addToSignedClaims(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.signedClaims == null && map != null) { this.signedClaims = new java.util.LinkedHashMap(); }
    if(map != null) { this.signedClaims.putAll(map);} return (A)this;
  }
  public A removeFromSignedClaims(java.lang.String key) {
    if(this.signedClaims == null) { return (A) this; }
    if(key != null && this.signedClaims != null) {this.signedClaims.remove(key);} return (A)this;
  }
  public A removeFromSignedClaims(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.signedClaims == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.signedClaims != null){this.signedClaims.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getSignedClaims() {
    return this.signedClaims;
  }
  public <K,V>A withSignedClaims(java.util.Map<java.lang.String,java.lang.String> signedClaims) {
    if (signedClaims == null) { this.signedClaims =  null;} else {this.signedClaims = new java.util.LinkedHashMap(signedClaims);} return (A) this;
  }
  public java.lang.Boolean hasSignedClaims() {
    return this.signedClaims != null;
  }
  public java.lang.String getType() {
    return this.type;
  }
  public A withType(java.lang.String type) {
    this.type=type; return (A) this;
  }
  public java.lang.Boolean hasType() {
    return this.type != null;
  }
  
  /**
   * Method is deprecated. use withType instead.
   */
  @java.lang.Deprecated
  public A withNewType(java.lang.String arg0) {
    return (A)withType(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageSignatureFluentImpl that = (ImageSignatureFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (content != null ? !content.equals(that.content) :that.content != null) return false;
    if (created != null ? !created.equals(that.created) :that.created != null) return false;
    if (imageIdentity != null ? !imageIdentity.equals(that.imageIdentity) :that.imageIdentity != null) return false;
    if (issuedBy != null ? !issuedBy.equals(that.issuedBy) :that.issuedBy != null) return false;
    if (issuedTo != null ? !issuedTo.equals(that.issuedTo) :that.issuedTo != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (signedClaims != null ? !signedClaims.equals(that.signedClaims) :that.signedClaims != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  conditions,  content,  created,  imageIdentity,  issuedBy,  issuedTo,  kind,  metadata,  signedClaims,  type,  additionalProperties,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.SignatureConditionFluentImpl<io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.ImageSignatureFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.SignatureCondition item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.SignatureConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.SignatureConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.SignatureConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ImageSignatureFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class IssuedByNestedImpl<N> extends io.fabric8.openshift.api.model.SignatureIssuerFluentImpl<io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<N>> implements io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedByNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IssuedByNestedImpl(io.fabric8.openshift.api.model.SignatureIssuer item) {
      this.builder = new io.fabric8.openshift.api.model.SignatureIssuerBuilder(this, item);
    }
    IssuedByNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SignatureIssuerBuilder(this);
    }
    io.fabric8.openshift.api.model.SignatureIssuerBuilder builder;
    public N and() {
      return (N) ImageSignatureFluentImpl.this.withIssuedBy(builder.build());
    }
    public N endIssuedBy() {
      return and();
    }
    
  }
  public class IssuedToNestedImpl<N> extends io.fabric8.openshift.api.model.SignatureSubjectFluentImpl<io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<N>> implements io.fabric8.openshift.api.model.ImageSignatureFluent.IssuedToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IssuedToNestedImpl(io.fabric8.openshift.api.model.SignatureSubject item) {
      this.builder = new io.fabric8.openshift.api.model.SignatureSubjectBuilder(this, item);
    }
    IssuedToNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SignatureSubjectBuilder(this);
    }
    io.fabric8.openshift.api.model.SignatureSubjectBuilder builder;
    public N and() {
      return (N) ImageSignatureFluentImpl.this.withIssuedTo(builder.build());
    }
    public N endIssuedTo() {
      return and();
    }
    
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ImageSignatureFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageSignatureFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}