package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import io.fabric8.openshift.api.model.runtime.RawExtension;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ImageFluentImpl<A extends io.fabric8.openshift.api.model.ImageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ImageFluent<A>{
  public ImageFluentImpl() {
  }
  public ImageFluentImpl(io.fabric8.openshift.api.model.Image instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withDockerImageConfig(instance.getDockerImageConfig()); 
    this.withDockerImageLayers(instance.getDockerImageLayers()); 
    this.withDockerImageManifest(instance.getDockerImageManifest()); 
    this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType()); 
    this.withDockerImageMetadata(instance.getDockerImageMetadata()); 
    this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion()); 
    this.withDockerImageReference(instance.getDockerImageReference()); 
    this.withDockerImageSignatures(instance.getDockerImageSignatures()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSignatures(instance.getSignatures()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.lang.String dockerImageConfig;
  private java.util.List<io.fabric8.openshift.api.model.ImageLayerBuilder> dockerImageLayers =  new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLayerBuilder>();
  private java.lang.String dockerImageManifest;
  private java.lang.String dockerImageManifestMediaType;
  private io.fabric8.openshift.api.model.runtime.RawExtensionBuilder dockerImageMetadata;
  private java.lang.String dockerImageMetadataVersion;
  private java.lang.String dockerImageReference;
  private java.util.List<java.lang.String> dockerImageSignatures = new java.util.ArrayList<java.lang.String>();
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.util.List<io.fabric8.openshift.api.model.ImageSignatureBuilder> signatures =  new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSignatureBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public java.lang.String getDockerImageConfig() {
    return this.dockerImageConfig;
  }
  public A withDockerImageConfig(java.lang.String dockerImageConfig) {
    this.dockerImageConfig=dockerImageConfig; return (A) this;
  }
  public java.lang.Boolean hasDockerImageConfig() {
    return this.dockerImageConfig != null;
  }
  
  /**
   * Method is deprecated. use withDockerImageConfig instead.
   */
  @java.lang.Deprecated
  public A withNewDockerImageConfig(java.lang.String arg0) {
    return (A)withDockerImageConfig(new String(arg0));
  }
  public A addToDockerImageLayers(java.lang.Integer index,io.fabric8.openshift.api.model.ImageLayer item) {
    if (this.dockerImageLayers == null) {this.dockerImageLayers = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLayerBuilder>();}
    io.fabric8.openshift.api.model.ImageLayerBuilder builder = new io.fabric8.openshift.api.model.ImageLayerBuilder(item);_visitables.get("dockerImageLayers").add(index >= 0 ? index : _visitables.get("dockerImageLayers").size(), builder);this.dockerImageLayers.add(index >= 0 ? index : dockerImageLayers.size(), builder); return (A)this;
  }
  public A setToDockerImageLayers(java.lang.Integer index,io.fabric8.openshift.api.model.ImageLayer item) {
    if (this.dockerImageLayers == null) {this.dockerImageLayers = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLayerBuilder>();}
    io.fabric8.openshift.api.model.ImageLayerBuilder builder = new io.fabric8.openshift.api.model.ImageLayerBuilder(item);
    if (index < 0 || index >= _visitables.get("dockerImageLayers").size()) { _visitables.get("dockerImageLayers").add(builder); } else { _visitables.get("dockerImageLayers").set(index, builder);}
    if (index < 0 || index >= dockerImageLayers.size()) { dockerImageLayers.add(builder); } else { dockerImageLayers.set(index, builder);}
     return (A)this;
  }
  public A addToDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... items) {
    if (this.dockerImageLayers == null) {this.dockerImageLayers = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLayerBuilder>();}
    for (io.fabric8.openshift.api.model.ImageLayer item : items) {io.fabric8.openshift.api.model.ImageLayerBuilder builder = new io.fabric8.openshift.api.model.ImageLayerBuilder(item);_visitables.get("dockerImageLayers").add(builder);this.dockerImageLayers.add(builder);} return (A)this;
  }
  public A addAllToDockerImageLayers(java.util.Collection<io.fabric8.openshift.api.model.ImageLayer> items) {
    if (this.dockerImageLayers == null) {this.dockerImageLayers = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageLayerBuilder>();}
    for (io.fabric8.openshift.api.model.ImageLayer item : items) {io.fabric8.openshift.api.model.ImageLayerBuilder builder = new io.fabric8.openshift.api.model.ImageLayerBuilder(item);_visitables.get("dockerImageLayers").add(builder);this.dockerImageLayers.add(builder);} return (A)this;
  }
  public A removeFromDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... items) {
    for (io.fabric8.openshift.api.model.ImageLayer item : items) {io.fabric8.openshift.api.model.ImageLayerBuilder builder = new io.fabric8.openshift.api.model.ImageLayerBuilder(item);_visitables.get("dockerImageLayers").remove(builder);if (this.dockerImageLayers != null) {this.dockerImageLayers.remove(builder);}} return (A)this;
  }
  public A removeAllFromDockerImageLayers(java.util.Collection<io.fabric8.openshift.api.model.ImageLayer> items) {
    for (io.fabric8.openshift.api.model.ImageLayer item : items) {io.fabric8.openshift.api.model.ImageLayerBuilder builder = new io.fabric8.openshift.api.model.ImageLayerBuilder(item);_visitables.get("dockerImageLayers").remove(builder);if (this.dockerImageLayers != null) {this.dockerImageLayers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDockerImageLayers(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLayerBuilder> predicate) {
    if (dockerImageLayers == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ImageLayerBuilder> each = dockerImageLayers.iterator();
    final List visitables = _visitables.get("dockerImageLayers");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ImageLayerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDockerImageLayers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ImageLayer> getDockerImageLayers() {
    return build(dockerImageLayers);
  }
  public java.util.List<io.fabric8.openshift.api.model.ImageLayer> buildDockerImageLayers() {
    return build(dockerImageLayers);
  }
  public io.fabric8.openshift.api.model.ImageLayer buildDockerImageLayer(java.lang.Integer index) {
    return this.dockerImageLayers.get(index).build();
  }
  public io.fabric8.openshift.api.model.ImageLayer buildFirstDockerImageLayer() {
    return this.dockerImageLayers.get(0).build();
  }
  public io.fabric8.openshift.api.model.ImageLayer buildLastDockerImageLayer() {
    return this.dockerImageLayers.get(dockerImageLayers.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ImageLayer buildMatchingDockerImageLayer(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLayerBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageLayerBuilder item: dockerImageLayers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingDockerImageLayer(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLayerBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageLayerBuilder item: dockerImageLayers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDockerImageLayers(java.util.List<io.fabric8.openshift.api.model.ImageLayer> dockerImageLayers) {
    if (this.dockerImageLayers != null) { _visitables.get("dockerImageLayers").removeAll(this.dockerImageLayers);}
    if (dockerImageLayers != null) {this.dockerImageLayers = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ImageLayer item : dockerImageLayers){this.addToDockerImageLayers(item);}} else { this.dockerImageLayers = null;} return (A) this;
  }
  public A withDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... dockerImageLayers) {
    if (this.dockerImageLayers != null) {this.dockerImageLayers.clear();}
    if (dockerImageLayers != null) {for (io.fabric8.openshift.api.model.ImageLayer item :dockerImageLayers){ this.addToDockerImageLayers(item);}} return (A) this;
  }
  public java.lang.Boolean hasDockerImageLayers() {
    return dockerImageLayers != null && !dockerImageLayers.isEmpty();
  }
  public A addNewDockerImageLayer(java.lang.String mediaType,java.lang.String name,java.lang.Long size) {
    return (A)addToDockerImageLayers(new ImageLayer(mediaType, name, size));
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer() {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.DockerImageLayersNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(io.fabric8.openshift.api.model.ImageLayer item) {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.DockerImageLayersNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> setNewDockerImageLayerLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageLayer item) {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.DockerImageLayersNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> editDockerImageLayer(java.lang.Integer index) {
    if (dockerImageLayers.size() <= index) throw new RuntimeException("Can't edit dockerImageLayers. Index exceeds size.");
    return setNewDockerImageLayerLike(index, buildDockerImageLayer(index));
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> editFirstDockerImageLayer() {
    if (dockerImageLayers.size() == 0) throw new RuntimeException("Can't edit first dockerImageLayers. The list is empty.");
    return setNewDockerImageLayerLike(0, buildDockerImageLayer(0));
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> editLastDockerImageLayer() {
    int index = dockerImageLayers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dockerImageLayers. The list is empty.");
    return setNewDockerImageLayerLike(index, buildDockerImageLayer(index));
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> editMatchingDockerImageLayer(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLayerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dockerImageLayers.size();i++) { 
    if (predicate.test(dockerImageLayers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dockerImageLayers. No match found.");
    return setNewDockerImageLayerLike(index, buildDockerImageLayer(index));
  }
  public java.lang.String getDockerImageManifest() {
    return this.dockerImageManifest;
  }
  public A withDockerImageManifest(java.lang.String dockerImageManifest) {
    this.dockerImageManifest=dockerImageManifest; return (A) this;
  }
  public java.lang.Boolean hasDockerImageManifest() {
    return this.dockerImageManifest != null;
  }
  
  /**
   * Method is deprecated. use withDockerImageManifest instead.
   */
  @java.lang.Deprecated
  public A withNewDockerImageManifest(java.lang.String arg0) {
    return (A)withDockerImageManifest(new String(arg0));
  }
  public java.lang.String getDockerImageManifestMediaType() {
    return this.dockerImageManifestMediaType;
  }
  public A withDockerImageManifestMediaType(java.lang.String dockerImageManifestMediaType) {
    this.dockerImageManifestMediaType=dockerImageManifestMediaType; return (A) this;
  }
  public java.lang.Boolean hasDockerImageManifestMediaType() {
    return this.dockerImageManifestMediaType != null;
  }
  
  /**
   * Method is deprecated. use withDockerImageManifestMediaType instead.
   */
  @java.lang.Deprecated
  public A withNewDockerImageManifestMediaType(java.lang.String arg0) {
    return (A)withDockerImageManifestMediaType(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildDockerImageMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.runtime.RawExtension getDockerImageMetadata() {
    return this.dockerImageMetadata!=null?this.dockerImageMetadata.build():null;
  }
  public io.fabric8.openshift.api.model.runtime.RawExtension buildDockerImageMetadata() {
    return this.dockerImageMetadata!=null?this.dockerImageMetadata.build():null;
  }
  public A withDockerImageMetadata(io.fabric8.openshift.api.model.runtime.RawExtension dockerImageMetadata) {
    _visitables.get("dockerImageMetadata").remove(this.dockerImageMetadata);
    if (dockerImageMetadata!=null){ this.dockerImageMetadata= new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(dockerImageMetadata); _visitables.get("dockerImageMetadata").add(this.dockerImageMetadata);} return (A) this;
  }
  public java.lang.Boolean hasDockerImageMetadata() {
    return this.dockerImageMetadata != null;
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadata() {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.DockerImageMetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadataLike(io.fabric8.openshift.api.model.runtime.RawExtension item) {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.DockerImageMetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> editDockerImageMetadata() {
    return withNewDockerImageMetadataLike(getDockerImageMetadata());
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadata() {
    return withNewDockerImageMetadataLike(getDockerImageMetadata() != null ? getDockerImageMetadata(): new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadataLike(io.fabric8.openshift.api.model.runtime.RawExtension item) {
    return withNewDockerImageMetadataLike(getDockerImageMetadata() != null ? getDockerImageMetadata(): item);
  }
  public java.lang.String getDockerImageMetadataVersion() {
    return this.dockerImageMetadataVersion;
  }
  public A withDockerImageMetadataVersion(java.lang.String dockerImageMetadataVersion) {
    this.dockerImageMetadataVersion=dockerImageMetadataVersion; return (A) this;
  }
  public java.lang.Boolean hasDockerImageMetadataVersion() {
    return this.dockerImageMetadataVersion != null;
  }
  
  /**
   * Method is deprecated. use withDockerImageMetadataVersion instead.
   */
  @java.lang.Deprecated
  public A withNewDockerImageMetadataVersion(java.lang.String arg0) {
    return (A)withDockerImageMetadataVersion(new String(arg0));
  }
  public java.lang.String getDockerImageReference() {
    return this.dockerImageReference;
  }
  public A withDockerImageReference(java.lang.String dockerImageReference) {
    this.dockerImageReference=dockerImageReference; return (A) this;
  }
  public java.lang.Boolean hasDockerImageReference() {
    return this.dockerImageReference != null;
  }
  
  /**
   * Method is deprecated. use withDockerImageReference instead.
   */
  @java.lang.Deprecated
  public A withNewDockerImageReference(java.lang.String arg0) {
    return (A)withDockerImageReference(new String(arg0));
  }
  public A addToDockerImageSignatures(java.lang.Integer index,java.lang.String item) {
    if (this.dockerImageSignatures == null) {this.dockerImageSignatures = new java.util.ArrayList<java.lang.String>();}
    this.dockerImageSignatures.add(index, item);
    return (A)this;
  }
  public A setToDockerImageSignatures(java.lang.Integer index,java.lang.String item) {
    if (this.dockerImageSignatures == null) {this.dockerImageSignatures = new java.util.ArrayList<java.lang.String>();}
    this.dockerImageSignatures.set(index, item); return (A)this;
  }
  public A addToDockerImageSignatures(java.lang.String... items) {
    if (this.dockerImageSignatures == null) {this.dockerImageSignatures = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dockerImageSignatures.add(item);} return (A)this;
  }
  public A addAllToDockerImageSignatures(java.util.Collection<java.lang.String> items) {
    if (this.dockerImageSignatures == null) {this.dockerImageSignatures = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dockerImageSignatures.add(item);} return (A)this;
  }
  public A removeFromDockerImageSignatures(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.dockerImageSignatures!= null){ this.dockerImageSignatures.remove(item);}} return (A)this;
  }
  public A removeAllFromDockerImageSignatures(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.dockerImageSignatures!= null){ this.dockerImageSignatures.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getDockerImageSignatures() {
    return this.dockerImageSignatures;
  }
  public java.lang.String getDockerImageSignature(java.lang.Integer index) {
    return this.dockerImageSignatures.get(index);
  }
  public java.lang.String getFirstDockerImageSignature() {
    return this.dockerImageSignatures.get(0);
  }
  public java.lang.String getLastDockerImageSignature() {
    return this.dockerImageSignatures.get(dockerImageSignatures.size() - 1);
  }
  public java.lang.String getMatchingDockerImageSignature(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dockerImageSignatures) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingDockerImageSignature(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dockerImageSignatures) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDockerImageSignatures(java.util.List<java.lang.String> dockerImageSignatures) {
    if (dockerImageSignatures != null) {this.dockerImageSignatures = new java.util.ArrayList(); for (java.lang.String item : dockerImageSignatures){this.addToDockerImageSignatures(item);}} else { this.dockerImageSignatures = null;} return (A) this;
  }
  public A withDockerImageSignatures(java.lang.String... dockerImageSignatures) {
    if (this.dockerImageSignatures != null) {this.dockerImageSignatures.clear();}
    if (dockerImageSignatures != null) {for (java.lang.String item :dockerImageSignatures){ this.addToDockerImageSignatures(item);}} return (A) this;
  }
  public java.lang.Boolean hasDockerImageSignatures() {
    return dockerImageSignatures != null && !dockerImageSignatures.isEmpty();
  }
  public A addNewDockerImageSignature(java.lang.String arg0) {
    return (A)addToDockerImageSignatures(new String(arg0));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToSignatures(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item) {
    if (this.signatures == null) {this.signatures = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSignatureBuilder>();}
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("signatures").add(index >= 0 ? index : _visitables.get("signatures").size(), builder);this.signatures.add(index >= 0 ? index : signatures.size(), builder); return (A)this;
  }
  public A setToSignatures(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item) {
    if (this.signatures == null) {this.signatures = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSignatureBuilder>();}
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);
    if (index < 0 || index >= _visitables.get("signatures").size()) { _visitables.get("signatures").add(builder); } else { _visitables.get("signatures").set(index, builder);}
    if (index < 0 || index >= signatures.size()) { signatures.add(builder); } else { signatures.set(index, builder);}
     return (A)this;
  }
  public A addToSignatures(io.fabric8.openshift.api.model.ImageSignature... items) {
    if (this.signatures == null) {this.signatures = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSignatureBuilder>();}
    for (io.fabric8.openshift.api.model.ImageSignature item : items) {io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("signatures").add(builder);this.signatures.add(builder);} return (A)this;
  }
  public A addAllToSignatures(java.util.Collection<io.fabric8.openshift.api.model.ImageSignature> items) {
    if (this.signatures == null) {this.signatures = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSignatureBuilder>();}
    for (io.fabric8.openshift.api.model.ImageSignature item : items) {io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("signatures").add(builder);this.signatures.add(builder);} return (A)this;
  }
  public A removeFromSignatures(io.fabric8.openshift.api.model.ImageSignature... items) {
    for (io.fabric8.openshift.api.model.ImageSignature item : items) {io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("signatures").remove(builder);if (this.signatures != null) {this.signatures.remove(builder);}} return (A)this;
  }
  public A removeAllFromSignatures(java.util.Collection<io.fabric8.openshift.api.model.ImageSignature> items) {
    for (io.fabric8.openshift.api.model.ImageSignature item : items) {io.fabric8.openshift.api.model.ImageSignatureBuilder builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(item);_visitables.get("signatures").remove(builder);if (this.signatures != null) {this.signatures.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSignatures(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSignatureBuilder> predicate) {
    if (signatures == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ImageSignatureBuilder> each = signatures.iterator();
    final List visitables = _visitables.get("signatures");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ImageSignatureBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSignatures instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ImageSignature> getSignatures() {
    return build(signatures);
  }
  public java.util.List<io.fabric8.openshift.api.model.ImageSignature> buildSignatures() {
    return build(signatures);
  }
  public io.fabric8.openshift.api.model.ImageSignature buildSignature(java.lang.Integer index) {
    return this.signatures.get(index).build();
  }
  public io.fabric8.openshift.api.model.ImageSignature buildFirstSignature() {
    return this.signatures.get(0).build();
  }
  public io.fabric8.openshift.api.model.ImageSignature buildLastSignature() {
    return this.signatures.get(signatures.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ImageSignature buildMatchingSignature(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSignatureBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageSignatureBuilder item: signatures) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingSignature(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSignatureBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageSignatureBuilder item: signatures) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSignatures(java.util.List<io.fabric8.openshift.api.model.ImageSignature> signatures) {
    if (this.signatures != null) { _visitables.get("signatures").removeAll(this.signatures);}
    if (signatures != null) {this.signatures = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ImageSignature item : signatures){this.addToSignatures(item);}} else { this.signatures = null;} return (A) this;
  }
  public A withSignatures(io.fabric8.openshift.api.model.ImageSignature... signatures) {
    if (this.signatures != null) {this.signatures.clear();}
    if (signatures != null) {for (io.fabric8.openshift.api.model.ImageSignature item :signatures){ this.addToSignatures(item);}} return (A) this;
  }
  public java.lang.Boolean hasSignatures() {
    return signatures != null && !signatures.isEmpty();
  }
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> addNewSignature() {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.SignaturesNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> addNewSignatureLike(io.fabric8.openshift.api.model.ImageSignature item) {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.SignaturesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> setNewSignatureLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item) {
    return new io.fabric8.openshift.api.model.ImageFluentImpl.SignaturesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> editSignature(java.lang.Integer index) {
    if (signatures.size() <= index) throw new RuntimeException("Can't edit signatures. Index exceeds size.");
    return setNewSignatureLike(index, buildSignature(index));
  }
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> editFirstSignature() {
    if (signatures.size() == 0) throw new RuntimeException("Can't edit first signatures. The list is empty.");
    return setNewSignatureLike(0, buildSignature(0));
  }
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> editLastSignature() {
    int index = signatures.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last signatures. The list is empty.");
    return setNewSignatureLike(index, buildSignature(index));
  }
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> editMatchingSignature(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSignatureBuilder> predicate) {
    int index = -1;
    for (int i=0;i<signatures.size();i++) { 
    if (predicate.test(signatures.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching signatures. No match found.");
    return setNewSignatureLike(index, buildSignature(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageFluentImpl that = (ImageFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (dockerImageConfig != null ? !dockerImageConfig.equals(that.dockerImageConfig) :that.dockerImageConfig != null) return false;
    if (dockerImageLayers != null ? !dockerImageLayers.equals(that.dockerImageLayers) :that.dockerImageLayers != null) return false;
    if (dockerImageManifest != null ? !dockerImageManifest.equals(that.dockerImageManifest) :that.dockerImageManifest != null) return false;
    if (dockerImageManifestMediaType != null ? !dockerImageManifestMediaType.equals(that.dockerImageManifestMediaType) :that.dockerImageManifestMediaType != null) return false;
    if (dockerImageMetadata != null ? !dockerImageMetadata.equals(that.dockerImageMetadata) :that.dockerImageMetadata != null) return false;
    if (dockerImageMetadataVersion != null ? !dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) :that.dockerImageMetadataVersion != null) return false;
    if (dockerImageReference != null ? !dockerImageReference.equals(that.dockerImageReference) :that.dockerImageReference != null) return false;
    if (dockerImageSignatures != null ? !dockerImageSignatures.equals(that.dockerImageSignatures) :that.dockerImageSignatures != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (signatures != null ? !signatures.equals(that.signatures) :that.signatures != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  dockerImageConfig,  dockerImageLayers,  dockerImageManifest,  dockerImageManifestMediaType,  dockerImageMetadata,  dockerImageMetadataVersion,  dockerImageReference,  dockerImageSignatures,  kind,  metadata,  signatures,  additionalProperties,  super.hashCode());
  }
  public class DockerImageLayersNestedImpl<N> extends io.fabric8.openshift.api.model.ImageLayerFluentImpl<io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<N>> implements io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DockerImageLayersNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageLayer item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageLayerBuilder(this, item);
    }
    DockerImageLayersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageLayerBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageLayerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ImageFluentImpl.this.setToDockerImageLayers(index,builder.build());
    }
    public N endDockerImageLayer() {
      return and();
    }
    
  }
  public class DockerImageMetadataNestedImpl<N> extends io.fabric8.openshift.api.model.runtime.RawExtensionFluentImpl<io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<N>> implements io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DockerImageMetadataNestedImpl(io.fabric8.openshift.api.model.runtime.RawExtension item) {
      this.builder = new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(this, item);
    }
    DockerImageMetadataNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(this);
    }
    io.fabric8.openshift.api.model.runtime.RawExtensionBuilder builder;
    public N and() {
      return (N) ImageFluentImpl.this.withDockerImageMetadata(builder.build());
    }
    public N endDockerImageMetadata() {
      return and();
    }
    
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.ImageFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ImageFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class SignaturesNestedImpl<N> extends io.fabric8.openshift.api.model.ImageSignatureFluentImpl<io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<N>> implements io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SignaturesNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(this, item);
    }
    SignaturesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ImageFluentImpl.this.setToSignatures(index,builder.build());
    }
    public N endSignature() {
      return and();
    }
    
  }
  
}