package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class IBMCloudPlatformStatusBuilder extends io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluentImpl<io.fabric8.openshift.api.model.IBMCloudPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.IBMCloudPlatformStatus,io.fabric8.openshift.api.model.IBMCloudPlatformStatusBuilder>{
  public IBMCloudPlatformStatusBuilder() {
    this(false);
  }
  public IBMCloudPlatformStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new IBMCloudPlatformStatus(), validationEnabled);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IBMCloudPlatformStatus(), validationEnabled);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.IBMCloudPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.IBMCloudPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCisInstanceCRN(instance.getCisInstanceCRN()); 
    fluent.withLocation(instance.getLocation()); 
    fluent.withProviderType(instance.getProviderType()); 
    fluent.withResourceGroupName(instance.getResourceGroupName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatus instance) {
    this(instance,false);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCisInstanceCRN(instance.getCisInstanceCRN()); 
    this.withLocation(instance.getLocation()); 
    this.withProviderType(instance.getProviderType()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.IBMCloudPlatformStatus build() {
    IBMCloudPlatformStatus buildable = new IBMCloudPlatformStatus(fluent.getCisInstanceCRN(),fluent.getLocation(),fluent.getProviderType(),fluent.getResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IBMCloudPlatformStatusBuilder that = (IBMCloudPlatformStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}