package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class GroupRestrictionFluentImpl<A extends io.fabric8.openshift.api.model.GroupRestrictionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.GroupRestrictionFluent<A>{
  public GroupRestrictionFluentImpl() {
  }
  public GroupRestrictionFluentImpl(io.fabric8.openshift.api.model.GroupRestriction instance) {
    this.withGroups(instance.getGroups()); 
    this.withLabels(instance.getLabels()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<java.lang.String> groups = new java.util.ArrayList<java.lang.String>();
  private java.util.List<io.fabric8.kubernetes.api.model.LabelSelectorBuilder> labels =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToGroups(java.lang.Integer index,java.lang.String item) {
    if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(java.lang.Integer index,java.lang.String item) {
    if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(java.util.Collection<java.lang.String> items) {
    if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getGroups() {
    return this.groups;
  }
  public java.lang.String getGroup(java.lang.Integer index) {
    return this.groups.get(index);
  }
  public java.lang.String getFirstGroup() {
    return this.groups.get(0);
  }
  public java.lang.String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public java.lang.String getMatchingGroup(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingGroup(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(java.util.List<java.lang.String> groups) {
    if (groups != null) {this.groups = new java.util.ArrayList(); for (java.lang.String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (java.lang.String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public java.lang.Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public A addNewGroup(java.lang.String arg0) {
    return (A)addToGroups(new String(arg0));
  }
  public A addToLabels(java.lang.Integer index,io.fabric8.kubernetes.api.model.LabelSelector item) {
    if (this.labels == null) {this.labels = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorBuilder>();}
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(item);_visitables.get("labels").add(index >= 0 ? index : _visitables.get("labels").size(), builder);this.labels.add(index >= 0 ? index : labels.size(), builder); return (A)this;
  }
  public A setToLabels(java.lang.Integer index,io.fabric8.kubernetes.api.model.LabelSelector item) {
    if (this.labels == null) {this.labels = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorBuilder>();}
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(item);
    if (index < 0 || index >= _visitables.get("labels").size()) { _visitables.get("labels").add(builder); } else { _visitables.get("labels").set(index, builder);}
    if (index < 0 || index >= labels.size()) { labels.add(builder); } else { labels.set(index, builder);}
     return (A)this;
  }
  public A addToLabels(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    if (this.labels == null) {this.labels = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorBuilder>();}
    for (io.fabric8.kubernetes.api.model.LabelSelector item : items) {io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  public A addAllToLabels(java.util.Collection<io.fabric8.kubernetes.api.model.LabelSelector> items) {
    if (this.labels == null) {this.labels = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorBuilder>();}
    for (io.fabric8.kubernetes.api.model.LabelSelector item : items) {io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  public A removeFromLabels(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    for (io.fabric8.kubernetes.api.model.LabelSelector item : items) {io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(item);_visitables.get("labels").remove(builder);if (this.labels != null) {this.labels.remove(builder);}} return (A)this;
  }
  public A removeAllFromLabels(java.util.Collection<io.fabric8.kubernetes.api.model.LabelSelector> items) {
    for (io.fabric8.kubernetes.api.model.LabelSelector item : items) {io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(item);_visitables.get("labels").remove(builder);if (this.labels != null) {this.labels.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLabels(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LabelSelectorBuilder> predicate) {
    if (labels == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.LabelSelectorBuilder> each = labels.iterator();
    final List visitables = _visitables.get("labels");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildLabels instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.LabelSelector> getLabels() {
    return build(labels);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.LabelSelector> buildLabels() {
    return build(labels);
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildLabel(java.lang.Integer index) {
    return this.labels.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildFirstLabel() {
    return this.labels.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildLastLabel() {
    return this.labels.get(labels.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildMatchingLabel(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LabelSelectorBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.LabelSelectorBuilder item: labels) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingLabel(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LabelSelectorBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.LabelSelectorBuilder item: labels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLabels(java.util.List<io.fabric8.kubernetes.api.model.LabelSelector> labels) {
    if (this.labels != null) { _visitables.get("labels").removeAll(this.labels);}
    if (labels != null) {this.labels = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.LabelSelector item : labels){this.addToLabels(item);}} else { this.labels = null;} return (A) this;
  }
  public A withLabels(io.fabric8.kubernetes.api.model.LabelSelector... labels) {
    if (this.labels != null) {this.labels.clear();}
    if (labels != null) {for (io.fabric8.kubernetes.api.model.LabelSelector item :labels){ this.addToLabels(item);}} return (A) this;
  }
  public java.lang.Boolean hasLabels() {
    return labels != null && !labels.isEmpty();
  }
  public io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<A> addNewLabel() {
    return new io.fabric8.openshift.api.model.GroupRestrictionFluentImpl.LabelsNestedImpl();
  }
  public io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<A> addNewLabelLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.openshift.api.model.GroupRestrictionFluentImpl.LabelsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<A> setNewLabelLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.openshift.api.model.GroupRestrictionFluentImpl.LabelsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<A> editLabel(java.lang.Integer index) {
    if (labels.size() <= index) throw new RuntimeException("Can't edit labels. Index exceeds size.");
    return setNewLabelLike(index, buildLabel(index));
  }
  public io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<A> editFirstLabel() {
    if (labels.size() == 0) throw new RuntimeException("Can't edit first labels. The list is empty.");
    return setNewLabelLike(0, buildLabel(0));
  }
  public io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<A> editLastLabel() {
    int index = labels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last labels. The list is empty.");
    return setNewLabelLike(index, buildLabel(index));
  }
  public io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<A> editMatchingLabel(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LabelSelectorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<labels.size();i++) { 
    if (predicate.test(labels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching labels. No match found.");
    return setNewLabelLike(index, buildLabel(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GroupRestrictionFluentImpl that = (GroupRestrictionFluentImpl) o;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(groups,  labels,  additionalProperties,  super.hashCode());
  }
  public class LabelsNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<N>> implements io.fabric8.openshift.api.model.GroupRestrictionFluent.LabelsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    LabelsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    LabelsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) GroupRestrictionFluentImpl.this.setToLabels(index,builder.build());
    }
    public N endLabel() {
      return and();
    }
    
  }
  
}