package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class GoogleIdentityProviderBuilder extends io.fabric8.openshift.api.model.GoogleIdentityProviderFluentImpl<io.fabric8.openshift.api.model.GoogleIdentityProviderBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.GoogleIdentityProvider,io.fabric8.openshift.api.model.GoogleIdentityProviderBuilder>{
  public GoogleIdentityProviderBuilder() {
    this(false);
  }
  public GoogleIdentityProviderBuilder(java.lang.Boolean validationEnabled) {
    this(new GoogleIdentityProvider(), validationEnabled);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GoogleIdentityProvider(), validationEnabled);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.GoogleIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.GoogleIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClientID(instance.getClientID()); 
    fluent.withClientSecret(instance.getClientSecret()); 
    fluent.withHostedDomain(instance.getHostedDomain()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProvider instance) {
    this(instance,false);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withHostedDomain(instance.getHostedDomain()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GoogleIdentityProvider build() {
    GoogleIdentityProvider buildable = new GoogleIdentityProvider(fluent.getClientID(),fluent.getClientSecret(),fluent.getHostedDomain());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GoogleIdentityProviderBuilder that = (GoogleIdentityProviderBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}