package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class SourceBuildStrategyFluentImpl<A extends io.fabric8.openshift.api.model.SourceBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.SourceBuildStrategyFluent<A>{
  public SourceBuildStrategyFluentImpl() {
  }
  public SourceBuildStrategyFluentImpl(io.fabric8.openshift.api.model.SourceBuildStrategy instance) {
    this.withEnv(instance.getEnv()); 
    this.withForcePull(instance.getForcePull()); 
    this.withFrom(instance.getFrom()); 
    this.withIncremental(instance.getIncremental()); 
    this.withPullSecret(instance.getPullSecret()); 
    this.withScripts(instance.getScripts()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();
  private java.lang.Boolean forcePull;
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder from;
  private java.lang.Boolean incremental;
  private io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder pullSecret;
  private java.lang.String scripts;
  private java.util.List<io.fabric8.openshift.api.model.BuildVolumeBuilder> volumes =  new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getEnv() {
    return this.env;
  }
  public io.fabric8.kubernetes.api.model.EnvVar getEnv(java.lang.Integer index) {
    return this.env.get(index);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env) {
    if (env != null) {this.env = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear();}
    if (env != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public java.lang.Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public java.lang.Boolean getForcePull() {
    return this.forcePull;
  }
  public A withForcePull(java.lang.Boolean forcePull) {
    this.forcePull=forcePull; return (A) this;
  }
  public java.lang.Boolean hasForcePull() {
    return this.forcePull != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
    return this.from!=null?this.from.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
    return this.from!=null?this.from.build():null;
  }
  public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
  }
  public java.lang.Boolean hasFrom() {
    return this.from != null;
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> withNewFrom() {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyFluentImpl.FromNestedImpl();
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyFluentImpl.FromNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public java.lang.Boolean getIncremental() {
    return this.incremental;
  }
  public A withIncremental(java.lang.Boolean incremental) {
    this.incremental=incremental; return (A) this;
  }
  public java.lang.Boolean hasIncremental() {
    return this.incremental != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.LocalObjectReference getPullSecret() {
    return this.pullSecret!=null?this.pullSecret.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildPullSecret() {
    return this.pullSecret!=null?this.pullSecret.build():null;
  }
  public A withPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    _visitables.get("pullSecret").remove(this.pullSecret);
    if (pullSecret!=null){ this.pullSecret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} return (A) this;
  }
  public java.lang.Boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  public A withNewPullSecret(java.lang.String name) {
    return (A)withPullSecret(new LocalObjectReference(name));
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyFluentImpl.PullSecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyFluentImpl.PullSecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
    return withNewPullSecretLike(getPullSecret());
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
  }
  public java.lang.String getScripts() {
    return this.scripts;
  }
  public A withScripts(java.lang.String scripts) {
    this.scripts=scripts; return (A) this;
  }
  public java.lang.Boolean hasScripts() {
    return this.scripts != null;
  }
  
  /**
   * Method is deprecated. use withScripts instead.
   */
  @java.lang.Deprecated
  public A withNewScripts(java.lang.String arg0) {
    return (A)withScripts(new String(arg0));
  }
  public A addToVolumes(java.lang.Integer index,io.fabric8.openshift.api.model.BuildVolume item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();}
    io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
  }
  public A setToVolumes(java.lang.Integer index,io.fabric8.openshift.api.model.BuildVolume item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();}
    io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
    if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
     return (A)this;
  }
  public A addToVolumes(io.fabric8.openshift.api.model.BuildVolume... items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();}
    for (io.fabric8.openshift.api.model.BuildVolume item : items) {io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(java.util.Collection<io.fabric8.openshift.api.model.BuildVolume> items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();}
    for (io.fabric8.openshift.api.model.BuildVolume item : items) {io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.openshift.api.model.BuildVolume... items) {
    for (io.fabric8.openshift.api.model.BuildVolume item : items) {io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(java.util.Collection<io.fabric8.openshift.api.model.BuildVolume> items) {
    for (io.fabric8.openshift.api.model.BuildVolume item : items) {io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildVolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.BuildVolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.BuildVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.BuildVolume> getVolumes() {
    return build(volumes);
  }
  public java.util.List<io.fabric8.openshift.api.model.BuildVolume> buildVolumes() {
    return build(volumes);
  }
  public io.fabric8.openshift.api.model.BuildVolume buildVolume(java.lang.Integer index) {
    return this.volumes.get(index).build();
  }
  public io.fabric8.openshift.api.model.BuildVolume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public io.fabric8.openshift.api.model.BuildVolume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.BuildVolume buildMatchingVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildVolumeBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildVolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildVolumeBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildVolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(java.util.List<io.fabric8.openshift.api.model.BuildVolume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
    if (volumes != null) {this.volumes = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.BuildVolume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.openshift.api.model.BuildVolume... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (io.fabric8.openshift.api.model.BuildVolume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<A> addNewVolume() {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyFluentImpl.VolumesNestedImpl();
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<A> addNewVolumeLike(io.fabric8.openshift.api.model.BuildVolume item) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyFluentImpl.VolumesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<A> setNewVolumeLike(java.lang.Integer index,io.fabric8.openshift.api.model.BuildVolume item) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyFluentImpl.VolumesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<A> editVolume(java.lang.Integer index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<A> editMatchingVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SourceBuildStrategyFluentImpl that = (SourceBuildStrategyFluentImpl) o;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
    if (from != null ? !from.equals(that.from) :that.from != null) return false;
    if (incremental != null ? !incremental.equals(that.incremental) :that.incremental != null) return false;
    if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
    if (scripts != null ? !scripts.equals(that.scripts) :that.scripts != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(env,  forcePull,  from,  incremental,  pullSecret,  scripts,  volumes,  additionalProperties,  super.hashCode());
  }
  public class FromNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<N>> implements io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) SourceBuildStrategyFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  public class PullSecretNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<N>> implements io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PullSecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
    }
    PullSecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) SourceBuildStrategyFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret() {
      return and();
    }
    
  }
  public class VolumesNestedImpl<N> extends io.fabric8.openshift.api.model.BuildVolumeFluentImpl<io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<N>> implements io.fabric8.openshift.api.model.SourceBuildStrategyFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VolumesNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.BuildVolume item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildVolumeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) SourceBuildStrategyFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}