package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OAuthBuilder extends io.fabric8.openshift.api.model.OAuthFluentImpl<io.fabric8.openshift.api.model.OAuthBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OAuth,io.fabric8.openshift.api.model.OAuthBuilder>{
  public OAuthBuilder() {
    this(false);
  }
  public OAuthBuilder(java.lang.Boolean validationEnabled) {
    this(new OAuth(), validationEnabled);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuthFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuth(), validationEnabled);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuthFluent<?> fluent,io.fabric8.openshift.api.model.OAuth instance) {
    this(fluent, instance, false);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuthFluent<?> fluent,io.fabric8.openshift.api.model.OAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuth instance) {
    this(instance,false);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuth build() {
    OAuth buildable = new OAuth(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OAuthBuilder that = (OAuthBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}