package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkSpecBuilder extends io.fabric8.openshift.api.model.NetworkSpecFluentImpl<io.fabric8.openshift.api.model.NetworkSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.NetworkSpec,io.fabric8.openshift.api.model.NetworkSpecBuilder>{
  public NetworkSpecBuilder() {
    this(false);
  }
  public NetworkSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new NetworkSpec(), validationEnabled);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkSpec(), validationEnabled);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent,io.fabric8.openshift.api.model.NetworkSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent,io.fabric8.openshift.api.model.NetworkSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterNetwork(instance.getClusterNetwork()); 
    fluent.withExternalIP(instance.getExternalIP()); 
    fluent.withNetworkType(instance.getNetworkType()); 
    fluent.withServiceNetwork(instance.getServiceNetwork()); 
    fluent.withServiceNodePortRange(instance.getServiceNodePortRange()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpec instance) {
    this(instance,false);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withExternalIP(instance.getExternalIP()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withServiceNodePortRange(instance.getServiceNodePortRange()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.NetworkSpec build() {
    NetworkSpec buildable = new NetworkSpec(fluent.getClusterNetwork(),fluent.getExternalIP(),fluent.getNetworkType(),fluent.getServiceNetwork(),fluent.getServiceNodePortRange());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkSpecBuilder that = (NetworkSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}