/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ProxySpec;
import io.fabric8.openshift.api.model.ProxySpecFluent;
import io.fabric8.openshift.api.model.ProxySpecFluentImpl;
import java.util.Objects;

public class ProxySpecBuilder
extends ProxySpecFluentImpl<ProxySpecBuilder>
implements VisitableBuilder<ProxySpec, ProxySpecBuilder> {
    ProxySpecFluent<?> fluent;
    Boolean validationEnabled;

    public ProxySpecBuilder() {
        this(false);
    }

    public ProxySpecBuilder(Boolean validationEnabled) {
        this(new ProxySpec(), validationEnabled);
    }

    public ProxySpecBuilder(ProxySpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ProxySpecBuilder(ProxySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ProxySpec(), validationEnabled);
    }

    public ProxySpecBuilder(ProxySpecFluent<?> fluent, ProxySpec instance) {
        this(fluent, instance, false);
    }

    public ProxySpecBuilder(ProxySpecFluent<?> fluent, ProxySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHttpProxy(instance.getHttpProxy());
        fluent.withHttpsProxy(instance.getHttpsProxy());
        fluent.withNoProxy(instance.getNoProxy());
        fluent.withReadinessEndpoints(instance.getReadinessEndpoints());
        fluent.withTrustedCA(instance.getTrustedCA());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ProxySpecBuilder(ProxySpec instance) {
        this(instance, (Boolean)false);
    }

    public ProxySpecBuilder(ProxySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHttpProxy(instance.getHttpProxy());
        this.withHttpsProxy(instance.getHttpsProxy());
        this.withNoProxy(instance.getNoProxy());
        this.withReadinessEndpoints(instance.getReadinessEndpoints());
        this.withTrustedCA(instance.getTrustedCA());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ProxySpec build() {
        ProxySpec buildable = new ProxySpec(this.fluent.getHttpProxy(), this.fluent.getHttpsProxy(), this.fluent.getNoProxy(), this.fluent.getReadinessEndpoints(), this.fluent.getTrustedCA());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProxySpecBuilder that = (ProxySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

