package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OAuthClientAuthorizationBuilder extends io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl<io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OAuthClientAuthorization,io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder>{
  public OAuthClientAuthorizationBuilder() {
    this(false);
  }
  public OAuthClientAuthorizationBuilder(java.lang.Boolean validationEnabled) {
    this(new OAuthClientAuthorization(), validationEnabled);
  }
  public OAuthClientAuthorizationBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthClientAuthorizationBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthClientAuthorization(), validationEnabled);
  }
  public OAuthClientAuthorizationBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClientAuthorization instance) {
    this(fluent, instance, false);
  }
  public OAuthClientAuthorizationBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClientAuthorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withClientName(instance.getClientName()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withScopes(instance.getScopes()); 
    fluent.withUserName(instance.getUserName()); 
    fluent.withUserUID(instance.getUserUID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthClientAuthorizationBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorization instance) {
    this(instance,false);
  }
  public OAuthClientAuthorizationBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withClientName(instance.getClientName()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withScopes(instance.getScopes()); 
    this.withUserName(instance.getUserName()); 
    this.withUserUID(instance.getUserUID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthClientAuthorization build() {
    OAuthClientAuthorization buildable = new OAuthClientAuthorization(fluent.getApiVersion(),fluent.getClientName(),fluent.getKind(),fluent.getMetadata(),fluent.getScopes(),fluent.getUserName(),fluent.getUserUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OAuthClientAuthorizationBuilder that = (OAuthClientAuthorizationBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}