package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class InfrastructureBuilder extends io.fabric8.openshift.api.model.InfrastructureFluentImpl<io.fabric8.openshift.api.model.InfrastructureBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.Infrastructure,io.fabric8.openshift.api.model.InfrastructureBuilder>{
  public InfrastructureBuilder() {
    this(false);
  }
  public InfrastructureBuilder(java.lang.Boolean validationEnabled) {
    this(new Infrastructure(), validationEnabled);
  }
  public InfrastructureBuilder(io.fabric8.openshift.api.model.InfrastructureFluent<?> fluent) {
    this(fluent, false);
  }
  public InfrastructureBuilder(io.fabric8.openshift.api.model.InfrastructureFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Infrastructure(), validationEnabled);
  }
  public InfrastructureBuilder(io.fabric8.openshift.api.model.InfrastructureFluent<?> fluent,io.fabric8.openshift.api.model.Infrastructure instance) {
    this(fluent, instance, false);
  }
  public InfrastructureBuilder(io.fabric8.openshift.api.model.InfrastructureFluent<?> fluent,io.fabric8.openshift.api.model.Infrastructure instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InfrastructureBuilder(io.fabric8.openshift.api.model.Infrastructure instance) {
    this(instance,false);
  }
  public InfrastructureBuilder(io.fabric8.openshift.api.model.Infrastructure instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.InfrastructureFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Infrastructure build() {
    Infrastructure buildable = new Infrastructure(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InfrastructureBuilder that = (InfrastructureBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}