package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class ComponentRouteStatusFluentImpl<A extends io.fabric8.openshift.api.model.ComponentRouteStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ComponentRouteStatusFluent<A>{
  public ComponentRouteStatusFluentImpl() {
  }
  public ComponentRouteStatusFluentImpl(io.fabric8.openshift.api.model.ComponentRouteStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withConsumingUsers(instance.getConsumingUsers()); 
    this.withCurrentHostnames(instance.getCurrentHostnames()); 
    this.withDefaultHostname(instance.getDefaultHostname()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withRelatedObjects(instance.getRelatedObjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();
  private java.util.List<java.lang.String> consumingUsers = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> currentHostnames = new java.util.ArrayList<java.lang.String>();
  private java.lang.String defaultHostname;
  private java.lang.String name;
  private java.lang.String namespace;
  private java.util.List<io.fabric8.openshift.api.model.ObjectReferenceBuilder> relatedObjects =  new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
    return this.conditions;
  }
  public io.fabric8.kubernetes.api.model.Condition getCondition(java.lang.Integer index) {
    return this.conditions.get(index);
  }
  public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addToConsumingUsers(java.lang.Integer index,java.lang.String item) {
    if (this.consumingUsers == null) {this.consumingUsers = new java.util.ArrayList<java.lang.String>();}
    this.consumingUsers.add(index, item);
    return (A)this;
  }
  public A setToConsumingUsers(java.lang.Integer index,java.lang.String item) {
    if (this.consumingUsers == null) {this.consumingUsers = new java.util.ArrayList<java.lang.String>();}
    this.consumingUsers.set(index, item); return (A)this;
  }
  public A addToConsumingUsers(java.lang.String... items) {
    if (this.consumingUsers == null) {this.consumingUsers = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.consumingUsers.add(item);} return (A)this;
  }
  public A addAllToConsumingUsers(java.util.Collection<java.lang.String> items) {
    if (this.consumingUsers == null) {this.consumingUsers = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.consumingUsers.add(item);} return (A)this;
  }
  public A removeFromConsumingUsers(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.consumingUsers!= null){ this.consumingUsers.remove(item);}} return (A)this;
  }
  public A removeAllFromConsumingUsers(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.consumingUsers!= null){ this.consumingUsers.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getConsumingUsers() {
    return this.consumingUsers;
  }
  public java.lang.String getConsumingUser(java.lang.Integer index) {
    return this.consumingUsers.get(index);
  }
  public java.lang.String getFirstConsumingUser() {
    return this.consumingUsers.get(0);
  }
  public java.lang.String getLastConsumingUser() {
    return this.consumingUsers.get(consumingUsers.size() - 1);
  }
  public java.lang.String getMatchingConsumingUser(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: consumingUsers) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingConsumingUser(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: consumingUsers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConsumingUsers(java.util.List<java.lang.String> consumingUsers) {
    if (consumingUsers != null) {this.consumingUsers = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : consumingUsers){this.addToConsumingUsers(item);}} else { this.consumingUsers = null;} return (A) this;
  }
  public A withConsumingUsers(java.lang.String... consumingUsers) {
    if (this.consumingUsers != null) {this.consumingUsers.clear();}
    if (consumingUsers != null) {for (java.lang.String item :consumingUsers){ this.addToConsumingUsers(item);}} return (A) this;
  }
  public java.lang.Boolean hasConsumingUsers() {
    return consumingUsers != null && !consumingUsers.isEmpty();
  }
  public A addNewConsumingUser(java.lang.String arg0) {
    return (A)addToConsumingUsers(new String(arg0));
  }
  public A addToCurrentHostnames(java.lang.Integer index,java.lang.String item) {
    if (this.currentHostnames == null) {this.currentHostnames = new java.util.ArrayList<java.lang.String>();}
    this.currentHostnames.add(index, item);
    return (A)this;
  }
  public A setToCurrentHostnames(java.lang.Integer index,java.lang.String item) {
    if (this.currentHostnames == null) {this.currentHostnames = new java.util.ArrayList<java.lang.String>();}
    this.currentHostnames.set(index, item); return (A)this;
  }
  public A addToCurrentHostnames(java.lang.String... items) {
    if (this.currentHostnames == null) {this.currentHostnames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.currentHostnames.add(item);} return (A)this;
  }
  public A addAllToCurrentHostnames(java.util.Collection<java.lang.String> items) {
    if (this.currentHostnames == null) {this.currentHostnames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.currentHostnames.add(item);} return (A)this;
  }
  public A removeFromCurrentHostnames(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.currentHostnames!= null){ this.currentHostnames.remove(item);}} return (A)this;
  }
  public A removeAllFromCurrentHostnames(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.currentHostnames!= null){ this.currentHostnames.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getCurrentHostnames() {
    return this.currentHostnames;
  }
  public java.lang.String getCurrentHostname(java.lang.Integer index) {
    return this.currentHostnames.get(index);
  }
  public java.lang.String getFirstCurrentHostname() {
    return this.currentHostnames.get(0);
  }
  public java.lang.String getLastCurrentHostname() {
    return this.currentHostnames.get(currentHostnames.size() - 1);
  }
  public java.lang.String getMatchingCurrentHostname(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: currentHostnames) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCurrentHostname(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: currentHostnames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCurrentHostnames(java.util.List<java.lang.String> currentHostnames) {
    if (currentHostnames != null) {this.currentHostnames = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : currentHostnames){this.addToCurrentHostnames(item);}} else { this.currentHostnames = null;} return (A) this;
  }
  public A withCurrentHostnames(java.lang.String... currentHostnames) {
    if (this.currentHostnames != null) {this.currentHostnames.clear();}
    if (currentHostnames != null) {for (java.lang.String item :currentHostnames){ this.addToCurrentHostnames(item);}} return (A) this;
  }
  public java.lang.Boolean hasCurrentHostnames() {
    return currentHostnames != null && !currentHostnames.isEmpty();
  }
  public A addNewCurrentHostname(java.lang.String arg0) {
    return (A)addToCurrentHostnames(new String(arg0));
  }
  public java.lang.String getDefaultHostname() {
    return this.defaultHostname;
  }
  public A withDefaultHostname(java.lang.String defaultHostname) {
    this.defaultHostname=defaultHostname; return (A) this;
  }
  public java.lang.Boolean hasDefaultHostname() {
    return this.defaultHostname != null;
  }
  
  /**
   * Method is deprecated. use withDefaultHostname instead.
   */
  @java.lang.Deprecated
  public A withNewDefaultHostname(java.lang.String arg0) {
    return (A)withDefaultHostname(new String(arg0));
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * Method is deprecated. use withName instead.
   */
  @java.lang.Deprecated
  public A withNewName(java.lang.String arg0) {
    return (A)withName(new String(arg0));
  }
  public java.lang.String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(java.lang.String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public java.lang.Boolean hasNamespace() {
    return this.namespace != null;
  }
  
  /**
   * Method is deprecated. use withNamespace instead.
   */
  @java.lang.Deprecated
  public A withNewNamespace(java.lang.String arg0) {
    return (A)withNamespace(new String(arg0));
  }
  public A addToRelatedObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(index >= 0 ? index : _visitables.get("relatedObjects").size(), builder);this.relatedObjects.add(index >= 0 ? index : relatedObjects.size(), builder); return (A)this;
  }
  public A setToRelatedObjects(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("relatedObjects").size()) { _visitables.get("relatedObjects").add(builder); } else { _visitables.get("relatedObjects").set(index, builder);}
    if (index < 0 || index >= relatedObjects.size()) { relatedObjects.add(builder); } else { relatedObjects.set(index, builder);}
     return (A)this;
  }
  public A addToRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A addAllToRelatedObjects(java.util.Collection<io.fabric8.openshift.api.model.ObjectReference> items) {
    if (this.relatedObjects == null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A removeFromRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items) {
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelatedObjects(java.util.Collection<io.fabric8.openshift.api.model.ObjectReference> items) {
    for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelatedObjects(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    if (relatedObjects == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ObjectReferenceBuilder> each = relatedObjects.iterator();
    final List visitables = _visitables.get("relatedObjects");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelatedObjects instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ObjectReference> getRelatedObjects() {
    return build(relatedObjects);
  }
  public java.util.List<io.fabric8.openshift.api.model.ObjectReference> buildRelatedObjects() {
    return build(relatedObjects);
  }
  public io.fabric8.openshift.api.model.ObjectReference buildRelatedObject(java.lang.Integer index) {
    return this.relatedObjects.get(index).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildFirstRelatedObject() {
    return this.relatedObjects.get(0).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildLastRelatedObject() {
    return this.relatedObjects.get(relatedObjects.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ObjectReference buildMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedObjects(java.util.List<io.fabric8.openshift.api.model.ObjectReference> relatedObjects) {
    if (this.relatedObjects != null) { _visitables.get("relatedObjects").removeAll(this.relatedObjects);}
    if (relatedObjects != null) {this.relatedObjects = new java.util.ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>(); for (io.fabric8.openshift.api.model.ObjectReference item : relatedObjects){this.addToRelatedObjects(item);}} else { this.relatedObjects = null;} return (A) this;
  }
  public A withRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... relatedObjects) {
    if (this.relatedObjects != null) {this.relatedObjects.clear();}
    if (relatedObjects != null) {for (io.fabric8.openshift.api.model.ObjectReference item :relatedObjects){ this.addToRelatedObjects(item);}} return (A) this;
  }
  public java.lang.Boolean hasRelatedObjects() {
    return relatedObjects != null && !relatedObjects.isEmpty();
  }
  public A addNewRelatedObject(java.lang.String group,java.lang.String name,java.lang.String namespace,java.lang.String resource) {
    return (A)addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
  }
  public io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<A> addNewRelatedObject() {
    return new io.fabric8.openshift.api.model.ComponentRouteStatusFluentImpl.RelatedObjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(io.fabric8.openshift.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ComponentRouteStatusFluentImpl.RelatedObjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ComponentRouteStatusFluentImpl.RelatedObjectsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<A> editRelatedObject(java.lang.Integer index) {
    if (relatedObjects.size() <= index) throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject() {
    if (relatedObjects.size() == 0) throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(0, buildRelatedObject(0));
  }
  public io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<A> editLastRelatedObject() {
    int index = relatedObjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(java.util.function.Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedObjects.size();i++) { 
    if (predicate.test(relatedObjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ComponentRouteStatusFluentImpl that = (ComponentRouteStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (consumingUsers != null ? !consumingUsers.equals(that.consumingUsers) :that.consumingUsers != null) return false;
    if (currentHostnames != null ? !currentHostnames.equals(that.currentHostnames) :that.currentHostnames != null) return false;
    if (defaultHostname != null ? !defaultHostname.equals(that.defaultHostname) :that.defaultHostname != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (relatedObjects != null ? !relatedObjects.equals(that.relatedObjects) :that.relatedObjects != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  consumingUsers,  currentHostnames,  defaultHostname,  name,  namespace,  relatedObjects,  additionalProperties,  super.hashCode());
  }
  public class RelatedObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<N>> implements io.fabric8.openshift.api.model.ComponentRouteStatusFluent.RelatedObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RelatedObjectsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ObjectReference item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(this, item);
    }
    RelatedObjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.ObjectReferenceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ComponentRouteStatusFluentImpl.this.setToRelatedObjects(index,builder.build());
    }
    public N endRelatedObject() {
      return and();
    }
    
  }
  
}