package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ProxySpecBuilder extends io.fabric8.openshift.api.model.ProxySpecFluentImpl<io.fabric8.openshift.api.model.ProxySpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ProxySpec,io.fabric8.openshift.api.model.ProxySpecBuilder>{
  public ProxySpecBuilder() {
    this(false);
  }
  public ProxySpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ProxySpec(), validationEnabled);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProxySpec(), validationEnabled);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent,io.fabric8.openshift.api.model.ProxySpec instance) {
    this(fluent, instance, false);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent,io.fabric8.openshift.api.model.ProxySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHttpProxy(instance.getHttpProxy()); 
    fluent.withHttpsProxy(instance.getHttpsProxy()); 
    fluent.withNoProxy(instance.getNoProxy()); 
    fluent.withReadinessEndpoints(instance.getReadinessEndpoints()); 
    fluent.withTrustedCA(instance.getTrustedCA()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpec instance) {
    this(instance,false);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.withReadinessEndpoints(instance.getReadinessEndpoints()); 
    this.withTrustedCA(instance.getTrustedCA()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ProxySpec build() {
    ProxySpec buildable = new ProxySpec(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getReadinessEndpoints(),fluent.getTrustedCA());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProxySpecBuilder that = (ProxySpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}