package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ObjectReferenceBuilder extends io.fabric8.openshift.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ObjectReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ObjectReference,io.fabric8.openshift.api.model.ObjectReferenceBuilder>{
  public ObjectReferenceBuilder() {
    this(false);
  }
  public ObjectReferenceBuilder(java.lang.Boolean validationEnabled) {
    this(new ObjectReference(), validationEnabled);
  }
  public ObjectReferenceBuilder(io.fabric8.openshift.api.model.ObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectReferenceBuilder(io.fabric8.openshift.api.model.ObjectReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ObjectReference(), validationEnabled);
  }
  public ObjectReferenceBuilder(io.fabric8.openshift.api.model.ObjectReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ObjectReference instance) {
    this(fluent, instance, false);
  }
  public ObjectReferenceBuilder(io.fabric8.openshift.api.model.ObjectReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withResource(instance.getResource()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ObjectReferenceBuilder(io.fabric8.openshift.api.model.ObjectReference instance) {
    this(instance,false);
  }
  public ObjectReferenceBuilder(io.fabric8.openshift.api.model.ObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withResource(instance.getResource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ObjectReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ObjectReference build() {
    ObjectReference buildable = new ObjectReference(fluent.getGroup(),fluent.getName(),fluent.getNamespace(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ObjectReferenceBuilder that = (ObjectReferenceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}