package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OAuthAccessTokenBuilder extends io.fabric8.openshift.api.model.OAuthAccessTokenFluentImpl<io.fabric8.openshift.api.model.OAuthAccessTokenBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OAuthAccessToken,io.fabric8.openshift.api.model.OAuthAccessTokenBuilder>{
  public OAuthAccessTokenBuilder() {
    this(false);
  }
  public OAuthAccessTokenBuilder(java.lang.Boolean validationEnabled) {
    this(new OAuthAccessToken(), validationEnabled);
  }
  public OAuthAccessTokenBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthAccessTokenBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthAccessToken(), validationEnabled);
  }
  public OAuthAccessTokenBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenFluent<?> fluent,io.fabric8.openshift.api.model.OAuthAccessToken instance) {
    this(fluent, instance, false);
  }
  public OAuthAccessTokenBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenFluent<?> fluent,io.fabric8.openshift.api.model.OAuthAccessToken instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withAuthorizeToken(instance.getAuthorizeToken()); 
    fluent.withClientName(instance.getClientName()); 
    fluent.withExpiresIn(instance.getExpiresIn()); 
    fluent.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRedirectURI(instance.getRedirectURI()); 
    fluent.withRefreshToken(instance.getRefreshToken()); 
    fluent.withScopes(instance.getScopes()); 
    fluent.withUserName(instance.getUserName()); 
    fluent.withUserUID(instance.getUserUID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthAccessTokenBuilder(io.fabric8.openshift.api.model.OAuthAccessToken instance) {
    this(instance,false);
  }
  public OAuthAccessTokenBuilder(io.fabric8.openshift.api.model.OAuthAccessToken instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withAuthorizeToken(instance.getAuthorizeToken()); 
    this.withClientName(instance.getClientName()); 
    this.withExpiresIn(instance.getExpiresIn()); 
    this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRedirectURI(instance.getRedirectURI()); 
    this.withRefreshToken(instance.getRefreshToken()); 
    this.withScopes(instance.getScopes()); 
    this.withUserName(instance.getUserName()); 
    this.withUserUID(instance.getUserUID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthAccessTokenFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthAccessToken build() {
    OAuthAccessToken buildable = new OAuthAccessToken(fluent.getApiVersion(),fluent.getAuthorizeToken(),fluent.getClientName(),fluent.getExpiresIn(),fluent.getInactivityTimeoutSeconds(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURI(),fluent.getRefreshToken(),fluent.getScopes(),fluent.getUserName(),fluent.getUserUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OAuthAccessTokenBuilder that = (OAuthAccessTokenBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}